/*
 * Decompiled with CFR 0.152.
 */
package com.securionpay;

import com.securionpay.connection.Connection;
import com.securionpay.connection.HttpClientConnection;
import com.securionpay.connection.Response;
import com.securionpay.enums.FileUploadPurpose;
import com.securionpay.exception.SecurionPayException;
import com.securionpay.exception.SignException;
import com.securionpay.request.BlacklistRuleListRequest;
import com.securionpay.request.BlacklistRuleRequest;
import com.securionpay.request.CaptureRequest;
import com.securionpay.request.CardListRequest;
import com.securionpay.request.CardRequest;
import com.securionpay.request.CardUpdateRequest;
import com.securionpay.request.ChargeListRequest;
import com.securionpay.request.ChargeRequest;
import com.securionpay.request.ChargeUpdateRequest;
import com.securionpay.request.CheckoutRequest;
import com.securionpay.request.CreditListRequest;
import com.securionpay.request.CreditRequest;
import com.securionpay.request.CreditUpdateRequest;
import com.securionpay.request.CrossSaleOfferListRequest;
import com.securionpay.request.CrossSaleOfferRequest;
import com.securionpay.request.CrossSaleOfferUpdateRequest;
import com.securionpay.request.CustomerListRequest;
import com.securionpay.request.CustomerRequest;
import com.securionpay.request.CustomerUpdateRequest;
import com.securionpay.request.DisputeListRequest;
import com.securionpay.request.DisputeUpdateRequest;
import com.securionpay.request.EventListRequest;
import com.securionpay.request.FileUploadListRequest;
import com.securionpay.request.PlanListRequest;
import com.securionpay.request.PlanRequest;
import com.securionpay.request.PlanUpdateRequest;
import com.securionpay.request.RefundRequest;
import com.securionpay.request.SubscriptionCancelRequest;
import com.securionpay.request.SubscriptionListRequest;
import com.securionpay.request.SubscriptionRequest;
import com.securionpay.request.SubscriptionUpdateRequest;
import com.securionpay.request.TokenRequest;
import com.securionpay.response.BlacklistRule;
import com.securionpay.response.Card;
import com.securionpay.response.Charge;
import com.securionpay.response.Credit;
import com.securionpay.response.CrossSaleOffer;
import com.securionpay.response.Customer;
import com.securionpay.response.DeleteResponse;
import com.securionpay.response.Dispute;
import com.securionpay.response.ErrorResponse;
import com.securionpay.response.Event;
import com.securionpay.response.FileUpload;
import com.securionpay.response.ListResponse;
import com.securionpay.response.Plan;
import com.securionpay.response.Subscription;
import com.securionpay.response.Token;
import com.securionpay.util.Base64;
import com.securionpay.util.ObjectSerializer;
import com.securionpay.util.SecurionPayUtils;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import javax.crypto.Mac;
import javax.crypto.spec.SecretKeySpec;
import org.apache.commons.codec.binary.Hex;

public class SecurionPayGateway
implements Closeable {
    public static final String DEFAULT_ENDPOINT = "https://api.securionpay.com/";
    public static final String UPLOADS_ENDPOINT = "https://uploads.securionpay.com/";
    private static final String CHARGES_PATH = "/charges";
    private static final String TOKENS_PATH = "/tokens";
    private static final String CUSTOMERS_PATH = "/customers";
    private static final String CARDS_PATH = "/customers/%s/cards";
    private static final String PLANS_PATH = "/plans";
    private static final String SUBSCRIPTIONS_PATH = "/customers/%s/subscriptions";
    private static final String EVENTS_PATH = "/events";
    private static final String BLACKLIST_RULE_PATH = "/blacklist";
    private static final String CROSS_SALE_OFFER_PATH = "/cross-sale-offers";
    private static final String CREDIT_PATH = "/credits";
    private static final String FILES_PATH = "/files";
    private static final String DISPUTES_PATH = "/disputes";
    private static final String UTF_8 = "UTF-8";
    private final ObjectSerializer objectSerializer = ObjectSerializer.INSTANCE;
    private Connection connection;
    private String privateKey;
    private String endpoint = "https://api.securionpay.com/";
    private String uploadsEndpoint = "https://uploads.securionpay.com/";

    public SecurionPayGateway() {
        this(null);
    }

    public SecurionPayGateway(String privateKey) {
        this(privateKey, new HttpClientConnection());
    }

    public SecurionPayGateway(String privateKey, Connection connection) {
        this.privateKey = privateKey;
        this.connection = connection;
    }

    public Charge createCharge(ChargeRequest request) {
        return this.post(CHARGES_PATH, request, Charge.class);
    }

    public Charge captureCharge(CaptureRequest request) {
        return this.post("/charges/" + request.getChargeId() + "/capture", request, Charge.class);
    }

    public Charge retrieveCharge(String chargeId) {
        return this.get("/charges/" + chargeId, Charge.class);
    }

    public Charge updateCharge(ChargeUpdateRequest request) {
        return this.post("/charges/" + request.getChargeId(), request, Charge.class);
    }

    public Charge refundCharge(RefundRequest request) {
        return this.post("/charges/" + request.getChargeId() + "/refund", request, Charge.class);
    }

    public ListResponse<Charge> listCharges() {
        return this.list(CHARGES_PATH, Charge.class);
    }

    public ListResponse<Charge> listCharges(ChargeListRequest request) {
        return this.list(CHARGES_PATH, request, Charge.class);
    }

    public Customer createCustomer(CustomerRequest request) {
        return this.post(CUSTOMERS_PATH, request, Customer.class);
    }

    public Customer retrieveCustomer(String customerId) {
        return this.get("/customers/" + customerId, Customer.class);
    }

    public Customer updateCustomer(CustomerUpdateRequest request) {
        return this.post("/customers/" + request.getCustomerId(), request, Customer.class);
    }

    public DeleteResponse deleteCustomer(String customerId) {
        return this.delete("/customers/" + customerId, DeleteResponse.class);
    }

    public ListResponse<Customer> listCustomers() {
        return this.list(CUSTOMERS_PATH, Customer.class);
    }

    public ListResponse<Customer> listCustomers(CustomerListRequest request) {
        return this.list(CUSTOMERS_PATH, request, Customer.class);
    }

    public Card createCard(CardRequest request) {
        return this.post(String.format(CARDS_PATH, request.getCustomerId()), request, Card.class);
    }

    public Card retrieveCard(String customerId, String cardId) {
        return this.get(String.format(CARDS_PATH, customerId) + "/" + cardId, Card.class);
    }

    public Card updateCard(CardUpdateRequest card) {
        return this.post(String.format(CARDS_PATH, card.getCustomerId()) + "/" + card.getCardId(), card, Card.class);
    }

    public DeleteResponse deleteCard(String customerId, String cardId) {
        return this.delete(String.format(CARDS_PATH, customerId) + "/" + cardId, DeleteResponse.class);
    }

    public ListResponse<Card> listCards(String customerId) {
        return this.listCards(new CardListRequest().customerId(customerId));
    }

    public ListResponse<Card> listCards(CardListRequest listCards) {
        return this.list(String.format(CARDS_PATH, listCards.getCustomerId()), listCards, Card.class);
    }

    public Subscription createSubscription(SubscriptionRequest request) {
        return this.post(String.format(SUBSCRIPTIONS_PATH, request.getCustomerId()), request, Subscription.class);
    }

    public Subscription retrieveSubscription(String customerId, String subscriptionId) {
        return this.get(String.format(SUBSCRIPTIONS_PATH, customerId) + "/" + subscriptionId, Subscription.class);
    }

    public Subscription updateSubscription(SubscriptionUpdateRequest request) {
        return this.post(String.format(SUBSCRIPTIONS_PATH, request.getCustomerId()) + "/" + request.getSubscriptionId(), request, Subscription.class);
    }

    public Subscription cancelSubscription(SubscriptionCancelRequest request) {
        return this.delete(String.format(SUBSCRIPTIONS_PATH, request.getCustomerId()) + "/" + request.getSubscriptionId(), request, Subscription.class);
    }

    public ListResponse<Subscription> listSubscriptions(String customerId) {
        return this.list(String.format(SUBSCRIPTIONS_PATH, customerId), Subscription.class);
    }

    public ListResponse<Subscription> listSubscriptions(SubscriptionListRequest request) {
        return this.list(String.format(SUBSCRIPTIONS_PATH, request.getCustomerId()), request, Subscription.class);
    }

    public Plan createPlan(PlanRequest request) {
        return this.post(PLANS_PATH, request, Plan.class);
    }

    public Plan retrievePlan(String planId) {
        return this.get("/plans/" + planId, Plan.class);
    }

    public Plan updatePlan(PlanUpdateRequest request) {
        return this.post("/plans/" + request.getPlanId(), request, Plan.class);
    }

    public DeleteResponse deletePlan(String planId) {
        return this.delete("/plans/" + planId, DeleteResponse.class);
    }

    public ListResponse<Plan> listPlans() {
        return this.list(PLANS_PATH, Plan.class);
    }

    public ListResponse<Plan> listPlans(PlanListRequest request) {
        return this.list(PLANS_PATH, request, Plan.class);
    }

    public Event retrieveEvent(String eventId) {
        return this.get(String.format("/events/" + eventId, new Object[0]), Event.class);
    }

    public ListResponse<Event> listEvents() {
        return this.list(EVENTS_PATH, Event.class);
    }

    public ListResponse<Event> listEvents(EventListRequest listEvents) {
        return this.list(EVENTS_PATH, listEvents, Event.class);
    }

    public Token createToken(TokenRequest request) {
        return this.post(TOKENS_PATH, request, Token.class);
    }

    public Token retrieveToken(String tokenId) {
        return this.get("/tokens/" + tokenId, Token.class);
    }

    public BlacklistRule createBlacklistRule(BlacklistRuleRequest request) {
        return this.post(BLACKLIST_RULE_PATH, request, BlacklistRule.class);
    }

    public BlacklistRule retrieveBlacklistRule(String blacklistRuleId) {
        return this.get("/blacklist/" + blacklistRuleId, BlacklistRule.class);
    }

    public DeleteResponse deleteBlacklistRule(String blacklistRuleId) {
        return this.delete("/blacklist/" + blacklistRuleId, DeleteResponse.class);
    }

    public ListResponse<BlacklistRule> listBlacklistRules() {
        return this.list(BLACKLIST_RULE_PATH, BlacklistRule.class);
    }

    public ListResponse<BlacklistRule> listBlacklistRules(BlacklistRuleListRequest request) {
        return this.list(BLACKLIST_RULE_PATH, request, BlacklistRule.class);
    }

    public CrossSaleOffer createCrossSaleOffer(CrossSaleOfferRequest request) {
        return this.post(CROSS_SALE_OFFER_PATH, request, CrossSaleOffer.class);
    }

    public CrossSaleOffer retrieveCrossSaleOffer(String crossSaleOfferId) {
        return this.get("/cross-sale-offers/" + crossSaleOfferId, CrossSaleOffer.class);
    }

    public CrossSaleOffer updateCrossSaleOffer(CrossSaleOfferUpdateRequest request) {
        return this.post("/cross-sale-offers/" + request.getCrossSaleOfferId(), request, CrossSaleOffer.class);
    }

    public DeleteResponse deleteCrossSaleOffer(String crossSaleOfferId) {
        return this.delete("/cross-sale-offers/" + crossSaleOfferId, DeleteResponse.class);
    }

    public ListResponse<CrossSaleOffer> listCrossSaleOffers() {
        return this.list(CROSS_SALE_OFFER_PATH, CrossSaleOffer.class);
    }

    public ListResponse<CrossSaleOffer> listCrossSaleOffers(CrossSaleOfferListRequest request) {
        return this.list(CROSS_SALE_OFFER_PATH, request, CrossSaleOffer.class);
    }

    public Credit createCredit(CreditRequest request) {
        return this.post(CREDIT_PATH, request, Credit.class);
    }

    public Credit retrieveCredit(String creditId) {
        return this.get("/credits/" + creditId, Credit.class);
    }

    public Credit updateCredit(CreditUpdateRequest credit) {
        return this.post("/credits/" + credit.getCreditId(), credit, Credit.class);
    }

    public ListResponse<Credit> listCredits() {
        return this.list(CREDIT_PATH, Credit.class);
    }

    public ListResponse<Credit> listCredits(CreditListRequest request) {
        return this.list(CREDIT_PATH, request, Credit.class);
    }

    public String signCheckoutRequest(CheckoutRequest checkoutRequest) {
        String data = this.objectSerializer.serialize(checkoutRequest);
        try {
            String algorithm = "HmacSHA256";
            Mac hmac = Mac.getInstance(algorithm);
            hmac.init(new SecretKeySpec(this.privateKey.getBytes(UTF_8), algorithm));
            String signature = Hex.encodeHexString((byte[])hmac.doFinal(data.getBytes(UTF_8)));
            return org.apache.commons.codec.binary.Base64.encodeBase64String((byte[])(signature + "|" + data).getBytes(UTF_8));
        }
        catch (Exception ex) {
            throw new SignException(ex);
        }
    }

    public FileUpload createFileUpload(File file, FileUploadPurpose purpose) {
        HashMap<String, File> files = new HashMap<String, File>();
        files.put("file", file);
        HashMap<String, String> form = new HashMap<String, String>();
        form.put("purpose", purpose.getValue());
        return this.multipart(FILES_PATH, files, form, FileUpload.class);
    }

    public FileUpload retrieveFileUpload(String id) {
        return this.get(this.uploadsEndpoint, "/files/" + id, FileUpload.class);
    }

    public ListResponse<FileUpload> listFileUploads() {
        return this.list(this.uploadsEndpoint, FILES_PATH, null, FileUpload.class);
    }

    public ListResponse<FileUpload> listFileUploads(FileUploadListRequest request) {
        return this.list(this.uploadsEndpoint, FILES_PATH, request, FileUpload.class);
    }

    public Dispute retrieveDispute(String id) {
        return this.get("/disputes/" + id, Dispute.class);
    }

    public Dispute updateDispute(String id, DisputeUpdateRequest request) {
        return this.post("/disputes/" + id, request, Dispute.class);
    }

    public Dispute closeDispute(String id) {
        return this.post("/disputes/" + id + "/close", null, Dispute.class);
    }

    public ListResponse<Dispute> listDisputes() {
        return this.list(DISPUTES_PATH, null, Dispute.class);
    }

    public ListResponse<Dispute> listDisputes(DisputeListRequest request) {
        return this.list(DISPUTES_PATH, request, Dispute.class);
    }

    @Override
    public void close() throws IOException {
        if (this.connection != null) {
            this.connection.close();
        }
    }

    protected <T> T get(String path, Class<T> responseClass) {
        return this.get(this.endpoint, path, responseClass);
    }

    protected <T> T get(String endpoint, String path, Class<T> responseClass) {
        Response response = this.connection.get(endpoint + path, this.buildHeaders());
        this.ensureSuccess(response);
        return this.objectSerializer.deserialize(response.getBody(), responseClass);
    }

    protected <T> T post(String path, Object request, Class<T> responseClass) {
        String requestBody = this.objectSerializer.serialize(request);
        Response response = this.connection.post(this.endpoint + path, requestBody, this.buildHeaders());
        this.ensureSuccess(response);
        return this.objectSerializer.deserialize(response.getBody(), responseClass);
    }

    protected <T> T multipart(String path, Map<String, File> files, Map<String, String> form, Class<T> responseClass) {
        Response response = this.connection.multipart(this.uploadsEndpoint + path, files, form, this.buildHeaders());
        this.ensureSuccess(response);
        return this.objectSerializer.deserialize(response.getBody(), responseClass);
    }

    protected <T> ListResponse<T> list(String path, Class<T> elementClass) {
        return this.list(this.endpoint, path, null, elementClass);
    }

    protected <T> ListResponse<T> list(String path, Object request, Class<T> elementClass) {
        return this.list(this.endpoint, path, request, elementClass);
    }

    protected <T> ListResponse<T> list(String endpoint, String path, Object request, Class<T> elementClass) {
        String url = this.buildQueryString(endpoint + path, request);
        Response response = this.connection.get(url, this.buildHeaders());
        this.ensureSuccess(response);
        return this.objectSerializer.deserializeList(response.getBody(), elementClass);
    }

    protected <T> T delete(String path, Class<T> responseClass) {
        return this.delete(path, null, responseClass);
    }

    protected <T> T delete(String path, Object request, Class<T> responseClass) {
        String url = this.buildQueryString(this.endpoint + path, request);
        Response response = this.connection.delete(url, this.buildHeaders());
        this.ensureSuccess(response);
        return this.objectSerializer.deserialize(response.getBody(), responseClass);
    }

    private Response ensureSuccess(Response response) {
        if (response.getStatus() != 200) {
            ErrorResponse error = this.objectSerializer.deserialize(response.getBody(), ErrorResponse.class);
            throw new SecurionPayException(error);
        }
        return response;
    }

    private String buildQueryString(String url, Object request) {
        if (request == null) {
            return url;
        }
        return url + this.objectSerializer.serializeToQueryString(request);
    }

    protected Map<String, String> buildHeaders() {
        HashMap<String, String> headers = new HashMap<String, String>();
        headers.put("Authorization", "Basic " + Base64.encode((this.privateKey + ":").getBytes()));
        headers.put("Content-Type", "application/json");
        headers.put("User-Agent", "SecurionPay-Java/" + SecurionPayUtils.getBuildVersion() + " (Java/" + SecurionPayUtils.getJavaVersion() + ")");
        return headers;
    }

    public void setPrivateKey(String privateKey) {
        this.privateKey = privateKey;
    }

    public void setConnection(Connection connection) {
        this.connection = connection;
    }

    public void setEndpoint(String endpoint) {
        this.endpoint = endpoint;
    }

    public void setUploadsEndpoint(String uploadsEndpoint) {
        this.uploadsEndpoint = uploadsEndpoint;
    }
}

