/*
 * Decompiled with CFR 0.152.
 */
package com.securionpay.response;

import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.securionpay.enums.CardBrand;
import com.securionpay.enums.CardType;
import com.securionpay.response.FraudCheckData;
import com.securionpay.util.SecurionPayUtils;
import java.util.HashMap;
import java.util.Map;

public class Card {
    private String id;
    private Long created;
    private boolean deleted = false;
    private String first6;
    private String last4;
    private String fingerprint;
    private String expMonth;
    private String expYear;
    private String cardholderName;
    private String customerId;
    private String brand;
    private String type;
    private String country;
    private String addressLine1;
    private String addressLine2;
    private String addressCity;
    private String addressState;
    private String addressZip;
    private String addressCountry;
    private FraudCheckData fraudCheckData;
    private String issuer;
    @JsonIgnore
    private final Map<String, Object> other = new HashMap<String, Object>();

    public String getId() {
        return this.id;
    }

    public Long getCreated() {
        return this.created;
    }

    public boolean isDeleted() {
        return this.deleted;
    }

    public String getFirst6() {
        return this.first6;
    }

    public String getLast4() {
        return this.last4;
    }

    public String getFingerprint() {
        return this.fingerprint;
    }

    public String getExpMonth() {
        return this.expMonth;
    }

    public String getExpYear() {
        return this.expYear;
    }

    public String getCardholderName() {
        return this.cardholderName;
    }

    public String getCustomerId() {
        return this.customerId;
    }

    public CardBrand getBrand() {
        return CardBrand.fromValue(this.brand);
    }

    public String getBrandAsString() {
        return this.brand;
    }

    public CardType getType() {
        return CardType.fromValue(this.type);
    }

    public String getTypeAsString() {
        return this.type;
    }

    public String getCountry() {
        return this.country;
    }

    public String getAddressLine1() {
        return this.addressLine1;
    }

    public String getAddressLine2() {
        return this.addressLine2;
    }

    public String getAddressCity() {
        return this.addressCity;
    }

    public String getAddressState() {
        return this.addressState;
    }

    public String getAddressZip() {
        return this.addressZip;
    }

    public String getAddressCountry() {
        return this.addressCountry;
    }

    public FraudCheckData getFraudCheckData() {
        return this.fraudCheckData;
    }

    public String getIssuer() {
        return this.issuer;
    }

    public String get(String name) {
        return SecurionPayUtils.toStringNullSafe(this.other.get(name));
    }

    @JsonAnySetter
    private void set(String name, Object value) {
        this.other.put(name, value);
    }
}

