/*
 * Decompiled with CFR 0.152.
 */
package com.securionpay.response;

import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.securionpay.enums.ErrorCode;
import com.securionpay.enums.ErrorType;
import com.securionpay.util.SecurionPayUtils;
import java.util.HashMap;
import java.util.Map;

public class ErrorResponse {
    private ErrorData error;

    public String getMessage() {
        return this.error.getMessage();
    }

    public ErrorType getType() {
        return this.error.getType();
    }

    public String getTypeAsString() {
        return this.error.getCodeAsString();
    }

    public ErrorCode getCode() {
        return this.error.getCode();
    }

    public String getCodeAsString() {
        return this.error.getCodeAsString();
    }

    public String getIssuerDeclineCode() {
        return this.error.getIssuerDeclineCode();
    }

    public String getChargeId() {
        return this.error.getChargeId();
    }

    public String getCreditId() {
        return this.error.getCreditId();
    }

    public String getBlacklistRuleId() {
        return this.error.getBlacklistRuleId();
    }

    public String getAlertRuleId() {
        return this.error.getAlertRuleId();
    }

    public String getAlertId() {
        return this.error.getAlertId();
    }

    public Map<String, Object> getOther() {
        return this.error.getOther();
    }

    public String get(String name) {
        return this.error.get(name);
    }

    public static class ErrorData {
        private String message;
        private String type;
        private String code;
        private String issuerDeclineCode;
        private String chargeId;
        private String creditId;
        private String blacklistRuleId;
        private String alertRuleId;
        private String alertId;
        @JsonIgnore
        private Map<String, Object> other = new HashMap<String, Object>();

        public String getMessage() {
            return this.message;
        }

        public ErrorType getType() {
            return ErrorType.fromValue(this.type);
        }

        public String getTypeAsString() {
            return this.type;
        }

        public ErrorCode getCode() {
            return ErrorCode.fromValue(this.code);
        }

        public String getCodeAsString() {
            return this.code;
        }

        public String getIssuerDeclineCode() {
            return this.issuerDeclineCode;
        }

        public String getChargeId() {
            return this.chargeId;
        }

        public String getCreditId() {
            return this.creditId;
        }

        public String getBlacklistRuleId() {
            return this.blacklistRuleId;
        }

        public String getAlertRuleId() {
            return this.alertRuleId;
        }

        public String getAlertId() {
            return this.alertId;
        }

        public Map<String, Object> getOther() {
            return this.other;
        }

        public String get(String name) {
            return SecurionPayUtils.toStringNullSafe(this.other.get(name));
        }

        @JsonAnySetter
        private void set(String name, Object value) {
            this.other.put(name, value);
        }
    }
}

