/*
 * Decompiled with CFR 0.152.
 */
package com.securionpay.connection;

import com.securionpay.connection.Connection;
import com.securionpay.connection.Response;
import com.securionpay.exception.ConnectionException;
import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.util.Map;
import org.apache.http.HttpEntity;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpDelete;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.StringEntity;
import org.apache.http.entity.mime.MultipartEntityBuilder;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.util.EntityUtils;

public class HttpClientConnection
implements Connection {
    private static final Charset UTF8 = Charset.forName("UTF-8");
    private final CloseableHttpClient httpClient;

    public HttpClientConnection() {
        this(HttpClientBuilder.create().build());
    }

    public HttpClientConnection(CloseableHttpClient httpClient) {
        this.httpClient = httpClient;
    }

    @Override
    public Response get(String url, Map<String, String> headers) {
        return this.execute((HttpUriRequest)new HttpGet(url), headers);
    }

    @Override
    public Response post(String url, String requestBody, Map<String, String> headers) {
        HttpPost post = new HttpPost(url);
        if (requestBody != null) {
            post.setEntity((HttpEntity)new StringEntity(requestBody, UTF8));
        }
        return this.execute((HttpUriRequest)post, headers);
    }

    @Override
    public Response delete(String url, Map<String, String> headers) {
        return this.execute((HttpUriRequest)new HttpDelete(url), headers);
    }

    @Override
    public Response multipart(String url, Map<String, File> files, Map<String, String> form, Map<String, String> headers) {
        MultipartEntityBuilder builder = MultipartEntityBuilder.create();
        for (Map.Entry<String, File> entry : files.entrySet()) {
            builder.addBinaryBody(entry.getKey(), entry.getValue());
        }
        for (Map.Entry<String, Object> entry : form.entrySet()) {
            builder.addTextBody(entry.getKey(), (String)entry.getValue());
        }
        HttpPost httpPost = new HttpPost(url);
        httpPost.setEntity(builder.build());
        headers.remove("Content-Type");
        return this.execute((HttpUriRequest)httpPost, headers);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private Response execute(HttpUriRequest request, Map<String, String> headers) {
        for (Map.Entry<String, String> header : headers.entrySet()) {
            String headerName = header.getKey();
            String headerValue = header.getValue();
            if ("User-Agent".equalsIgnoreCase(headerName)) {
                headerValue = headerValue + " HttpClient";
            }
            request.addHeader(headerName, headerValue);
        }
        try (CloseableHttpResponse response = this.httpClient.execute(request);){
            Response response2 = new Response(response.getStatusLine().getStatusCode(), EntityUtils.toString((HttpEntity)response.getEntity(), (Charset)UTF8));
            return response2;
        }
        catch (IOException e) {
            throw new ConnectionException(e);
        }
    }

    @Override
    public void close() throws IOException {
        this.httpClient.close();
    }
}

