/*
 * Decompiled with CFR 0.152.
 */
package com.securionpay.request;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.securionpay.request.BillingRequest;
import com.securionpay.request.CardRequest;
import com.securionpay.request.ShippingRequest;
import com.securionpay.response.Customer;
import com.securionpay.response.Plan;
import java.util.HashMap;
import java.util.Map;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
public class SubscriptionRequest {
    private String customerId;
    private String planId;
    private CardRequest card;
    private Integer quantity;
    private Boolean captureCharges;
    private Long trialEnd;
    private ShippingRequest shipping;
    private BillingRequest billing;
    private String merchantAccountId;
    private Map<String, String> metadata = new HashMap<String, String>();
    @JsonIgnore
    private final Map<String, Object> other = new HashMap<String, Object>();

    public SubscriptionRequest() {
    }

    public SubscriptionRequest(String customerId, String planId) {
        this.customerId(customerId).planId(planId);
    }

    public SubscriptionRequest(Customer customer, Plan plan) {
        this.customer(customer).plan(plan);
    }

    public String getCustomerId() {
        return this.customerId;
    }

    public String getPlanId() {
        return this.planId;
    }

    public CardRequest getCard() {
        return this.card;
    }

    public Integer getQuantity() {
        return this.quantity;
    }

    public Boolean getCaptureCharges() {
        return this.captureCharges;
    }

    public Long getTrialEnd() {
        return this.trialEnd;
    }

    public ShippingRequest getShipping() {
        return this.shipping;
    }

    public BillingRequest getBilling() {
        return this.billing;
    }

    public String getMerchantAccountId() {
        return this.merchantAccountId;
    }

    public Map<String, String> getMetadata() {
        return this.metadata;
    }

    public SubscriptionRequest customerId(String customerId) {
        this.customerId = customerId;
        return this;
    }

    public SubscriptionRequest customer(Customer customer) {
        return this.customerId(customer.getId());
    }

    public SubscriptionRequest planId(String planId) {
        this.planId = planId;
        return this;
    }

    public SubscriptionRequest plan(Plan plan) {
        return this.planId(plan.getId());
    }

    public SubscriptionRequest card(CardRequest card) {
        this.card = card;
        return this;
    }

    public SubscriptionRequest trialEnd(Long trialEnd) {
        this.trialEnd = trialEnd;
        return this;
    }

    public SubscriptionRequest quantity(Integer quantity) {
        this.quantity = quantity;
        return this;
    }

    public SubscriptionRequest captureCharges(Boolean captureCharges) {
        this.captureCharges = captureCharges;
        return this;
    }

    public SubscriptionRequest shipping(ShippingRequest shipping) {
        this.shipping = shipping;
        return this;
    }

    public SubscriptionRequest billing(BillingRequest billing) {
        this.billing = billing;
        return this;
    }

    public SubscriptionRequest merchantAccountId(String merchantAccountId) {
        this.merchantAccountId = merchantAccountId;
        return this;
    }

    public SubscriptionRequest metadata(Map<String, String> metadata) {
        this.metadata = metadata;
        return this;
    }

    @JsonAnyGetter
    private Map<String, Object> getOtherMap() {
        return this.other;
    }

    @JsonAnySetter
    public SubscriptionRequest set(String name, Object value) {
        this.other.put(name, value);
        return this;
    }
}

