/*
 * Decompiled with CFR 0.152.
 */
package com.securionpay.response;

import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.securionpay.enums.DisputeReason;
import com.securionpay.enums.DisputeStatus;
import com.securionpay.response.Charge;
import com.securionpay.response.DisputeEvidence;
import com.securionpay.response.DisputeEvidenceDetails;
import com.securionpay.util.SecurionPayUtils;
import java.util.HashMap;
import java.util.Map;

public class Dispute {
    private String id;
    private Long created;
    private Long updated;
    private Integer amount;
    private String currency;
    private String status;
    private String reason;
    private Boolean acceptedAsLost;
    private DisputeEvidence evidence;
    private DisputeEvidenceDetails evidenceDetails;
    private Charge charge;
    @JsonIgnore
    private final Map<String, Object> other = new HashMap<String, Object>();

    public String getId() {
        return this.id;
    }

    public Long getCreated() {
        return this.created;
    }

    public Long getUpdated() {
        return this.updated;
    }

    public Integer getAmount() {
        return this.amount;
    }

    public String getCurrency() {
        return this.currency;
    }

    public DisputeStatus getStatus() {
        return DisputeStatus.fromValue(this.status);
    }

    public String getStatusAsString() {
        return this.status;
    }

    public DisputeReason getReason() {
        return DisputeReason.fromValue(this.reason);
    }

    public String getReasonAsString() {
        return this.reason;
    }

    public Boolean getAcceptedAsLost() {
        return this.acceptedAsLost;
    }

    public DisputeEvidence getEvidence() {
        return this.evidence;
    }

    public DisputeEvidenceDetails getEvidenceDetails() {
        return this.evidenceDetails;
    }

    public Charge getCharge() {
        return this.charge;
    }

    public String get(String name) {
        return SecurionPayUtils.toStringNullSafe(this.other.get(name));
    }

    @JsonAnySetter
    private void set(String name, Object value) {
        this.other.put(name, value);
    }
}

