/*
 * Decompiled with CFR 0.152.
 */
package com.securionpay.response;

import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.securionpay.enums.PayoutTransactionType;
import com.securionpay.util.SecurionPayUtils;
import java.math.BigDecimal;
import java.util.HashMap;
import java.util.Map;

public class PayoutTransaction {
    private String id;
    private Long created;
    private String type;
    private Long amount;
    private String currency;
    private String description;
    private Long fee;
    private String source;
    private String payout;
    private BigDecimal exchangeRate;
    @JsonIgnore
    private Map<String, Object> other = new HashMap<String, Object>();

    public String getId() {
        return this.id;
    }

    public Long getCreated() {
        return this.created;
    }

    public PayoutTransactionType getType() {
        return PayoutTransactionType.fromValue(this.type);
    }

    public String getTypeAsString() {
        return this.type;
    }

    public Long getAmount() {
        return this.amount;
    }

    public String getCurrency() {
        return this.currency;
    }

    public String getDescription() {
        return this.description;
    }

    public Long getFee() {
        return this.fee;
    }

    public String getSource() {
        return this.source;
    }

    public String getPayout() {
        return this.payout;
    }

    public BigDecimal getExchangeRate() {
        return this.exchangeRate;
    }

    public String get(String name) {
        return SecurionPayUtils.toStringNullSafe(this.other.get(name));
    }

    @JsonAnySetter
    private void set(String name, Object value) {
        this.other.put(name, value);
    }
}

