package com.selectdb.demo;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.selectdb.load.LoadConstants;
import com.selectdb.load.SelectdbClient;
import com.selectdb.model.BaseResponse;
import com.selectdb.model.StageLoadResult;

import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;

public class StageLoadDemo {
    public static void main(String[] args) throws JsonProcessingException {
//        jsonListClient();
//        jsonClient();
        csvClient();
    }

    public static void jsonListClient() throws JsonProcessingException {
        SelectdbClient client = SelectdbClient.builder()
                .setHost("127.0.0.1")
                .setHttpPort(52710)
                .setJdbcPort(21477)
                .setDatabase("wd_test")
                .setTable("test_flink")
                .setClusterName("test123")
                .setUsername("admin")
                .setPassword("test_123")
                .addProperty(LoadConstants.FORMAT, "json")
                .addProperty(LoadConstants.STRIP_OUTER_ARRAY, "false")
                .addProperty(LoadConstants.COPY_ASYNC, "false")
                .build();

        List<User> data = new ArrayList<>();
        User user1 = new User();
        user1.name = "zhangsan";
        user1.age = 1;

        User user2 = new User();
        user2.name = "lisi";
        user2.age = 2;
        data.add(user1);
        data.add(user2);
//
        BaseResponse<StageLoadResult> response = client.stageLoad(new ArrayList<>(data));
        System.out.println(new ObjectMapper().writeValueAsString(response));

        //customer filename
        BaseResponse<StageLoadResult> response2 = client.stageLoad(new ArrayList<>(data), "file02.csv");
        System.out.println(new ObjectMapper().writeValueAsString(response2));

        //customer table name
        BaseResponse<StageLoadResult> response3 = client.stageLoad(new ArrayList<>(data), "file01.csv", "wd_test.test_flink_1");
        System.out.println(new ObjectMapper().writeValueAsString(response3));
    }

    public static void jsonClient() throws JsonProcessingException {
        SelectdbClient client = SelectdbClient.builder()
                .setHost("127.0.0.1")
                .setHttpPort(52710)
                .setJdbcPort(21477)
                .setDatabase("wd_test")
                .setTable("test_flink")
                .setClusterName("test123")
                .setUsername("admin")
                .setPassword("test_123")
                .addProperty(LoadConstants.FORMAT, "json")
                .addProperty(LoadConstants.STRIP_OUTER_ARRAY, "false")
                .addProperty(LoadConstants.COPY_ASYNC, "false")
                .build();

        String value = "{\"name\":\"zhangsan\",\"age\":1}\n{\"name\":\"lisi\",\"age\":2}";
        BaseResponse<StageLoadResult> response = client.stageLoad(value);
        System.out.println(new ObjectMapper().writeValueAsString(response));

        //customer filename
        BaseResponse<StageLoadResult> response2 = client.stageLoad(value, "file02.csv");
        System.out.println(new ObjectMapper().writeValueAsString(response2));

        //customer table name
        BaseResponse<StageLoadResult> response3 = client.stageLoad(value, "file01.csv", "wd_test.test_flink_1");
        System.out.println(new ObjectMapper().writeValueAsString(response3));

    }

    public static void csvClient() throws JsonProcessingException {
        SelectdbClient client = SelectdbClient.builder()
                .setHost("127.0.0.1")
                .setHttpPort(52710)
                .setJdbcPort(21477)
                .setDatabase("wd_test")
                .setTable("test_flink")
                .setClusterName("test123")
                .setUsername("admin")
                .setPassword("test_123")
                .addProperty(LoadConstants.FORMAT, "csv")
                .addProperty(LoadConstants.FIELD_DELIMITER, ",")
                .addProperty(LoadConstants.LINE_DELIMITER, "\n")
                .addProperty(LoadConstants.COPY_ASYNC, "false")
                .build();

        String value = "zhangsan,3\nlisi,4";
        BaseResponse<StageLoadResult> response = client.stageLoad(value.getBytes(StandardCharsets.UTF_8));
        System.out.println(new ObjectMapper().writeValueAsString(response));

        //customer filename
        BaseResponse<StageLoadResult> response2 = client.stageLoad(value, "file02.csv");
        System.out.println(new ObjectMapper().writeValueAsString(response2));

        //customer table name
        BaseResponse<StageLoadResult> response3 = client.stageLoad(value, "file01.csv", "wd_test.test_flink_1");
        System.out.println(new ObjectMapper().writeValueAsString(response3));
    }

    static class User{
        public String name;
        public int age;
    }
}

