package com.selectdb.load;

import org.apache.http.client.config.RequestConfig;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.impl.client.HttpClients;

/**
 * util to build http client.
 */
public class HttpUtil {
    private RequestConfig requestConfig = RequestConfig.custom()
            .setConnectTimeout(60 * 1000)
            .setConnectionRequestTimeout(60 * 1000)
            //default checkpoint timeout is 10min
            .setSocketTimeout(9 * 60 * 1000)
            .build();
    private final HttpClientBuilder httpClientBuilder = HttpClients
            .custom()
            // Auto redirection has problems on cloud
            .disableRedirectHandling()
            .setDefaultRequestConfig(requestConfig);

    public CloseableHttpClient getHttpClient() {
        return httpClientBuilder.build();
    }

    public HttpClientBuilder getHttpClientBuilder() {
        return httpClientBuilder;
    }
}
