package com.selectdb.load;

import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;

public class LoadOptions implements Serializable {
    private static final long serialVersionUID = 1L;
    private String host;
    private int jdbcPort;
    private int httpPort;
    private String clusterName;
    private String username;
    private String password;
    private String database;
    private String table;
    private Map<String,String> propertyMap = new HashMap<>();

    public LoadOptions(String host, int jdbcPort, int httpPort, String clusterName, String username, String password, String database, String table, Map<String, String> propertyMap) {
        this.host = host;
        this.jdbcPort = jdbcPort;
        this.httpPort = httpPort;
        this.clusterName = clusterName;
        this.username = username;
        this.password = password;
        this.database = database;
        this.table = table;
        this.propertyMap = propertyMap;
    }

    public LoadOptions() {
    }

    public String getHost() {
        return host;
    }

    public void setHost(String host) {
        this.host = host;
    }

    public int getJdbcPort() {
        return jdbcPort;
    }

    public void setJdbcPort(int jdbcPort) {
        this.jdbcPort = jdbcPort;
    }

    public String getClusterName() {
        return clusterName;
    }

    public void setClusterName(String clusterName) {
        this.clusterName = clusterName;
    }

    public int getHttpPort() {
        return httpPort;
    }

    public void setHttpPort(int httpPort) {
        this.httpPort = httpPort;
    }

    public String getUsername() {
        return username;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    public String getPassword() {
        return password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public String getDatabase() {
        return database;
    }

    public void setDatabase(String database) {
        this.database = database;
    }

    public String getTable() {
        return table;
    }

    public void setTable(String table) {
        this.table = table;
    }

    public Map<String, String> getPropertyMap() {
        return propertyMap;
    }

    public void setPropertyMap(Map<String, String> propertyMap) {
        this.propertyMap = propertyMap;
    }


}
