package com.selectdb.model;

import java.io.Serializable;

public class StageLoadResult implements Serializable {
    private String id;
    private String msg;
    private String loadedRows;
    private String filterRows;
    private String unselectRows;
    private String url;
    private long time;
    private String state;

    private String type;

    public StageLoadResult() {
    }

    public String getId() {
        return id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getMsg() {
        return msg;
    }

    public void setMsg(String msg) {
        this.msg = msg;
    }

    public String getLoadedRows() {
        return loadedRows;
    }

    public void setLoadedRows(String loadedRows) {
        this.loadedRows = loadedRows;
    }

    public String getFilterRows() {
        return filterRows;
    }

    public void setFilterRows(String filterRows) {
        this.filterRows = filterRows;
    }

    public String getUnselectRows() {
        return unselectRows;
    }

    public void setUnselectRows(String unselectRows) {
        this.unselectRows = unselectRows;
    }

    public String getUrl() {
        return url;
    }

    public void setUrl(String url) {
        this.url = url;
    }

    public long getTime() {
        return time;
    }

    public void setTime(long time) {
        this.time = time;
    }

    public String getState() {
        return state;
    }

    public void setState(String state) {
        this.state = state;
    }

    public String getType() {
        return type;
    }

    public void setType(String type) {
        this.type = type;
    }

    @Override
    public String toString() {
        return "StageLoadResult{" +
                "id='" + id + '\'' +
                ", msg='" + msg + '\'' +
                ", loadedRows='" + loadedRows + '\'' +
                ", filterRows='" + filterRows + '\'' +
                ", unselectRows='" + unselectRows + '\'' +
                ", url='" + url + '\'' +
                ", time=" + time +
                ", state='" + state + '\'' +
                ", type='" + type + '\'' +
                '}';
    }

    public void transform(CopyIntoResp copyIntoResp){
        if(copyIntoResp == null){
            return;
        }
        this.time = copyIntoResp.getTime();
        CopyIntoResult result = copyIntoResp.getResult();
        if(result != null){
            this.id = result.getId();
            this.loadedRows = result.getLoadedRows();
            this.filterRows = result.getFilterRows();
            this.unselectRows = result.getUnselectRows();
            this.state = result.getState();
            this.url = result.getUrl();
            this.type = result.getType();
            this.msg = result.getMsg();
        }
    }
}
