package com.selectdb.utils;


public class Preconditions {
    public static <T> T checkNotNull(T reference) {
        if (reference == null) {
            throw new NullPointerException();
        } else {
            return reference;
        }
    }
    public static <T> T checkNotNull(T reference,String errorMessage) {
        if (reference == null) {
            throw new NullPointerException(errorMessage);
        } else {
            return reference;
        }
    }

    public static String checkNotNullOrEmpty(String reference,String errorMessage) {
        if (reference == null || reference.trim().length() == 0) {
            throw new IllegalArgumentException(errorMessage);
        } else {
            return reference;
        }
    }
}
