/*
 * Decompiled with CFR 0.152.
 */
package com.selectdb.load;

import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.codec.binary.Base64;
import org.apache.http.HttpEntity;
import org.apache.http.client.methods.HttpPut;
import org.apache.http.entity.StringEntity;

public class HttpPutBuilder {
    String url;
    Map<String, String> header = new HashMap<String, String>();
    HttpEntity httpEntity;

    public HttpPutBuilder setUrl(String url) {
        this.url = url;
        return this;
    }

    public HttpPutBuilder addFileName(String fileName) {
        this.header.put("fileName", fileName);
        return this;
    }

    public HttpPutBuilder setEmptyEntity() {
        try {
            this.httpEntity = new StringEntity("");
        }
        catch (Exception e) {
            throw new IllegalArgumentException(e);
        }
        return this;
    }

    public HttpPutBuilder addCommonHeader() {
        this.header.put("Expect", "100-continue");
        return this;
    }

    public HttpPutBuilder baseAuth(String user, String password) {
        String authInfo = user + ":" + password;
        byte[] encoded = Base64.encodeBase64((byte[])authInfo.getBytes(StandardCharsets.UTF_8));
        this.header.put("Authorization", "Basic " + new String(encoded));
        return this;
    }

    public HttpPutBuilder setEntity(HttpEntity httpEntity) {
        this.httpEntity = httpEntity;
        return this;
    }

    public HttpPut build() {
        HttpPut put = new HttpPut(this.url);
        this.header.forEach((arg_0, arg_1) -> ((HttpPut)put).setHeader(arg_0, arg_1));
        put.setEntity(this.httpEntity);
        return put;
    }
}

