/*
 * Decompiled with CFR 0.152.
 */
package com.selectdb.load;

import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.selectdb.exceptions.UploadException;
import com.selectdb.load.HttpPutBuilder;
import com.selectdb.load.HttpUtil;
import com.selectdb.load.LoadOptions;
import java.io.IOException;
import java.io.Serializable;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpPut;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.ByteArrayEntity;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.util.EntityUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StageLoad
implements Serializable {
    private static final long serialVersionUID = 1L;
    private static final Logger LOG = LoggerFactory.getLogger(StageLoad.class);
    private static final String UPLOAD_URL_PATTERN = "http://%s:%s/copy/upload";
    private static final ObjectMapper OBJECT_MAPPER = new ObjectMapper();
    private String uploadUrl;
    private String username;
    private String password;
    private HttpClientBuilder httpClientBuilder = new HttpUtil().getHttpClientBuilder();

    public StageLoad(LoadOptions options) {
        this.uploadUrl = String.format(UPLOAD_URL_PATTERN, options.getHost(), options.getHttpPort());
        this.username = options.getUsername();
        this.password = options.getPassword();
    }

    public void uploadToStorage(String fileName, byte[] data) throws UploadException {
        long start = System.currentTimeMillis();
        LOG.info("file write started for {}", (Object)fileName);
        String address = this.getUploadAddress(fileName);
        long addressTs = System.currentTimeMillis();
        LOG.info("redirect to internalStage address:{}, cost {} ms", (Object)address, (Object)(addressTs - start));
        String requestId = this.uploadToInternalStage(address, data);
        LOG.info("upload file {} finished, size {}, cost {}ms, with requestId {}", new Object[]{fileName, data.length, System.currentTimeMillis() - addressTs, requestId});
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public String uploadToInternalStage(String address, byte[] data) throws UploadException {
        ByteArrayEntity entity = new ByteArrayEntity(data);
        HttpPutBuilder putBuilder = new HttpPutBuilder();
        putBuilder.setUrl(address).addCommonHeader().setEntity((HttpEntity)entity);
        HttpPut httpPut = putBuilder.build();
        try (CloseableHttpResponse response = this.httpClientBuilder.build().execute((HttpUriRequest)httpPut);){
            int statusCode = response.getStatusLine().getStatusCode();
            String requestId = this.getRequestId(response.getAllHeaders());
            if (statusCode != 200) throw new UploadException("upload file error: " + response.getStatusLine().toString() + ", with requestId " + requestId);
            if (response.getEntity() == null) throw new UploadException("upload file error: " + response.getStatusLine().toString() + ", with requestId " + requestId);
            String loadResult = EntityUtils.toString((HttpEntity)response.getEntity());
            if (loadResult == null || loadResult.isEmpty()) {
                String string = requestId;
                return string;
            }
            LOG.error("upload file failed, requestId is {}, response result: {}", (Object)requestId, (Object)loadResult);
            throw new UploadException("upload file failed: " + response.getStatusLine().toString() + ", with requestId " + requestId);
        }
        catch (IOException ex) {
            LOG.error("Failed to upload data to internal stage ", (Throwable)ex);
            throw new UploadException("Failed to upload data to internal stage");
        }
    }

    public String getRequestId(Header[] headers) {
        if (headers == null || headers.length == 0) {
            return null;
        }
        for (int i = 0; i < headers.length; ++i) {
            Header header = headers[i];
            String name = header.getName();
            if (name == null || !name.toLowerCase().matches("x-\\S+-request-id")) continue;
            return name + ":" + header.getValue();
        }
        return null;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public String getUploadAddress(String fileName) throws UploadException {
        HttpPutBuilder putBuilder = new HttpPutBuilder();
        putBuilder.setUrl(this.uploadUrl).addFileName(fileName).addCommonHeader().setEmptyEntity().baseAuth(this.username, this.password);
        try (CloseableHttpResponse execute = this.httpClientBuilder.build().execute((HttpUriRequest)putBuilder.build());){
            int statusCode = execute.getStatusLine().getStatusCode();
            String reason = execute.getStatusLine().getReasonPhrase();
            if (statusCode == 307) {
                String uploadAddress;
                Header location = execute.getFirstHeader("location");
                String string = uploadAddress = location.getValue();
                return string;
            }
            HttpEntity entity = execute.getEntity();
            String result = entity == null ? null : EntityUtils.toString((HttpEntity)entity);
            LOG.error("Failed to get internalStage address, status {}, reason {}, response {}", new Object[]{statusCode, reason, result});
            throw new UploadException("Failed get internalStage address");
        }
        catch (IOException e) {
            LOG.error("get internalStage address error,", (Throwable)e);
            throw new UploadException("get internalStage address error");
        }
    }

    public void setHttpClientBuilder(HttpClientBuilder httpClientBuilder) {
        this.httpClientBuilder = httpClientBuilder;
    }

    static {
        OBJECT_MAPPER.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
    }
}

