/*
 * Decompiled with CFR 0.152.
 */
package com.seleniumtests.browserfactory;

import com.seleniumtests.browserfactory.AbstractWebDriverFactory;
import com.seleniumtests.browserfactory.FirefoxCapabilitiesFactory;
import com.seleniumtests.browserfactory.IWebDriverFactory;
import com.seleniumtests.driver.DriverConfig;
import java.util.concurrent.TimeUnit;
import org.openqa.selenium.Capabilities;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.WebDriverException;
import org.openqa.selenium.firefox.FirefoxDriver;

public class FirefoxDriverFactory
extends AbstractWebDriverFactory
implements IWebDriverFactory {
    private long timeout = 60L;

    public FirefoxDriverFactory(DriverConfig cfg) {
        super(cfg);
    }

    protected WebDriver createNativeDriver() {
        return new FirefoxDriver((Capabilities)new FirefoxCapabilitiesFactory().createCapabilities(this.webDriverConfig));
    }

    @Override
    public WebDriver createWebDriver() {
        DriverConfig cfg = this.getWebDriverConfig();
        System.out.println("start create firefox");
        this.driver = this.createWebDriverWithTimeout();
        System.out.println("end create firefox");
        this.setImplicitWaitTimeout(cfg.getImplicitWaitTimeout());
        if (cfg.getPageLoadTimeout() >= 0) {
            this.setPageLoadTimeout(cfg.getPageLoadTimeout());
        }
        this.setWebDriver(this.driver);
        return this.driver;
    }

    protected WebDriver createWebDriverWithTimeout() {
        for (long time = 0L; time < this.getTimeout(); ++time) {
            try {
                this.driver = this.createNativeDriver();
                return this.driver;
            }
            catch (WebDriverException ex) {
                if (ex.getMessage().contains("SocketException") || ex.getMessage().contains("Failed to connect to binary FirefoxBinary") || ex.getMessage().contains("Unable to bind to locking port 7054 within 45000 ms")) {
                    try {
                        Thread.sleep(1000L);
                    }
                    catch (InterruptedException e) {
                        // empty catch block
                    }
                    continue;
                }
                throw new RuntimeException(ex);
            }
        }
        throw new RuntimeException("Got customexception when creating webDriver with socket timeout 1 minute");
    }

    protected long getTimeout() {
        return this.timeout;
    }

    protected void setPageLoadTimeout(long timeout) {
        this.driver.manage().timeouts().pageLoadTimeout(timeout, TimeUnit.SECONDS);
    }
}

