/*
 * Decompiled with CFR 0.152.
 */
package com.seleniumtests.browserfactory;

import com.seleniumtests.browserfactory.ICapabilitiesFactory;
import com.seleniumtests.driver.DriverConfig;
import org.openqa.selenium.Proxy;
import org.openqa.selenium.remote.DesiredCapabilities;

public class PhantomJSCapabilitiesFactory
implements ICapabilitiesFactory {
    @Override
    public DesiredCapabilities createCapabilities(DriverConfig cfg) {
        DesiredCapabilities capability = new DesiredCapabilities();
        capability.setBrowserName(DesiredCapabilities.phantomjs().getBrowserName());
        if (cfg.isEnableJavascript()) {
            capability.setJavascriptEnabled(true);
        } else {
            capability.setJavascriptEnabled(false);
        }
        capability.setCapability("takesScreenshot", true);
        capability.setCapability("acceptSslCerts", true);
        if (cfg.getBrowserVersion() != null) {
            capability.setVersion(cfg.getBrowserVersion());
        }
        if (cfg.getWebPlatform() != null) {
            capability.setPlatform(cfg.getWebPlatform());
        }
        if (cfg.getProxyHost() != null) {
            Proxy proxy = cfg.getProxy();
            capability.setCapability("proxy", (Object)proxy);
        }
        return capability;
    }
}

