/*
 * Decompiled with CFR 0.152.
 */
package com.seleniumtests.xmldog;

import com.seleniumtests.xmldog.StringUtil;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import java.util.StringTokenizer;

public class FileUtil {
    public static void writeListAsStr(String file, List list) throws IOException {
        if (list == null || list.size() == 0 || file == null || file.trim().length() == 0) {
            return;
        }
        BufferedWriter bw = null;
        try {
            bw = new BufferedWriter(new FileWriter(file));
            for (int i = 0; i < list.size(); ++i) {
                bw.write(list.get(i).toString());
                bw.write(StringUtil.getNewlineStr());
            }
        }
        catch (IOException ex) {
            throw ex;
        }
        finally {
            try {
                bw.close();
                bw = null;
            }
            catch (Exception ex) {}
        }
    }

    public static String getPrefix(String filename) {
        StringTokenizer st = new StringTokenizer(filename, ".");
        StringBuffer sb = new StringBuffer();
        int index = 0;
        int numTokens = st.countTokens();
        if (numTokens == 1) {
            return st.nextToken();
        }
        String token = null;
        while (st.hasMoreTokens()) {
            token = st.nextToken();
            if (index < numTokens - 1) {
                sb.append(token + ".");
            }
            ++index;
        }
        sb.deleteCharAt(sb.length() - 1);
        return sb.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String createTempFile(String filename, InputStream is) throws IOException {
        if (is == null) {
            throw new IOException("InputStream is null");
        }
        FileOutputStream fos = null;
        File tempFile = null;
        try {
            String userHome = System.getProperty("user.home");
            File f = new File(userHome + File.separator + "temp");
            f.mkdirs();
            tempFile = filename == null || filename.trim().equals("") ? File.createTempFile("file1", ".tmp") : File.createTempFile(filename, "");
            fos = new FileOutputStream(tempFile);
            byte[] buffer = new byte[8192];
            int bytesRead = 0;
            while ((bytesRead = is.read(buffer, 0, 8192)) != -1) {
                fos.write(buffer, 0, bytesRead);
            }
        }
        finally {
            if (fos != null) {
                fos.close();
                fos = null;
            }
        }
        return tempFile.getCanonicalPath();
    }

    public static void main(String[] args) {
        System.out.println(FileUtil.getPrefix("test3.txt.out"));
    }
}

