/*
 * Decompiled with CFR 0.152.
 */
package com.seleniumtests.browserfactory;

import com.seleniumtests.browserfactory.AbstractWebDriverFactory;
import com.seleniumtests.browserfactory.AndroidCapabilitiesFactory;
import com.seleniumtests.browserfactory.IOsCapabilitiesFactory;
import com.seleniumtests.browserfactory.IWebDriverFactory;
import com.seleniumtests.browserfactory.SauceLabsCapabilitiesFactory;
import com.seleniumtests.customexception.DriverExceptions;
import com.seleniumtests.driver.DriverConfig;
import com.seleniumtests.driver.TestType;
import io.appium.java_client.android.AndroidDriver;
import io.appium.java_client.ios.IOSDriver;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.concurrent.TimeUnit;
import org.openqa.selenium.Capabilities;
import org.openqa.selenium.UnsupportedCommandException;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.remote.RemoteWebDriver;

public class SauceLabsDriverFactory
extends AbstractWebDriverFactory
implements IWebDriverFactory {
    public SauceLabsDriverFactory(DriverConfig cfg) {
        super(cfg);
    }

    protected WebDriver createNativeDriver() throws MalformedURLException {
        if (this.webDriverConfig.getTestType().equals(TestType.APPIUM_WEB_ANDROID.getTestType())) {
            return new AndroidDriver(new URL(this.webDriverConfig.getSauceLabsURL()), (Capabilities)new AndroidCapabilitiesFactory().createCapabilities(this.webDriverConfig));
        }
        if (this.webDriverConfig.getTestType().equals(TestType.APPIUM_WEB_IOS.getTestType())) {
            return new IOSDriver(new URL(this.webDriverConfig.getSauceLabsURL()), (Capabilities)new IOsCapabilitiesFactory().createCapabilities(this.webDriverConfig));
        }
        return new RemoteWebDriver(new URL(this.webDriverConfig.getSauceLabsURL()), (Capabilities)new SauceLabsCapabilitiesFactory().createCapabilities(this.webDriverConfig));
    }

    @Override
    public WebDriver createWebDriver() {
        DriverConfig cfg = this.getWebDriverConfig();
        try {
            this.driver = this.createNativeDriver();
        }
        catch (MalformedURLException me) {
            throw new DriverExceptions("Problem with creating driver", me);
        }
        this.setImplicitWaitTimeout(cfg.getImplicitWaitTimeout());
        if (cfg.getPageLoadTimeout() >= 0) {
            this.setPageLoadTimeout(cfg.getPageLoadTimeout());
        }
        this.setWebDriver(this.driver);
        return this.driver;
    }

    protected void setPageLoadTimeout(long timeout) {
        try {
            this.driver.manage().timeouts().pageLoadTimeout(timeout, TimeUnit.SECONDS);
        }
        catch (UnsupportedCommandException unsupportedCommandException) {
            // empty catch block
        }
    }
}

