/*
 * Decompiled with CFR 0.152.
 */
package com.seleniumtests.core;

import java.math.BigDecimal;
import java.text.DateFormat;
import java.text.ParseException;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;

public class Filter {
    private String name;
    private Object[] values;
    private Operator operator;
    private Filter left;
    private Filter right;

    public static Filter and(Filter left, Filter right) {
        return new Filter(left, right, Operator.AND);
    }

    public static Filter contains(String name, String value) {
        return new Filter(name, value, Operator.CONTAINS);
    }

    public static Filter containsIgnoreCase(String name, String value) {
        return new Filter(name, value, Operator.CONTAINS_IGNORE_CASE);
    }

    public static Filter equals(String name, Object value) {
        return new Filter(name, value, Operator.EQUALS);
    }

    public static Filter equalsIgnoreCase(String name, String value) {
        return new Filter(name, value, Operator.EQUALS_IGNORE_CASE);
    }

    public static Filter greaterThan(String name, Number value) {
        return new Filter(name, value, Operator.GREATER_THAN);
    }

    public static Filter in(String name, Object[] values) {
        return new Filter(name, values, Operator.IN);
    }

    public static Filter lt(String name, Date value) {
        return new Filter(name, value, Operator.LESS_THAN);
    }

    public static Filter lt(String name, Number value) {
        return new Filter(name, value, Operator.LESS_THAN);
    }

    private static boolean match(Filter filter, Map<String, Object> parameters) {
        String name = filter.name != null ? filter.name.toUpperCase() : null;
        Object[] values = filter.values;
        Operator operator = filter.operator;
        Filter left = filter.left;
        Filter right = filter.right;
        if (Operator.AND.equals((Object)operator)) {
            return left.match(parameters) && right.match(parameters);
        }
        if (Operator.OR.equals((Object)operator)) {
            return left.match(parameters) || right.match(parameters);
        }
        if (Operator.NOT.equals((Object)operator)) {
            return !right.match(parameters);
        }
        if (!parameters.containsKey(name)) {
            return false;
        }
        if (Operator.IS_NULL.equals((Object)operator)) {
            return parameters.get(name) == null;
        }
        if ((Operator.EQUALS.equals((Object)operator) || Operator.EQUALS_IGNORE_CASE.equals((Object)operator)) && (values == null || values.length == 1 && values[0] == null)) {
            return parameters.get(name) == null;
        }
        if (Operator.EQUALS.equals((Object)operator)) {
            return parameters.get(name).equals(values[0]);
        }
        if (Operator.EQUALS_IGNORE_CASE.equals((Object)operator)) {
            return parameters.get(name).toString().toLowerCase().equals(values[0].toString().toLowerCase());
        }
        if (Operator.IN.equals((Object)operator)) {
            boolean found = false;
            for (Object value : values) {
                if (!parameters.get(name).equals(value)) continue;
                found = true;
                break;
            }
            return found;
        }
        if (values == null || values[0] == null) {
            throw new RuntimeException("Filter Operation does not support Null values: " + (Object)((Object)operator));
        }
        if (values[0] instanceof String) {
            switch (operator) {
                case CONTAINS: {
                    return parameters.get(name).toString().contains(values[0].toString());
                }
                case CONTAINS_IGNORE_CASE: {
                    return parameters.get(name).toString().toLowerCase().contains(values[0].toString().toLowerCase());
                }
                case STARTS_WITH: {
                    return parameters.get(name).toString().startsWith(values[0].toString());
                }
                case STARTS_WITH_IGNORE_CASE: {
                    return parameters.get(name).toString().toLowerCase().startsWith(values[0].toString().toLowerCase());
                }
                case ENDS_WITH: {
                    return parameters.get(name).toString().endsWith(values[0].toString());
                }
                case ENDS_WITH_IGNORE_CASE: {
                    return parameters.get(name).toString().toLowerCase().endsWith(values[0].toString().toLowerCase());
                }
            }
        } else if (values[0] instanceof Number) {
            BigDecimal val = new BigDecimal(parameters.get(name).toString());
            BigDecimal leftValue = new BigDecimal(values[0].toString());
            switch (operator) {
                case BETWEEN: {
                    BigDecimal rightValue = new BigDecimal(values[1].toString());
                    return leftValue.compareTo(val) < 1 && rightValue.compareTo(val) > -1;
                }
                case LESS_THAN: {
                    return val.compareTo(leftValue) == -1;
                }
                case GREATER_THAN: {
                    return val.compareTo(leftValue) == 1;
                }
            }
        } else if (values[0] instanceof Date) {
            Date date;
            try {
                date = DateFormat.getDateInstance().parse(parameters.get(name).toString());
            }
            catch (ParseException e) {
                date = (Date)parameters.get(name);
            }
            Date dateLeft = (Date)values[0];
            switch (operator) {
                case BETWEEN: {
                    Date dateRight = (Date)values[1];
                    return !(!dateLeft.before(date) && !dateLeft.equals(date) || !date.before(dateRight) && !date.equals(dateRight));
                }
                case LESS_THAN: {
                    return date.before(dateLeft);
                }
                case GREATER_THAN: {
                    return date.after(dateLeft);
                }
            }
        }
        throw new RuntimeException("NOT Implemented Yet\n" + filter + "\n" + parameters);
    }

    public static Filter not(Filter exp) {
        return new Filter((Filter)null, exp, Operator.NOT);
    }

    public static Filter or(Filter left, Filter right) {
        return new Filter(left, right, Operator.OR);
    }

    private Filter(Filter left, Filter right, Operator condition) {
        this.left = left;
        this.right = right;
        this.operator = condition;
    }

    public Filter(String name, Object value, Operator condition) {
        this(name, new Object[]{value}, condition);
    }

    public Filter(String name, Object[] values, Operator condition) {
        this.name = name;
        this.values = values;
        this.operator = condition;
    }

    public String getName() {
        return this.name;
    }

    public boolean match(Map<String, Object> parameters) {
        HashMap<String, Object> parameters2 = new HashMap<String, Object>();
        for (Map.Entry<String, Object> entry : parameters.entrySet()) {
            parameters2.put(entry.getKey().toUpperCase(), entry.getValue());
        }
        return Filter.match(this, parameters2);
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        if (this.name != null) {
            sb.append(this.name + " " + this.operator.toString() + " " + Arrays.toString(this.values));
        } else {
            sb.append((this.left != null ? this.left.toString() : "") + " " + this.operator.toString() + " " + this.right.toString());
        }
        return "(" + sb.toString() + ")";
    }

    static enum Operator {
        EQUALS,
        EQUALS_IGNORE_CASE,
        LESS_THAN,
        GREATER_THAN,
        BETWEEN,
        IN,
        IS_NULL,
        NOT,
        CONTAINS,
        CONTAINS_IGNORE_CASE,
        STARTS_WITH,
        STARTS_WITH_IGNORE_CASE,
        ENDS_WITH,
        ENDS_WITH_IGNORE_CASE,
        OR,
        AND;

    }
}

