/*
 * Decompiled with CFR 0.152.
 */
package com.seleniumtests.driver;

import com.seleniumtests.browserfactory.AndroidDriverFactory;
import com.seleniumtests.browserfactory.ChromeDriverFactory;
import com.seleniumtests.browserfactory.FirefoxDriverFactory;
import com.seleniumtests.browserfactory.HtmlUnitDriverFactory;
import com.seleniumtests.browserfactory.IEDriverFactory;
import com.seleniumtests.browserfactory.IPhoneDriverFactory;
import com.seleniumtests.browserfactory.IWebDriverFactory;
import com.seleniumtests.browserfactory.MarionetteDriverFactory;
import com.seleniumtests.browserfactory.RemoteDriverFactory;
import com.seleniumtests.browserfactory.SafariDriverFactory;
import com.seleniumtests.browserfactory.SauceLabsDriverFactory;
import com.seleniumtests.core.CustomEventListener;
import com.seleniumtests.core.SeleniumTestsContextManager;
import com.seleniumtests.driver.BrowserType;
import com.seleniumtests.driver.CustomEventFiringWebDriver;
import com.seleniumtests.driver.DriverConfig;
import com.seleniumtests.driver.DriverExceptionListener;
import com.seleniumtests.driver.DriverMode;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Date;
import org.openqa.selenium.Platform;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.WebDriverException;
import org.openqa.selenium.remote.RemoteWebDriver;
import org.openqa.selenium.support.events.EventFiringWebDriver;
import org.openqa.selenium.support.events.WebDriverEventListener;

public class WebUIDriver {
    private static ThreadLocal<WebDriver> driverSession = new ThreadLocal();
    private static ThreadLocal<WebUIDriver> uxDriverSession = new ThreadLocal();
    private String node;
    private DriverConfig config = new DriverConfig();
    private WebDriver driver;
    private IWebDriverFactory webDriverBuilder;

    public String getNode() {
        return this.node;
    }

    public void setNode(String node) {
        this.node = node;
    }

    public static void cleanUp() {
        IWebDriverFactory iWebDriverFactory = WebUIDriver.getWebUIDriver().webDriverBuilder;
        if (iWebDriverFactory != null) {
            iWebDriverFactory.cleanUp();
        } else {
            WebDriver driver = driverSession.get();
            if (driver != null) {
                try {
                    driver.quit();
                }
                catch (WebDriverException ex) {
                    ex.printStackTrace();
                }
                Object var1_1 = null;
            }
        }
        driverSession.remove();
        uxDriverSession.remove();
    }

    public static WebDriver getNativeWebDriver() {
        return ((CustomEventFiringWebDriver)WebUIDriver.getWebDriver(false)).getWebDriver();
    }

    public static WebDriver getWebDriver() {
        return WebUIDriver.getWebDriver(false);
    }

    public static WebDriver getWebDriver(Boolean isCreate) {
        if (driverSession.get() == null && isCreate.booleanValue()) {
            try {
                WebUIDriver.getWebUIDriver().createWebDriver();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return driverSession.get();
    }

    public static WebUIDriver getWebUIDriver() {
        if (uxDriverSession.get() == null) {
            uxDriverSession.set(new WebUIDriver());
        }
        return uxDriverSession.get();
    }

    public static void setWebDriver(WebDriver driver) {
        if (driver == null) {
            driverSession.remove();
        } else {
            if (WebUIDriver.getWebUIDriver() == null) {
                new WebUIDriver();
            }
            driverSession.set(driver);
        }
    }

    public WebUIDriver() {
        this.init();
        uxDriverSession.set(this);
    }

    public WebUIDriver(String browser, String mode) {
        this.init();
        this.setBrowser(browser);
        this.setMode(mode);
        uxDriverSession.set(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public WebDriver createRemoteWebDriver(String browser, String mode) throws Exception {
        WebDriver driver = null;
        this.config.setBrowser(BrowserType.getBrowserType(browser));
        this.config.setMode(DriverMode.valueOf(mode));
        if (this.config.getMode() == DriverMode.ExistingGrid) {
            this.webDriverBuilder = new RemoteDriverFactory(this.config);
        } else if (this.config.getBrowser() == BrowserType.FireFox) {
            this.webDriverBuilder = new FirefoxDriverFactory(this.config);
        } else if (this.config.getBrowser() == BrowserType.Marionette) {
            this.webDriverBuilder = new MarionetteDriverFactory(this.config);
        } else if (this.config.getBrowser() == BrowserType.InternetExplore) {
            this.webDriverBuilder = new IEDriverFactory(this.config);
        } else if (this.config.getBrowser() == BrowserType.Chrome) {
            this.webDriverBuilder = new ChromeDriverFactory(this.config);
        } else if (this.config.getBrowser() == BrowserType.HtmlUnit) {
            this.webDriverBuilder = new HtmlUnitDriverFactory(this.config);
        } else if (this.config.getBrowser() == BrowserType.Safari) {
            this.webDriverBuilder = new SafariDriverFactory(this.config);
        } else if (this.config.getBrowser() == BrowserType.SauceLabs) {
            this.webDriverBuilder = new SauceLabsDriverFactory(this.config);
        } else if (this.config.getBrowser() == BrowserType.Android) {
            this.webDriverBuilder = new AndroidDriverFactory(this.config);
        } else if (this.config.getBrowser() == BrowserType.IPhone) {
            this.webDriverBuilder = new IPhoneDriverFactory(this.config);
        } else {
            throw new RuntimeException("Unsupported browser: " + browser);
        }
        Class<?> clazz = this.getClass();
        synchronized (clazz) {
            driver = this.webDriverBuilder.createWebDriver();
            if (this.config.isEventFiringWebDriver()) {
                CustomEventListener eventListener = new CustomEventListener();
                EventFiringWebDriver eventFiringWebDriver = new EventFiringWebDriver(driver);
                eventFiringWebDriver.register((WebDriverEventListener)eventListener);
                WebUIDriver.setWebDriver((WebDriver)eventFiringWebDriver);
                driverSession.set((WebDriver)eventFiringWebDriver);
                driver = this.handleListeners((WebDriver)eventFiringWebDriver);
            } else {
                driverSession.set(driver);
                driver = this.handleListeners(driver);
            }
        }
        String browserVersion = ((RemoteWebDriver)this.getWebDriverBuilder().getWebDriver()).getCapabilities().getVersion();
        SeleniumTestsContextManager.getTestLevelContext(SeleniumTestsContextManager.getGlobalContext().getTestNGContext()).setBrowserVersion(browserVersion);
        return driver;
    }

    protected WebDriver handleListeners(WebDriver driver) {
        ArrayList<WebDriverEventListener> listeners = this.config.getWebDriverListeners();
        if (listeners != null && listeners.size() > 0) {
            for (int i = 0; i < this.config.getWebDriverListeners().size(); ++i) {
                driver = new CustomEventFiringWebDriver(driver).register(listeners.get(i));
            }
        }
        return driver;
    }

    public WebDriver createWebDriver() throws Exception {
        System.out.println(Thread.currentThread() + ":" + new Date() + ":::Start creating web driver instance: " + this.getBrowser());
        this.driver = this.createRemoteWebDriver(this.config.getBrowser().getBrowserType(), this.config.getMode().name());
        driverSession.set(this.driver);
        System.out.println(Thread.currentThread() + ":" + new Date() + ":::Finish creating web driver instance: " + this.getBrowser());
        return this.driver;
    }

    public String getBrowser() {
        return this.config.getBrowser().getBrowserType();
    }

    public String getPlatform() {
        return this.config.getWebPlatform().name();
    }

    public String getBrowserVersion() {
        return this.config.getBrowserVersion();
    }

    public String getChromeBinPath() {
        return this.config.getChromeBinPath();
    }

    public String getChromeDriverPath() {
        return this.config.getChromeDriverPath();
    }

    public DriverConfig getConfig() {
        return this.config;
    }

    public int getExplicitWait() {
        return this.config.getExplicitWaitTimeout();
    }

    public String getFfBinPath() {
        return this.config.getFirefoxBinPath();
    }

    public String getFfProfilePath() throws URISyntaxException {
        return this.config.getFirefoxProfilePath();
    }

    public String getOperaProfilePath() throws URISyntaxException {
        return this.config.getOperaProfilePath();
    }

    public void setOperaProfilePath(String operaProfilePath) {
        this.config.setOperaProfilePath(operaProfilePath);
    }

    public String getHubUrl() {
        return this.config.getHubUrl();
    }

    public String getIEDriverPath() {
        return this.config.getIeDriverPath();
    }

    public double getImplicitWait() {
        return this.config.getImplicitWaitTimeout();
    }

    public String getMode() {
        return this.config.getMode().name();
    }

    public String getOutputDirectory() {
        return this.config.getOutputDirectory();
    }

    public String getNtlmAuthTrustedUris() {
        return this.config.getNtlmAuthTrustedUris();
    }

    public void setNtlmAuthTrustedUris(String url) {
        this.config.setNtlmAuthTrustedUris(url);
    }

    public int getPageLoadTimeout() {
        return this.config.getPageLoadTimeout();
    }

    public String getProxyHost() {
        return this.config.getProxyHost();
    }

    public void setUserAgentOverride(String userAgentOverride) {
        this.config.setUserAgentOverride(userAgentOverride);
    }

    public String getUserAgentOverride() {
        return this.config.getUserAgentOverride();
    }

    public IWebDriverFactory getWebDriverBuilder() {
        return this.webDriverBuilder;
    }

    public int getWebSessionTimeout() {
        return this.config.getWebSessionTimeout();
    }

    private void init() {
        if (SeleniumTestsContextManager.getThreadContext() == null) {
            return;
        }
        String browser = SeleniumTestsContextManager.getThreadContext().getWebRunBrowser();
        this.config.setBrowser(BrowserType.getBrowserType(browser));
        if ("true".equalsIgnoreCase((String)SeleniumTestsContextManager.getThreadContext().getAttribute("eventFiringWebDriver"))) {
            this.config.setEventFiringWebDriver(true);
        }
        String mode = SeleniumTestsContextManager.getThreadContext().getWebRunMode();
        this.config.setMode(DriverMode.valueOf(mode));
        String hubUrl = SeleniumTestsContextManager.getThreadContext().getWebDriverGrid();
        this.config.setHubUrl(hubUrl);
        String ffProfilePath = SeleniumTestsContextManager.getThreadContext().getFirefoxUserProfilePath();
        this.config.setFfProfilePath(ffProfilePath);
        String operaProfilePath = SeleniumTestsContextManager.getThreadContext().getOperaUserProfilePath();
        this.config.setOperaProfilePath(operaProfilePath);
        String ffBinPath = SeleniumTestsContextManager.getThreadContext().getFirefoxBinPath();
        this.config.setFfBinPath(ffBinPath);
        String chromeBinPath = SeleniumTestsContextManager.getThreadContext().getChromeBinPath();
        this.config.setChromeBinPath(chromeBinPath);
        String chromeDriverPath = SeleniumTestsContextManager.getThreadContext().getChromeDriverPath();
        this.config.setChromeDriverPath(chromeDriverPath);
        String ieDriverPath = SeleniumTestsContextManager.getThreadContext().getIEDriverPath();
        this.config.setIeDriverPath(ieDriverPath);
        int webSessionTimeout = SeleniumTestsContextManager.getThreadContext().getWebSessionTimeout();
        this.config.setWebSessionTimeout(webSessionTimeout);
        double implicitWaitTimeout = SeleniumTestsContextManager.getThreadContext().getImplicitWaitTimeout();
        this.config.setImplicitWaitTimeout(implicitWaitTimeout);
        int explicitWaitTimeout = SeleniumTestsContextManager.getThreadContext().getExplicitWaitTimeout();
        this.config.setExplicitWaitTimeout(explicitWaitTimeout);
        this.config.setPageLoadTimeout(SeleniumTestsContextManager.getThreadContext().getPageLoadTimeout());
        String outputDirectory = SeleniumTestsContextManager.getGlobalContext().getOutputDirectory();
        this.config.setOutputDirectory(outputDirectory);
        if (SeleniumTestsContextManager.getThreadContext().isWebProxyEnabled()) {
            String proxyHost = SeleniumTestsContextManager.getThreadContext().getWebProxyAddress();
            this.config.setProxyHost(proxyHost);
        }
        String browserVersion = SeleniumTestsContextManager.getThreadContext().getWebBrowserVersion();
        this.config.setBrowserVersion(browserVersion);
        String webPlatform = SeleniumTestsContextManager.getThreadContext().getWebPlatform();
        if (webPlatform != null) {
            this.config.setWebPlatform(Platform.valueOf((String)webPlatform));
        }
        if ("false".equalsIgnoreCase((String)SeleniumTestsContextManager.getThreadContext().getAttribute("setAssumeUntrustedCertificateIssuer"))) {
            this.config.setSetAssumeUntrustedCertificateIssuer(false);
        }
        if ("false".equalsIgnoreCase((String)SeleniumTestsContextManager.getThreadContext().getAttribute("setAcceptUntrustedCertificates"))) {
            this.config.setSetAcceptUntrustedCertificates(false);
        }
        if ("false".equalsIgnoreCase((String)SeleniumTestsContextManager.getThreadContext().getAttribute("enableJavascript"))) {
            this.config.setEnableJavascript(false);
        }
        if (SeleniumTestsContextManager.getThreadContext().getNtlmAuthTrustedUris() != null) {
            this.config.setNtlmAuthTrustedUris(SeleniumTestsContextManager.getThreadContext().getNtlmAuthTrustedUris());
        }
        if (SeleniumTestsContextManager.getThreadContext().getBrowserDownloadDir() != null) {
            this.config.setBrowserDownloadDir(SeleniumTestsContextManager.getThreadContext().getBrowserDownloadDir());
        }
        String ua = null;
        ua = SeleniumTestsContextManager.getThreadContext().getUserAgent() != null ? SeleniumTestsContextManager.getThreadContext().getUserAgent() : null;
        this.config.setUserAgentOverride(ua);
        String listeners = SeleniumTestsContextManager.getThreadContext().getWebDriverListener();
        if (SeleniumTestsContextManager.getThreadContext().getEnableExceptionListener()) {
            listeners = listeners != null ? listeners + "," : "";
            listeners = listeners + DriverExceptionListener.class.getName();
        }
        if (listeners != null && !listeners.equals("")) {
            this.config.setWebDriverListeners(listeners);
        } else {
            this.config.setWebDriverListeners("");
        }
        this.config.setUseFirefoxDefaultProfile(SeleniumTestsContextManager.getThreadContext().isUseFirefoxDefaultProfile());
        String size = SeleniumTestsContextManager.getThreadContext().getBrowserWindowSize();
        if (size != null) {
            int width = -1;
            int height = -1;
            try {
                width = Integer.parseInt(size.split(",")[0].trim());
                height = Integer.parseInt(size.split(",")[1].trim());
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.config.setBrowserWindowWidth(width);
            this.config.setBrowserWindowHeight(height);
        }
        String appiumServerURL = SeleniumTestsContextManager.getThreadContext().getAppiumServerURL();
        this.config.setAppiumServerURL(appiumServerURL);
        String automationName = SeleniumTestsContextManager.getThreadContext().getAutomationName();
        this.config.setAutomationName(automationName);
        String mobilePlatformName = SeleniumTestsContextManager.getThreadContext().getMobilePlatformName();
        this.config.setMobilePlatformName(mobilePlatformName);
        String mobilePlatformVersion = SeleniumTestsContextManager.getThreadContext().getMobilePlatformVersion();
        this.config.setMobilePlatformVersion(mobilePlatformVersion);
        String deviceName = SeleniumTestsContextManager.getThreadContext().getDeviceName();
        this.config.setDeviceName(deviceName);
        String app = SeleniumTestsContextManager.getThreadContext().getApp();
        this.config.setApp(app);
        String browserName = SeleniumTestsContextManager.getThreadContext().getBrowserName();
        this.config.setBrowserName(browserName);
        String appPackage = SeleniumTestsContextManager.getThreadContext().getAppPackage();
        this.config.setAppPackage(appPackage);
        String appActivity = SeleniumTestsContextManager.getThreadContext().getAppActivity();
        this.config.setAppActivity(appActivity);
        String newCommandTimeOut = SeleniumTestsContextManager.getThreadContext().getNewCommandTimeout();
        this.config.setNewCommandTimeout(newCommandTimeOut);
        this.config.setVersion(SeleniumTestsContextManager.getThreadContext().getVersion());
        this.config.setPlatform(SeleniumTestsContextManager.getThreadContext().getPlatform());
        this.config.setSauceLabsURL(SeleniumTestsContextManager.getThreadContext().getSaucelabsURL());
        this.config.setTestType(SeleniumTestsContextManager.getThreadContext().getTestType());
    }

    public static void main(String[] args) {
        System.out.println(DriverExceptionListener.class.getName());
    }

    public boolean isSetAcceptUntrustedCertificates() {
        return this.config.isSetAcceptUntrustedCertificates();
    }

    public boolean isSetAssumeUntrustedCertificateIssuer() {
        return this.config.isSetAssumeUntrustedCertificateIssuer();
    }

    public boolean isEnableJavascript() {
        return this.config.isEnableJavascript();
    }

    public void setEnableJavascript(Boolean enableJavascript) {
        this.config.setEnableJavascript(enableJavascript);
    }

    public void setBrowser(String browser) {
        this.config.setBrowser(BrowserType.getBrowserType(browser));
    }

    public void setBrowserVersion(String browserVersion) {
        this.config.setBrowserVersion(browserVersion);
    }

    public void setPlatform(String platform) {
        this.config.setWebPlatform(Platform.valueOf((String)platform));
    }

    public void setChromeBinPath(String chromeBinPath) {
        this.config.setChromeBinPath(chromeBinPath);
    }

    public void setBrowserDownloadDir(String browserDownloadDir) {
        this.config.setBrowserDownloadDir(browserDownloadDir);
    }

    public String getBrowserDownloadDir() {
        return this.config.getBrowserDownloadDir();
    }

    public void setChromeDriverPath(String chromeDriverPath) {
        this.config.setChromeDriverPath(chromeDriverPath);
    }

    public void setConfig(DriverConfig config) {
        this.config = config;
    }

    public void setExplicitTimeout(int explicitWaitTimeout) {
        this.config.setExplicitWaitTimeout(explicitWaitTimeout);
    }

    public void setFfBinPath(String ffBinPath) {
        this.config.setFfBinPath(ffBinPath);
    }

    public void setFfProfilePath(String ffProfilePath) {
        this.config.setFfProfilePath(ffProfilePath);
    }

    public void setHubUrl(String hubUrl) {
        this.config.setHubUrl(hubUrl);
    }

    public void setIEDriverPath(String ieDriverPath) {
        this.config.setIeDriverPath(ieDriverPath);
    }

    public void setImplicitlyWaitTimeout(double implicitTimeout) {
        this.config.setImplicitWaitTimeout(implicitTimeout);
    }

    public void setMode(String mode) {
        this.config.setMode(DriverMode.valueOf(mode));
    }

    public void setOutputDirectory(String outputDirectory) {
        this.config.setOutputDirectory(outputDirectory);
    }

    public void setPageLoadTimeout(int pageLoadTimeout) {
        this.config.setPageLoadTimeout(pageLoadTimeout);
    }

    public void setProxyHost(String proxyHost) {
        this.config.setProxyHost(proxyHost);
    }

    public void setSetAcceptUntrustedCertificates(boolean setAcceptUntrustedCertificates) {
        this.config.setSetAcceptUntrustedCertificates(setAcceptUntrustedCertificates);
    }

    public void setSetAssumeUntrustedCertificateIssuer(boolean setAssumeUntrustedCertificateIssuer) {
        this.config.setSetAssumeUntrustedCertificateIssuer(setAssumeUntrustedCertificateIssuer);
    }

    public void setWebDriverBuilder(IWebDriverFactory builder) {
        this.webDriverBuilder = builder;
    }

    public void setWebSessionTimeout(int webSessionTimeout) {
        this.config.setWebSessionTimeout(webSessionTimeout);
    }
}

