/*
 * Decompiled with CFR 0.152.
 */
package com.sendgrid;

import com.sendgrid.APICallback;
import com.sendgrid.Client;
import com.sendgrid.RateLimitException;
import com.sendgrid.Request;
import com.sendgrid.Response;
import com.sendgrid.SendGridAPI;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;

public abstract class BaseInterface
implements SendGridAPI {
    private static final String VERSION = "4.8.1";
    private static final String USER_AGENT = "sendgrid/4.8.1;java";
    private static final int RATE_LIMIT_RESPONSE_CODE = 429;
    private static final int THREAD_POOL_SIZE = 8;
    private ExecutorService pool;
    private String host;
    private String version;
    private Client client;
    private Map<String, String> requestHeaders;
    private int rateLimitRetry;
    private int rateLimitSleep;
    private String subuser;

    public BaseInterface() {
        this.client = new Client();
    }

    public BaseInterface(Boolean test) {
        this.client = new Client(test);
    }

    public BaseInterface(Client client) {
        this.client = client;
    }

    @Override
    public void initialize(String auth, String host) {
        this.host = host;
        this.version = "v3";
        this.requestHeaders = new HashMap<String, String>();
        this.requestHeaders.put("Authorization", auth);
        this.requestHeaders.put("User-Agent", USER_AGENT);
        this.requestHeaders.put("Accept", "application/json");
        this.rateLimitRetry = 5;
        this.rateLimitSleep = 1100;
        this.pool = Executors.newFixedThreadPool(8);
    }

    @Override
    public String getLibraryVersion() {
        return VERSION;
    }

    @Override
    public String getVersion() {
        return this.version;
    }

    @Override
    public void setVersion(String version) {
        this.version = version;
    }

    @Override
    public Map<String, String> getRequestHeaders() {
        return this.requestHeaders;
    }

    @Override
    public Map<String, String> addRequestHeader(String key, String value) {
        this.requestHeaders.put(key, value);
        return this.getRequestHeaders();
    }

    @Override
    public Map<String, String> removeRequestHeader(String key) {
        this.requestHeaders.remove(key);
        return this.getRequestHeaders();
    }

    @Override
    public String getHost() {
        return this.host;
    }

    @Override
    public void setHost(String host) {
        this.host = host;
    }

    public int getRateLimitRetry() {
        return this.rateLimitRetry;
    }

    public void setRateLimitRetry(int rateLimitRetry) {
        this.rateLimitRetry = rateLimitRetry;
    }

    public int getRateLimitSleep() {
        return this.rateLimitSleep;
    }

    public void setRateLimitSleep(int rateLimitSleep) {
        this.rateLimitSleep = rateLimitSleep;
    }

    public void addImpersonateSubuser(String subuser) {
        this.subuser = subuser;
        this.addRequestHeader("on-behalf-of", subuser);
    }

    public void removeImpersonateSubuser() {
        this.subuser = null;
        this.removeRequestHeader("on-behalf-of");
    }

    public String getImpersonateSubuser() {
        return this.subuser;
    }

    @Override
    public Response makeCall(Request request) throws IOException {
        return this.client.api(request);
    }

    @Override
    public Response api(Request request) throws IOException {
        Request req = new Request();
        req.setMethod(request.getMethod());
        req.setBaseUri(this.host);
        req.setEndpoint("/" + this.version + "/" + request.getEndpoint());
        req.setBody(request.getBody());
        req.getHeaders().putAll(this.requestHeaders);
        req.getHeaders().putAll(request.getHeaders());
        req.getQueryParams().putAll(request.getQueryParams());
        return this.makeCall(req);
    }

    public void attempt(Request request) {
        this.attempt(request, new APICallback(){

            @Override
            public void error(Exception ex) {
            }

            @Override
            public void response(Response r) {
            }
        });
    }

    public void attempt(final Request request, final APICallback callback) {
        this.pool.execute(new Runnable(){

            @Override
            public void run() {
                for (int i = 0; i < BaseInterface.this.rateLimitRetry; ++i) {
                    Response response;
                    try {
                        response = BaseInterface.this.api(request);
                    }
                    catch (IOException ex) {
                        callback.error(ex);
                        return;
                    }
                    if (response.getStatusCode() == 429) {
                        try {
                            Thread.sleep(BaseInterface.this.rateLimitSleep);
                        }
                        catch (InterruptedException interruptedException) {}
                        continue;
                    }
                    callback.response(response);
                    return;
                }
                callback.error(new RateLimitException(request, BaseInterface.this.rateLimitRetry));
            }
        });
    }
}

