/*
 * Decompiled with CFR 0.152.
 */
package com.shapesecurity.functional.data;

import com.shapesecurity.functional.Effect;
import com.shapesecurity.functional.F;
import com.shapesecurity.functional.ThrowingSupplier;
import com.shapesecurity.functional.data.Maybe;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nonnull;

@CheckReturnValue
public final class Either<A, B> {
    private final Object data;
    private final Tag tag;

    private Either(Object data, Tag tag) {
        this.data = data;
        this.tag = tag;
    }

    @Nonnull
    public static <A, B> Either<A, B> left(@Nonnull A a) {
        return new Either<A, B>(a, Tag.LEFT);
    }

    @Nonnull
    public static <A, B> Either<A, B> right(@Nonnull B b) {
        return new Either<A, B>(b, Tag.RIGHT);
    }

    @Nonnull
    public static <A, B extends A, C extends A> A extract(Either<B, C> e) {
        return (A)e.either(x -> x, x -> x);
    }

    @Nonnull
    public static <A> Either<Exception, A> _try(@Nonnull ThrowingSupplier<A> s) {
        try {
            return Either.right(s.get());
        }
        catch (Exception e) {
            return Either.left(e);
        }
    }

    public final boolean isLeft() {
        return this.tag == Tag.LEFT;
    }

    public final boolean isRight() {
        return this.tag == Tag.RIGHT;
    }

    public <X> X either(F<A, X> f1, F<B, X> f2) {
        if (this.tag == Tag.LEFT) {
            return f1.apply(this.data);
        }
        return f2.apply(this.data);
    }

    public void foreach(@Nonnull Effect<A> f1, @Nonnull Effect<B> f2) {
        if (this.tag == Tag.LEFT) {
            f1.apply(this.data);
        } else {
            f2.apply(this.data);
        }
    }

    @Nonnull
    public <X, Y> Either<X, Y> map(F<A, X> f1, F<B, Y> f2) {
        return this.either(a -> Either.left(f1.apply(a)), b -> Either.right(f2.apply(b)));
    }

    @Nonnull
    public <X> Either<X, B> mapLeft(@Nonnull F<A, X> f) {
        return this.map(f, b -> b);
    }

    @Nonnull
    public <Y> Either<A, Y> mapRight(@Nonnull F<B, Y> f) {
        return this.map(a -> a, f);
    }

    @Nonnull
    public Maybe<A> left() {
        return this.tag == Tag.LEFT ? Maybe.of(this.data) : Maybe.empty();
    }

    @Nonnull
    public Maybe<B> right() {
        return this.tag == Tag.RIGHT ? Maybe.of(this.data) : Maybe.empty();
    }

    private boolean eq(@Nonnull Either<A, B> either) {
        return either.tag == this.tag && either.data.equals(this.data);
    }

    public int hashCode() {
        return 170 << this.tag.ordinal() ^ this.data.hashCode();
    }

    public final boolean equals(Object object) {
        return this == object || object instanceof Either && this.eq((Either)object);
    }

    private static enum Tag {
        LEFT,
        RIGHT;

    }
}

