/*
 * Decompiled with CFR 0.152.
 */
package com.shapesecurity.functional.data;

import com.shapesecurity.functional.Unit;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nonnull;

@CheckReturnValue
public interface Semigroup<T> {
    public static final UnitIdentity UNIT_IDENTITY = new UnitIdentity();
    public static final IntegerAdditive INTEGER_ADDITIVE = new IntegerAdditive();
    public static final IntegerMultiplicative INTEGER_MULTIPLICATIVE = new IntegerMultiplicative();
    public static final StringConcat STRING_CONCAT = new StringConcat();
    public static final BooleanOr BOOLEAN_OR = new BooleanOr();
    public static final BooleanAnd BOOLEAN_AND = new BooleanAnd();

    @Nonnull
    public T append(T var1, T var2);

    public static class BooleanAnd
    implements Semigroup<Boolean> {
        protected BooleanAnd() {
        }

        @Override
        @Nonnull
        public final Boolean append(Boolean a, Boolean b) {
            return a != false && b != false;
        }
    }

    public static class BooleanOr
    implements Semigroup<Boolean> {
        protected BooleanOr() {
        }

        @Override
        @Nonnull
        public final Boolean append(Boolean a, Boolean b) {
            return a != false || b != false;
        }
    }

    public static class StringConcat
    implements Semigroup<String> {
        protected StringConcat() {
        }

        @Override
        @Nonnull
        public final String append(String a, String b) {
            return a + b;
        }
    }

    public static class IntegerMultiplicative
    implements Semigroup<Integer> {
        protected IntegerMultiplicative() {
        }

        @Override
        @Nonnull
        public final Integer append(Integer a, Integer b) {
            return a * b;
        }
    }

    public static class IntegerAdditive
    implements Semigroup<Integer> {
        protected IntegerAdditive() {
        }

        @Override
        @Nonnull
        public final Integer append(Integer a, Integer b) {
            return a + b;
        }
    }

    public static class UnitIdentity
    implements Semigroup<Unit> {
        protected UnitIdentity() {
        }

        @Override
        @Nonnull
        public final Unit append(Unit a, Unit b) {
            return Unit.unit;
        }
    }
}

