/*
 * Decompiled with CFR 0.152.
 */
package com.shapesecurity.functional;

import java.util.function.Supplier;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public final class Thunk<A> {
    @Nonnull
    private final Supplier<A> supplier;
    @Nullable
    private volatile A value = null;

    private Thunk(@Nonnull Supplier<A> supplier) {
        this.supplier = supplier;
    }

    @Nonnull
    public static <A> Thunk<A> constant(@Nonnull A value) {
        Thunk<Object> t = new Thunk<Object>(() -> value);
        t.value = value;
        return t;
    }

    @Nonnull
    public static <A> Thunk<A> from(@Nonnull Supplier<A> supplier) {
        return new Thunk<A>(supplier);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nonnull
    public final A get() {
        A value = this.value;
        if (value == null) {
            Thunk thunk = this;
            synchronized (thunk) {
                value = this.value;
                if (value == null) {
                    this.value = value = this.supplier.get();
                }
            }
        }
        return value;
    }
}

