/*
 * Decompiled with CFR 0.152.
 */
package com.shapesecurity.functional.data;

import com.shapesecurity.functional.Effect;
import com.shapesecurity.functional.F;
import com.shapesecurity.functional.F2;
import com.shapesecurity.functional.Pair;
import com.shapesecurity.functional.data.ImmutableList;
import com.shapesecurity.functional.data.Maybe;
import com.shapesecurity.functional.data.Monoid;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Deque;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Spliterator;
import java.util.Stack;
import java.util.function.Consumer;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

@CheckReturnValue
public abstract class ConcatList<T>
implements Iterable<T> {
    private static final Empty<Object> EMPTY = new Empty();
    private static BinaryTreeMonoid<Object> MONOID = new BinaryTreeMonoid();
    public final int length;
    final boolean isBalanced;

    protected ConcatList(int length, boolean isBalanced) {
        this.length = length;
        this.isBalanced = isBalanced;
    }

    @Nonnull
    public static <T> ConcatList<T> empty() {
        return EMPTY;
    }

    @Nonnull
    @Deprecated
    public static <T> ConcatList<T> nil() {
        return ConcatList.empty();
    }

    @SafeVarargs
    public static <T> ConcatList<T> of(T ... elements) {
        if (elements.length == 0) {
            return ConcatList.empty();
        }
        return ConcatList.ofInternal(elements, 0, elements.length);
    }

    public abstract boolean isEmpty();

    @Nonnull
    public static <T> ConcatList<T> fromList(@Nonnull List<T> list) {
        return ConcatList.fromListInternal(list.iterator(), 0, list.size());
    }

    @Nonnull
    private static <T> ConcatList<T> ofInternal(@Nonnull T[] elements, int start, int end) {
        if (start == end) {
            return ConcatList.empty();
        }
        if (start + 1 == end) {
            return ConcatList.single(elements[start]);
        }
        int mid = (start + end) / 2;
        return ConcatList.ofInternal(elements, start, mid).append(ConcatList.ofInternal(elements, mid, end));
    }

    @Nonnull
    private static <T> ConcatList<T> fromListInternal(@Nonnull Iterator<T> elements, int start, int end) {
        if (start == end) {
            return ConcatList.empty();
        }
        if (start + 1 == end) {
            return ConcatList.single(elements.next());
        }
        int mid = (start + end) / 2;
        return ConcatList.fromListInternal(elements, start, mid).append(ConcatList.fromListInternal(elements, mid, end));
    }

    public abstract ConcatList<T> balanced();

    @Nonnull
    public final Maybe<Pair<ConcatList<T>, ConcatList<T>>> split(int index) {
        if (index < 0 || index > this.length) {
            return Maybe.empty();
        }
        if (index == 0) {
            return Maybe.of(Pair.of(ConcatList.empty(), this));
        }
        if (index == this.length) {
            return Maybe.of(Pair.of(this, ConcatList.empty()));
        }
        return Maybe.of(this.splitInternal(index));
    }

    abstract Pair<ConcatList<T>, ConcatList<T>> splitInternal(int var1);

    @Nonnull
    public static <T> ConcatList<T> single(@Nonnull T scope) {
        return new Leaf(scope);
    }

    public static <T> Monoid<ConcatList<T>> monoid() {
        return MONOID;
    }

    @Nonnull
    public abstract ImmutableList<T> toList();

    @Nonnull
    public final <B> B foldLeft(@Nonnull F2<B, ? super T, B> f, @Nonnull B init) {
        if (this.isEmpty()) {
            return init;
        }
        Object[] result = new Object[]{init};
        this.forEach(n -> {
            result[0] = f.apply((Object)result[0], (Object)n);
        });
        return (B)result[0];
    }

    @Nonnull
    public final <B> B foldRight(@Nonnull F2<? super T, B, B> f, @Nonnull B init) {
        ArrayDeque stack = new ArrayDeque(this.length);
        stack.add(this);
        while (!stack.isEmpty()) {
            ConcatList curr = (ConcatList)stack.pop();
            if (curr instanceof Fork) {
                Fork fork = (Fork)curr;
                stack.push(fork.left);
                stack.push(fork.right);
                continue;
            }
            if (!(curr instanceof Leaf)) continue;
            init = f.apply(((Leaf)curr).data, init);
        }
        return init;
    }

    @Deprecated
    public final void foreach(@Nonnull Effect<T> f) {
        this.forEach(f::e);
    }

    @Override
    public final void forEach(@Nonnull Consumer<? super T> action) {
        ConcatList[] stack = new ConcatList[this.length];
        int i = 0;
        stack[i++] = this;
        while (i > 0) {
            ConcatList curr;
            if ((curr = stack[--i]) instanceof Fork) {
                Fork fork = (Fork)curr;
                stack[i++] = fork.right;
                stack[i++] = fork.left;
                continue;
            }
            if (!(curr instanceof Leaf)) continue;
            action.accept(((Leaf)curr).data);
        }
    }

    @Nonnull
    public abstract ConcatList<T> append(@Nonnull ConcatList<? extends T> var1);

    @Nonnull
    public final ConcatList<T> append1(@Nonnull T element) {
        return this.append(ConcatList.single(element));
    }

    public final boolean exists(@Nonnull F<T, Boolean> f) {
        return this.find(f).isJust();
    }

    @Nonnull
    public final Maybe<T> find(@Nonnull F<T, Boolean> f) {
        ArrayDeque stack = new ArrayDeque(this.length);
        stack.add(this);
        while (!stack.isEmpty()) {
            ConcatList curr = (ConcatList)stack.pop();
            if (curr instanceof Fork) {
                Fork fork = (Fork)curr;
                stack.push(fork.right);
                stack.push(fork.left);
                continue;
            }
            if (!(curr instanceof Leaf) || !f.apply(((Leaf)curr).data).booleanValue()) continue;
            return Maybe.of(((Leaf)curr).data);
        }
        return Maybe.empty();
    }

    @Nonnull
    public final ConcatList<T> reverse() {
        if (this instanceof Empty) {
            return this;
        }
        ArrayList list = new ArrayList(this.length);
        ArrayDeque stack = new ArrayDeque(this.length);
        stack.add(this);
        while (!stack.isEmpty()) {
            ConcatList curr = (ConcatList)stack.pop();
            if (curr instanceof Fork) {
                Fork fork = (Fork)curr;
                stack.push(fork.left);
                stack.push(fork.right);
                continue;
            }
            if (!(curr instanceof Leaf)) continue;
            list.add(((Leaf)curr).data);
        }
        return ConcatList.fromList(list);
    }

    @Nonnull
    public final Maybe<T> index(int index) {
        ConcatList list = this;
        if (index >= this.length) {
            return Maybe.empty();
        }
        while (list instanceof Fork) {
            ConcatList left = ((Fork)list).left;
            if (index < left.length) {
                list = left;
                continue;
            }
            index -= left.length;
            list = ((Fork)list).right;
        }
        return Maybe.of(((Leaf)list).data);
    }

    @Nullable
    abstract ConcatList<T> updateInternal(int var1, @Nonnull T var2);

    @Nonnull
    public final Maybe<ConcatList<T>> update(int index, @Nonnull T element) {
        return Maybe.fromNullable(this.updateInternal(index, element));
    }

    @Override
    public Spliterator<T> spliterator() {
        return new ConcatListSplitIterator(this);
    }

    private static class BinaryTreeMonoid<T>
    implements Monoid<ConcatList<T>> {
        private BinaryTreeMonoid() {
        }

        @Override
        @Nonnull
        public ConcatList<T> identity() {
            return new Empty();
        }

        @Override
        @Nonnull
        public ConcatList<T> append(ConcatList<T> a, ConcatList<T> b) {
            return a.append(b);
        }
    }

    private static final class ConcatListSplitIterator<T>
    implements Spliterator<T> {
        @Nonnull
        private final Deque<ConcatList<T>> stack;
        private int size;

        private ConcatListSplitIterator(@Nonnull Deque<ConcatList<T>> stack, int size) {
            this.stack = stack;
            this.size = size;
        }

        private ConcatListSplitIterator(@Nonnull ConcatList<T> list) {
            this.stack = new ArrayDeque<ConcatList<T>>(list.length);
            this.stack.add(list);
            this.size = list.length;
        }

        @Override
        public boolean tryAdvance(Consumer<? super T> action) {
            while (!this.stack.isEmpty()) {
                ConcatList<T> curr = this.stack.pop();
                if (curr instanceof Fork) {
                    Fork fork = (Fork)curr;
                    this.stack.push(fork.right);
                    this.stack.push(fork.left);
                    continue;
                }
                if (!(curr instanceof Leaf)) continue;
                --this.size;
                action.accept(((Leaf)curr).data);
                return true;
            }
            return false;
        }

        @Override
        public Spliterator<T> trySplit() {
            ArrayDeque<ConcatList<T>> newDequeue = new ArrayDeque<ConcatList<T>>();
            newDequeue.addAll(this.stack);
            return new ConcatListSplitIterator<T>(newDequeue, this.size);
        }

        @Override
        public long estimateSize() {
            return this.size;
        }

        @Override
        public int characteristics() {
            return 17488;
        }

        @Override
        public void forEachRemaining(Consumer<? super T> action) {
            while (!this.stack.isEmpty()) {
                ConcatList<T> curr = this.stack.pop();
                if (curr instanceof Fork) {
                    Fork fork = (Fork)curr;
                    this.stack.push(fork.right);
                    this.stack.push(fork.left);
                    continue;
                }
                if (!(curr instanceof Leaf)) continue;
                --this.size;
                action.accept(((Leaf)curr).data);
            }
        }
    }

    private static final class Fork<T>
    extends ConcatList<T> {
        @Nonnull
        public final ConcatList<T> left;
        @Nonnull
        public final ConcatList<T> right;

        private Fork(@Nonnull ConcatList<T> left, @Nonnull ConcatList<T> right) {
            super(left.length + right.length, left.isBalanced && right.isBalanced && (left.length + right.length < 16 || left.length > right.length / 2 && left.length < right.length * 2));
            this.left = left;
            this.right = right;
        }

        @Override
        @Nonnull
        public ImmutableList<T> toList() {
            ImmutableList out = ImmutableList.empty();
            Stack<ConcatList<T>> stack = new Stack<ConcatList<T>>();
            stack.push(this.left);
            ConcatList next = this.right;
            while (true) {
                if (next instanceof Fork) {
                    stack.push(((Fork)next).left);
                    next = ((Fork)next).right;
                    continue;
                }
                if (next instanceof Leaf) {
                    out = out.cons(((Leaf)next).data);
                    if (stack.empty()) break;
                    next = (ConcatList)stack.pop();
                    continue;
                }
                if (stack.empty()) break;
                next = (ConcatList)stack.pop();
            }
            return out;
        }

        @Override
        public boolean isEmpty() {
            return false;
        }

        @Override
        public ConcatList<T> balanced() {
            if (this.isBalanced) {
                return this;
            }
            return ConcatList.fromListInternal(this.iterator(), 0, this.length);
        }

        @Override
        @Nonnull
        Pair<ConcatList<T>, ConcatList<T>> splitInternal(int index) {
            Stack<ConcatList<T>> zippers1 = new Stack<ConcatList<T>>();
            Stack<Boolean> zippers2 = new Stack<Boolean>();
            ConcatList list = this;
            while (list instanceof Fork) {
                ConcatList<T> left = list.left;
                if (index < left.length) {
                    zippers1.push(list.right);
                    zippers2.push(false);
                    list = left;
                    continue;
                }
                index -= left.length;
                zippers1.push(left);
                zippers2.push(true);
                list = list.right;
            }
            Pair<ConcatList<T>, ConcatList<T>> result = Pair.of(Fork.empty(), list);
            while (!zippers1.isEmpty()) {
                if (((Boolean)zippers2.pop()).booleanValue()) {
                    result = Pair.of(((ConcatList)zippers1.pop()).append(result.left()), result.right());
                    continue;
                }
                result = Pair.of(result.left(), result.right().append((ConcatList)zippers1.pop()));
            }
            return result;
        }

        @Override
        @Nonnull
        public ConcatList<T> append(@Nonnull ConcatList<? extends T> rhs) {
            if (rhs instanceof Empty) {
                return this;
            }
            return new Fork<T>(this, rhs);
        }

        @Override
        @Nullable
        ConcatList<T> updateInternal(int index, @Nonnull T element) {
            if (index >= this.length) {
                return null;
            }
            Stack<ConcatList<T>> zippers1 = new Stack<ConcatList<T>>();
            Stack<Boolean> zippers2 = new Stack<Boolean>();
            ConcatList list = this;
            while (list instanceof Fork) {
                ConcatList<T> left = list.left;
                if (index < left.length) {
                    zippers1.push(list.right);
                    zippers2.push(false);
                    list = left;
                    continue;
                }
                index -= left.length;
                zippers1.push(left);
                zippers2.push(true);
                list = list.right;
            }
            ConcatList<T> l = ConcatList.single(element);
            while (!zippers1.isEmpty()) {
                l = (Boolean)zippers2.pop() != false ? ((ConcatList)zippers1.pop()).append(l) : l.append((ConcatList)zippers1.pop());
            }
            return l;
        }

        @Override
        public Iterator<T> iterator() {
            return new Iterator<T>(){
                private final ConcatList<T>[] stack;
                int i;
                {
                    this.stack = new ConcatList[length];
                    this.i = 0;
                    this.stack[this.i++] = this;
                }

                @Override
                public boolean hasNext() {
                    return this.i > 0;
                }

                @Override
                public T next() {
                    while (this.i > 0) {
                        ConcatList curr;
                        if ((curr = this.stack[--this.i]) instanceof Fork) {
                            Fork fork = (Fork)curr;
                            this.stack[this.i++] = fork.right;
                            this.stack[this.i++] = fork.left;
                            continue;
                        }
                        if (!(curr instanceof Leaf)) continue;
                        return ((Leaf)curr).data;
                    }
                    throw new NoSuchElementException();
                }
            };
        }
    }

    private static final class Leaf<T>
    extends ConcatList<T> {
        @Nonnull
        public final T data;

        private Leaf(@Nonnull T data) {
            super(1, true);
            this.data = data;
        }

        @Override
        @Nonnull
        public ImmutableList<T> toList() {
            return ImmutableList.of(this.data, new Object[0]);
        }

        @Override
        public boolean isEmpty() {
            return false;
        }

        @Override
        public ConcatList<T> balanced() {
            return this;
        }

        @Override
        Pair<ConcatList<T>, ConcatList<T>> splitInternal(int index) {
            if (index == 0) {
                return Pair.of(ConcatList.empty(), this);
            }
            return Pair.of(this, ConcatList.empty());
        }

        @Override
        @Nonnull
        public ConcatList<T> append(@Nonnull ConcatList<? extends T> rhs) {
            if (rhs instanceof Empty) {
                return this;
            }
            return new Fork(this, rhs);
        }

        @Override
        @Nullable
        ConcatList<T> updateInternal(int index, @Nonnull T element) {
            return index == 0 ? Leaf.single(element) : null;
        }

        @Override
        public Iterator<T> iterator() {
            return Collections.singleton(this.data).iterator();
        }
    }

    private static final class Empty<T>
    extends ConcatList<T> {
        private Empty() {
            super(0, true);
        }

        @Override
        @Nonnull
        public ImmutableList<T> toList() {
            return ImmutableList.empty();
        }

        @Override
        public boolean isEmpty() {
            return true;
        }

        @Override
        public ConcatList<T> balanced() {
            return this;
        }

        @Override
        Pair<ConcatList<T>, ConcatList<T>> splitInternal(int index) {
            return Pair.of(this, this);
        }

        @Override
        @Nonnull
        public ConcatList<T> append(@Nonnull ConcatList<? extends T> rhs) {
            return rhs;
        }

        @Override
        @Nullable
        public ConcatList<T> updateInternal(int index, @Nonnull T element) {
            return null;
        }

        @Override
        public Iterator<T> iterator() {
            return new Iterator<T>(){

                @Override
                public boolean hasNext() {
                    return false;
                }

                @Override
                public T next() {
                    return null;
                }
            };
        }
    }
}

