/*
 * Decompiled with CFR 0.152.
 */
package com.shapesecurity.functional;

import com.shapesecurity.functional.F;
import com.shapesecurity.functional.data.HashCodeBuilder;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nonnull;

@CheckReturnValue
public final class Tuple3<A, B, C> {
    @Nonnull
    public final A a;
    @Nonnull
    public final B b;
    @Nonnull
    public final C c;

    @Nonnull
    public static <A, B, C> Tuple3<A, B, C> of(@Nonnull A a, @Nonnull B b, @Nonnull C c) {
        return new Tuple3<A, B, C>(a, b, c);
    }

    public Tuple3(@Nonnull A a, @Nonnull B b, @Nonnull C c) {
        this.a = a;
        this.b = b;
        this.c = c;
    }

    @Nonnull
    public <A1> Tuple3<A1, B, C> mapA(@Nonnull F<A, A1> f) {
        return new Tuple3<A1, B, C>(f.apply(this.a), this.b, this.c);
    }

    @Nonnull
    public <B1> Tuple3<A, B1, C> mapB(@Nonnull F<B, B1> f) {
        return new Tuple3<A, B1, C>(this.a, f.apply(this.b), this.c);
    }

    @Nonnull
    public <C1> Tuple3<A, B, C1> mapC(@Nonnull F<C, C1> f) {
        return new Tuple3<A, B, C1>(this.a, this.b, f.apply(this.c));
    }

    public boolean equals(Object obj) {
        return obj == this || obj instanceof Tuple3 && ((Tuple3)obj).a.equals(this.a) && ((Tuple3)obj).b.equals(this.b) && ((Tuple3)obj).c.equals(this.c);
    }

    public int hashCode() {
        int hash = HashCodeBuilder.put(HashCodeBuilder.init(), "Tuple3");
        hash = HashCodeBuilder.put(hash, this.a);
        hash = HashCodeBuilder.put(hash, this.b);
        return HashCodeBuilder.put(hash, this.c);
    }
}

