/*
 * Decompiled with CFR 0.152.
 */
package com.shapesecurity.functional.data;

import com.shapesecurity.functional.Effect;
import com.shapesecurity.functional.F;
import com.shapesecurity.functional.ThrowingSupplier;
import com.shapesecurity.functional.Thunk;
import com.shapesecurity.functional.data.HashCodeBuilder;
import com.shapesecurity.functional.data.ImmutableList;
import java.util.Iterator;
import java.util.Objects;
import java.util.function.Predicate;
import java.util.function.Supplier;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.jetbrains.annotations.NotNull;

@CheckReturnValue
public final class Maybe<A>
implements Iterable<A> {
    private static final int NOTHING_HASH_CODE = HashCodeBuilder.put(HashCodeBuilder.init(), "Nothing");
    private static final Maybe NOTHING = new Maybe<Object>(null);
    @Nullable
    private final A value;

    private Maybe(@Nullable A value) {
        this.value = value;
    }

    @Nonnull
    public static <A> Maybe<A> empty() {
        return NOTHING;
    }

    @Nonnull
    @Deprecated
    public static <A> Maybe<A> nothing() {
        return Maybe.empty();
    }

    @Nonnull
    public static <A> Maybe<A> of(@Nonnull A a) {
        return new Maybe<A>(a);
    }

    @Nonnull
    @Deprecated
    public static <A> Maybe<A> just(@Nonnull A a) {
        return Maybe.of(a);
    }

    @Nonnull
    public static <A> Maybe<A> fromNullable(@Nullable A a) {
        if (a == null) {
            return Maybe.empty();
        }
        return Maybe.of(a);
    }

    @Nullable
    public A toNullable() {
        return this.value;
    }

    public static <A> Maybe<A> join(@Nonnull Maybe<Maybe<A>> m) {
        return m.flatMap(a -> a);
    }

    @Nonnull
    public static <A> ImmutableList<A> catMaybes(@Nonnull ImmutableList<Maybe<A>> l) {
        return l.foldRight((a, b) -> a.maybe(b, c -> ImmutableList.cons(c, b)), ImmutableList.empty());
    }

    @Nonnull
    public static <A, B> ImmutableList<B> mapMaybe(@Nonnull F<A, B> f, @Nonnull ImmutableList<Maybe<A>> l) {
        return l.foldRight((a, b) -> a.maybe(b, v -> ImmutableList.cons(f.apply(v), b)), ImmutableList.empty());
    }

    @Nonnull
    public static <A> Maybe<A> iff(boolean test, @Nonnull A a) {
        if (test) {
            return Maybe.of(a);
        }
        return Maybe.empty();
    }

    @Nonnull
    public static <A> Maybe<A> _try(@Nonnull ThrowingSupplier<A> s) {
        try {
            return Maybe.fromNullable(s.get());
        }
        catch (Exception e) {
            return Maybe.empty();
        }
    }

    public boolean eq(@Nonnull Maybe<A> maybe) {
        return Objects.equals(maybe.value, this.value);
    }

    public final boolean equals(Object obj) {
        return obj == this || obj instanceof Maybe && this.eq((Maybe)obj);
    }

    public int hashCode() {
        return this.value == null ? NOTHING_HASH_CODE : HashCodeBuilder.put(this.value.hashCode(), "Just");
    }

    @Nonnull
    public A fromJust() throws NullPointerException {
        return Objects.requireNonNull(this.value);
    }

    @Nonnull
    @Deprecated
    public A just() throws NullPointerException {
        return this.fromJust();
    }

    @Nonnull
    public <B> B maybe(@Nonnull B def, @Nonnull F<A, B> f) {
        return this.value == null ? def : f.apply(this.value);
    }

    public final void foreach(@Nonnull Effect<A> f) {
        this.map(f);
    }

    public final void foreach(@Nonnull Runnable r, @Nonnull Effect<A> f) {
        if (this.value == null) {
            r.run();
        } else {
            f.apply((Object)this.value);
        }
    }

    public boolean isJust() {
        return this.value != null;
    }

    public final boolean isNothing() {
        return !this.isJust();
    }

    @Nonnull
    public ImmutableList<A> toList() {
        return this.value == null ? ImmutableList.empty() : ImmutableList.from(this.value);
    }

    @Nonnull
    public A orJust(@Nonnull A a) {
        return this.value == null ? a : this.value;
    }

    @Nonnull
    @Deprecated
    public A orJustLazy(@Nonnull Thunk<A> a) {
        return this.value == null ? a.get() : this.value;
    }

    @Nonnull
    public A orJustLazy(@Nonnull Supplier<A> a) {
        return this.value == null ? a.get() : this.value;
    }

    @Nonnull
    public <B> Maybe<B> map(@Nonnull F<A, B> f) {
        return this.value == null ? this : Maybe.of(f.apply(this.value));
    }

    @Nonnull
    public final <B> Maybe<B> bind(@Nonnull F<A, Maybe<B>> f) {
        return this.flatMap(f);
    }

    @Nonnull
    public <B> Maybe<B> flatMap(@Nonnull F<A, Maybe<B>> f) {
        return this.value == null ? this : f.apply(this.value);
    }

    @Nonnull
    public Maybe<A> filter(@Nonnull F<A, Boolean> f) {
        return this.filterByPredicate(f::apply);
    }

    @Nonnull
    public Maybe<A> filterByPredicate(@Nonnull Predicate<A> f) {
        return this.value == null ? this : (f.test(this.value) ? this : Maybe.empty());
    }

    @Override
    @NotNull
    public Iterator<A> iterator() {
        return new Iterator<A>(){
            private boolean hasNext;
            {
                this.hasNext = Maybe.this.isJust();
            }

            @Override
            public boolean hasNext() {
                return this.hasNext;
            }

            @Override
            public A next() {
                if (this.hasNext) {
                    this.hasNext = false;
                    return Maybe.this.value;
                }
                return null;
            }
        };
    }
}

