/*
 * Decompiled with CFR 0.152.
 */
package com.shapesecurity.functional.data;

import com.shapesecurity.functional.F;
import com.shapesecurity.functional.F2;
import com.shapesecurity.functional.Pair;
import com.shapesecurity.functional.data.HashTable;
import com.shapesecurity.functional.data.ImmutableList;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nonnull;

@CheckReturnValue
public class MultiHashTable<K, V> {
    @Nonnull
    private final HashTable<K, ImmutableList<V>> data;

    private MultiHashTable(@Nonnull HashTable<K, ImmutableList<V>> data) {
        this.data = data;
    }

    @Nonnull
    public static <K, V> MultiHashTable<K, V> emptyUsingEquality() {
        return new MultiHashTable(HashTable.emptyUsingEquality());
    }

    @Nonnull
    public static <K, V> MultiHashTable<K, V> emptyUsingIdentity() {
        return new MultiHashTable(HashTable.emptyUsingIdentity());
    }

    @Nonnull
    @Deprecated
    public static <K, V> MultiHashTable<K, V> empty() {
        return MultiHashTable.emptyUsingEquality();
    }

    @Nonnull
    @Deprecated
    public static <K, V> MultiHashTable<K, V> emptyP() {
        return MultiHashTable.emptyUsingIdentity();
    }

    @Nonnull
    public MultiHashTable<K, V> put(@Nonnull K key, @Nonnull V value) {
        return new MultiHashTable<K, V>(this.data.put(key, ImmutableList.cons(value, this.data.get(key).orJust(ImmutableList.empty()))));
    }

    @Nonnull
    public MultiHashTable<K, V> remove(@Nonnull K key) {
        return new MultiHashTable<K, V>(this.data.remove(key));
    }

    @Nonnull
    public ImmutableList<V> get(@Nonnull K key) {
        return this.data.get(key).orJust(ImmutableList.empty());
    }

    @Nonnull
    public MultiHashTable<K, V> merge(@Nonnull MultiHashTable<K, V> tree) {
        return this.merge(tree, ImmutableList::append);
    }

    @Nonnull
    public MultiHashTable<K, V> merge(@Nonnull MultiHashTable<K, V> tree, @Nonnull F2<ImmutableList<V>, ImmutableList<V>, ImmutableList<V>> merger) {
        return new MultiHashTable<K, V>(this.data.merge(tree.data, merger));
    }

    @Nonnull
    public ImmutableList<Pair<K, ImmutableList<V>>> entries() {
        return this.data.entries();
    }

    @Nonnull
    public <B> HashTable<K, B> toHashTable(@Nonnull F<ImmutableList<V>, B> conversion) {
        return this.toHashTable((K k, ImmutableList<V> vs) -> conversion.apply((ImmutableList)vs));
    }

    @Nonnull
    public <B> HashTable<K, B> toHashTable(@Nonnull F2<K, ImmutableList<V>, B> conversion) {
        return this.data.foldLeft((acc, p) -> acc.put(p.left, conversion.apply((Object)p.left, (ImmutableList)p.right)), HashTable.empty(this.data.hasher));
    }

    @Nonnull
    public final ImmutableList<ImmutableList<V>> values() {
        return this.data.foldLeft((acc, p) -> acc.cons(p.right), ImmutableList.empty());
    }

    @Nonnull
    public final ImmutableList<V> gatherValues() {
        return this.data.foldLeft((acc, p) -> acc.append((ImmutableList)p.right), ImmutableList.empty());
    }

    @Nonnull
    public final <B> MultiHashTable<K, B> mapValues(@Nonnull F<V, B> f) {
        return new MultiHashTable<K, V>(this.data.map(l -> l.map(f)));
    }
}

