/*
 * Decompiled with CFR 0.152.
 */
package com.shapesecurity.functional.data;

import com.shapesecurity.functional.Effect;
import com.shapesecurity.functional.F;
import com.shapesecurity.functional.F2;
import com.shapesecurity.functional.Pair;
import com.shapesecurity.functional.Unit;
import com.shapesecurity.functional.data.Hasher;
import com.shapesecurity.functional.data.ImmutableList;
import com.shapesecurity.functional.data.ImmutableSet;
import com.shapesecurity.functional.data.Maybe;
import com.shapesecurity.functional.data.NonEmptyImmutableList;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.function.Consumer;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nonnull;

@CheckReturnValue
public abstract class HashTable<K, V>
implements Iterable<Pair<K, V>> {
    private static final Hasher<Object> EQUALITY_HASHER = new Hasher<Object>(){

        @Override
        public int hash(@Nonnull Object data) {
            return data.hashCode();
        }

        @Override
        public boolean eq(@Nonnull Object o, @Nonnull Object b) {
            return o.equals(b);
        }
    };
    public static final Hasher<Object> IDENTITY_HASHER = new Hasher<Object>(){

        @Override
        public int hash(@Nonnull Object data) {
            return System.identityHashCode(data);
        }

        @Override
        public boolean eq(@Nonnull Object o, @Nonnull Object b) {
            return o == b;
        }
    };
    @Nonnull
    public final Hasher<K> hasher;
    public final int length;

    protected HashTable(@Nonnull Hasher<K> hasher, int length) {
        this.hasher = hasher;
        this.length = length;
    }

    @Nonnull
    public static <K> Hasher<K> equalityHasher() {
        return EQUALITY_HASHER;
    }

    @Nonnull
    @Deprecated
    public static <K> Hasher<K> defaultHasher() {
        return HashTable.equalityHasher();
    }

    @Nonnull
    public static <K> Hasher<K> identityHasher() {
        return IDENTITY_HASHER;
    }

    @Nonnull
    public static <K, V> HashTable<K, V> empty(@Nonnull Hasher<K> hasher) {
        return new Empty(hasher);
    }

    @Nonnull
    public static <K, V> HashTable<K, V> emptyUsingEquality() {
        return HashTable.empty(HashTable.equalityHasher());
    }

    @Nonnull
    public static <K, V> HashTable<K, V> emptyUsingIdentity() {
        return HashTable.empty(HashTable.identityHasher());
    }

    @Nonnull
    @Deprecated
    public static <K, V> HashTable<K, V> empty() {
        return HashTable.emptyUsingEquality();
    }

    @Nonnull
    @Deprecated
    public static <K, V> HashTable<K, V> emptyP() {
        return HashTable.emptyUsingIdentity();
    }

    @Nonnull
    public static <K, V> HashTable<K, V> fromUsingEquality(@Nonnull Map<K, V> map) {
        return HashTable.emptyUsingEquality().putAllFrom(map);
    }

    @Nonnull
    public static <K, V> HashTable<K, V> fromUsingIdentity(@Nonnull IdentityHashMap<K, V> map) {
        return HashTable.emptyUsingIdentity().putAllFrom(map);
    }

    @Nonnull
    public static <K, V> HashTable<K, V> from(@Nonnull Hasher<K> hasher, @Nonnull Map<K, V> map) {
        return HashTable.empty(hasher).putAllFrom(map);
    }

    @Nonnull
    public final HashMap<K, V> toHashMap() {
        if (!this.hasher.equals(HashTable.equalityHasher())) {
            throw new UnsupportedOperationException("HashTable::toHashMap requires an equality hasher.");
        }
        HashMap map = new HashMap();
        for (Pair pair : this) {
            map.put(pair.left, pair.right);
        }
        return map;
    }

    @Nonnull
    public final IdentityHashMap<K, V> toIdentityHashMap() {
        if (!this.hasher.equals(HashTable.identityHasher())) {
            throw new UnsupportedOperationException("HashTable::toIdentityHashMap requires an identity hasher.");
        }
        IdentityHashMap map = new IdentityHashMap();
        for (Pair pair : this) {
            map.put(pair.left, pair.right);
        }
        return map;
    }

    @Nonnull
    public static <K, V> HashTable<K, V> fromUsingEquality(@Nonnull Iterable<Pair<K, V>> list) {
        return HashTable.emptyUsingEquality().putAll(list);
    }

    @Nonnull
    public static <K, V> HashTable<K, V> fromUsingIdentity(@Nonnull Iterable<Pair<K, V>> list) {
        return HashTable.emptyUsingIdentity().putAll(list);
    }

    @Nonnull
    public static <K, V> HashTable<K, V> from(@Nonnull Hasher<K> hasher, @Nonnull Iterable<Pair<K, V>> list) {
        return HashTable.empty(hasher).putAll(list);
    }

    @Nonnull
    public final HashTable<K, V> put(@Nonnull K key, @Nonnull V value) {
        return this.put(key, value, this.hasher.hash(key));
    }

    @Nonnull
    public final HashTable<K, V> put(@Nonnull Pair<K, V> pair) {
        return this.put(pair.left, pair.right);
    }

    @Nonnull
    public final HashTable<K, V> putAll(@Nonnull Iterable<Pair<K, V>> pairs) {
        HashTable table = this;
        for (Pair<K, V> pair : pairs) {
            table = table.put(pair.left, pair.right);
        }
        return table;
    }

    @Nonnull
    public final HashTable<K, V> remove(@Nonnull K key) {
        return this.remove(key, this.hasher.hash(key)).orJust(this);
    }

    @Nonnull
    protected abstract HashTable<K, V> put(@Nonnull K var1, @Nonnull V var2, int var3);

    @Nonnull
    protected abstract Maybe<HashTable<K, V>> remove(@Nonnull K var1, int var2);

    @Nonnull
    public final Maybe<V> get(@Nonnull K key) {
        return this.get(key, this.hasher.hash(key));
    }

    @Nonnull
    protected abstract Maybe<V> get(@Nonnull K var1, int var2);

    @Nonnull
    public final HashTable<K, V> merge(@Nonnull HashTable<K, V> tree) {
        return this.merge(tree, (a, b) -> b);
    }

    @Nonnull
    public final HashTable<K, V> putAllFrom(@Nonnull Map<K, V> map) {
        HashTable<K, V> table = this;
        for (Map.Entry<K, V> entry : map.entrySet()) {
            table = table.put(entry.getKey(), entry.getValue());
        }
        return table;
    }

    @Nonnull
    public abstract HashTable<K, V> merge(@Nonnull HashTable<K, V> var1, @Nonnull F2<V, V, V> var2);

    @Nonnull
    public abstract <A> A foldLeft(@Nonnull F2<A, Pair<K, V>, A> var1, @Nonnull A var2);

    @Nonnull
    public abstract <A> A foldRight(@Nonnull F2<Pair<K, V>, A, A> var1, @Nonnull A var2);

    @Nonnull
    public ImmutableList<Pair<K, V>> entries() {
        Pair[] pairs = new Pair[this.length];
        int[] i = new int[1];
        this.forEach((Consumer<? super Pair<K, V>>)((Consumer<Pair>)x -> {
            int n = i[0];
            i[0] = n + 1;
            pairs[n] = x;
        }));
        return ImmutableList.from(pairs);
    }

    @Nonnull
    public ImmutableList<Pair<K, V>> orderedEntries(Comparator<? super K> comparator) {
        ArrayList<Pair> entries = new ArrayList<Pair>(this.length);
        for (Pair entry : this) {
            entries.add(entry);
        }
        entries.sort((e1, e2) -> comparator.compare((Object)e1.left, (Object)e2.left));
        return ImmutableList.from(entries);
    }

    public final void foreach(@Nonnull Effect<Pair<K, V>> e) {
        this.forEach((Consumer<? super Pair<K, V>>)((Consumer<Pair>)e::e));
    }

    @Override
    public abstract void forEach(@Nonnull Consumer<? super Pair<K, V>> var1);

    @Nonnull
    public abstract Maybe<Pair<K, V>> find(@Nonnull F<Pair<K, V>, Boolean> var1);

    @Nonnull
    public abstract <R> Maybe<R> findMap(@Nonnull F<Pair<K, V>, Maybe<R>> var1);

    @Nonnull
    public final HashTable<K, V> filter(F<Pair<K, V>, Boolean> f) {
        return this.foldLeft((acc, pair) -> (Boolean)f.apply((Pair)pair) != false ? acc.put(pair.left, pair.right) : acc, HashTable.empty(this.hasher));
    }

    public abstract <B> HashTable<K, B> map(@Nonnull F<V, B> var1);

    public boolean containsKey(@Nonnull K key) {
        return this.containsKey(key, this.hasher.hash(key));
    }

    public abstract boolean containsKey(@Nonnull K var1, int var2);

    public boolean containsValue(@Nonnull V value) {
        return this.find(p -> p.right == value).isJust();
    }

    @Nonnull
    public ImmutableSet<K> keys() {
        return new ImmutableSet<K>(this.map(F.constant(Unit.unit)));
    }

    private static final class Fork<K, V>
    extends HashTable<K, V> {
        @Nonnull
        private final HashTable<K, V>[] children;

        private Fork(@Nonnull Hasher<K> hasher, @Nonnull HashTable<K, V>[] children, int length) {
            super(hasher, length);
            this.children = children;
        }

        @Override
        @Nonnull
        protected HashTable<K, V> put(@Nonnull K key, @Nonnull V value, int hash) {
            int subHash = hash & 0x1F;
            HashTable[] cloned = (HashTable[])this.children.clone();
            if (cloned[subHash] == null) {
                cloned[subHash] = new Leaf(this.hasher, ImmutableList.empty(), hash >>> 5, 0);
            }
            int oldLength = cloned[subHash].length;
            cloned[subHash] = cloned[subHash].put(key, value, hash >>> 5);
            return new Fork<K, V>(this.hasher, cloned, this.length - oldLength + cloned[subHash].length);
        }

        @Override
        @Nonnull
        protected Maybe<HashTable<K, V>> remove(@Nonnull K key, int hash) {
            int subHash = hash & 0x1F;
            if (this.children[subHash] == null) {
                return Maybe.empty();
            }
            Maybe<HashTable<K, V>> removed = this.children[subHash].remove(key, hash >>> 5);
            return removed.map((A newChild) -> {
                if (this.length == 1) {
                    return new Empty(this.hasher);
                }
                HashTable[] cloned = (HashTable[])this.children.clone();
                cloned[subHash] = newChild;
                return new Fork<K, V>(this.hasher, cloned, this.length - 1);
            });
        }

        @Override
        @Nonnull
        protected Maybe<V> get(@Nonnull K key, int hash) {
            int subHash = hash & 0x1F;
            if (this.children[subHash] == null) {
                return Maybe.empty();
            }
            return this.children[subHash].get(key, hash >>> 5);
        }

        @Override
        @Nonnull
        public Fork<K, V> merge(@Nonnull HashTable<K, V> tree, @Nonnull F2<V, V, V> merger) {
            if (tree instanceof Empty) {
                return this;
            }
            if (tree instanceof Leaf) {
                Leaf leaf = (Leaf)tree;
                return this.mergeFork(leaf.toFork(), merger);
            }
            return this.mergeFork((Fork)tree, merger);
        }

        @Nonnull
        private Fork<K, V> mergeFork(@Nonnull Fork<K, V> tree, @Nonnull F2<V, V, V> merger) {
            HashTable[] cloned = (HashTable[])this.children.clone();
            int count = 0;
            for (int i = 0; i < cloned.length; ++i) {
                if (cloned[i] == null) {
                    cloned[i] = tree.children[i];
                } else if (tree.children[i] != null) {
                    cloned[i] = cloned[i].merge(tree.children[i], merger);
                }
                if (cloned[i] == null) continue;
                count += cloned[i].length;
            }
            return new Fork<K, V>(this.hasher, cloned, count);
        }

        @Override
        @Nonnull
        public <A> A foldLeft(@Nonnull F2<A, Pair<K, V>, A> f, @Nonnull A init) {
            for (HashTable<K, V> child : this.children) {
                if (child == null) continue;
                init = child.foldLeft(f, init);
            }
            return init;
        }

        @Override
        @Nonnull
        public <A> A foldRight(@Nonnull F2<Pair<K, V>, A, A> f, @Nonnull A init) {
            for (int i = this.children.length - 1; i >= 0; --i) {
                if (this.children[i] == null) continue;
                init = this.children[i].foldRight(f, init);
            }
            return init;
        }

        @Override
        public Iterator<Pair<K, V>> iterator() {
            return new Iterator<Pair<K, V>>(){
                private final HashTable<K, V>[] stack;
                private Iterator<Pair<K, V>> currentIterator;
                int i;
                {
                    this.stack = new HashTable[length];
                    this.currentIterator = null;
                    this.i = 0;
                    this.stack[this.i++] = this;
                }

                private void updateState() {
                    if (this.currentIterator != null && this.currentIterator.hasNext()) {
                        return;
                    }
                    this.currentIterator = null;
                    while (this.i > 0) {
                        --this.i;
                        HashTable curr = this.stack[this.i];
                        if (curr instanceof Fork) {
                            Fork fork = (Fork)curr;
                            for (HashTable child : fork.children) {
                                if (child == null || child.length <= 0) continue;
                                this.stack[this.i] = child;
                                ++this.i;
                            }
                            continue;
                        }
                        if (!(curr instanceof Leaf)) continue;
                        this.currentIterator = ((Leaf)curr).dataList.iterator();
                        if (this.currentIterator.hasNext()) {
                            return;
                        }
                        this.currentIterator = null;
                    }
                }

                @Override
                public boolean hasNext() {
                    this.updateState();
                    return this.currentIterator != null;
                }

                @Override
                public Pair<K, V> next() {
                    this.updateState();
                    if (this.currentIterator == null) {
                        throw new NoSuchElementException();
                    }
                    return this.currentIterator.next();
                }
            };
        }

        @Override
        public void forEach(@Nonnull Consumer<? super Pair<K, V>> e) {
            for (HashTable<K, V> child : this.children) {
                if (child == null) continue;
                child.forEach((Consumer<Pair<K, V>>)e);
            }
        }

        @Override
        @Nonnull
        public Maybe<Pair<K, V>> find(@Nonnull F<Pair<K, V>, Boolean> f) {
            HashTable<K, V>[] children;
            for (HashTable<K, V> child : children = this.children) {
                Maybe<Pair<K, V>> p;
                if (child == null || !(p = child.find(f)).isJust()) continue;
                return p;
            }
            return Maybe.empty();
        }

        @Override
        @Nonnull
        public <R> Maybe<R> findMap(@Nonnull F<Pair<K, V>, Maybe<R>> f) {
            HashTable<K, V>[] children;
            for (HashTable<K, V> child : children = this.children) {
                Maybe<R> p;
                if (child == null || !(p = child.findMap(f)).isJust()) continue;
                return p;
            }
            return Maybe.empty();
        }

        @Override
        public <B> Fork<K, B> map(@Nonnull F<V, B> f) {
            HashTable[] clone = new HashTable[this.children.length];
            for (int i = 0; i < clone.length; ++i) {
                if (this.children[i] == null) continue;
                clone[i] = this.children[i].map(f);
            }
            return new Fork<K, V>(this.hasher, clone, this.length);
        }

        @Override
        public boolean containsKey(@Nonnull K key, int hash) {
            int subHash = hash & 0x1F;
            return this.children[subHash] != null && this.children[subHash].containsKey(key, hash >>> 5);
        }
    }

    private static final class Leaf<K, V>
    extends HashTable<K, V> {
        @Nonnull
        private final ImmutableList<Pair<K, V>> dataList;
        public int baseHash;

        protected Leaf(@Nonnull Hasher<K> hasher, @Nonnull ImmutableList<Pair<K, V>> dataList, int baseHash, int length) {
            super(hasher, length);
            this.dataList = dataList;
            this.baseHash = baseHash;
        }

        @Override
        @Nonnull
        protected HashTable<K, V> put(@Nonnull K key, @Nonnull V value, int hash) {
            if (hash == this.baseHash) {
                Pair result = this.dataList.mapAccumL((found, kvPair) -> {
                    if (found.booleanValue()) {
                        return new Pair<Boolean, Pair>(true, (Pair)kvPair);
                    }
                    if (this.hasher.eq(kvPair.left, key)) {
                        return new Pair<Boolean, Pair<Object, Object>>(true, new Pair<Object, Object>(key, value));
                    }
                    return new Pair<Boolean, Pair>(false, (Pair)kvPair);
                }, false);
                if (((Boolean)result.left).booleanValue()) {
                    return new Leaf<K, V>(this.hasher, (ImmutableList)result.right, hash, this.length);
                }
                return new Leaf<K, V>(this.hasher, this.dataList.cons(new Pair<K, V>(key, value)), hash, this.length + 1);
            }
            return this.toFork().put(key, value, hash);
        }

        @Override
        @Nonnull
        protected Maybe<HashTable<K, V>> remove(@Nonnull K key, int hash) {
            if (this.baseHash != hash) {
                return Maybe.empty();
            }
            Pair result = this.dataList.foldRight((? super A i, B p) -> {
                if (((Boolean)p.left).booleanValue()) {
                    return new Pair<Boolean, NonEmptyImmutableList<Pair>>(true, ((ImmutableList)p.right).cons(i));
                }
                if (this.hasher.eq(i.left, key)) {
                    return new Pair(true, p.right);
                }
                return new Pair<Boolean, NonEmptyImmutableList<Pair>>(false, ((ImmutableList)p.right).cons(i));
            }, new Pair(false, ImmutableList.empty()));
            if (((Boolean)result.left).booleanValue()) {
                if (this.length == 1) {
                    return Maybe.of(Leaf.empty(this.hasher));
                }
                return Maybe.of(new Leaf<K, V>(this.hasher, (ImmutableList)result.right, this.baseHash, this.length - 1));
            }
            return Maybe.empty();
        }

        private Fork<K, V> toFork() {
            int subHash = this.baseHash & 0x1F;
            HashTable[] children = new HashTable[32];
            children[subHash] = new Leaf<K, V>(this.hasher, this.dataList, this.baseHash >>> 5, this.length);
            return new Fork(this.hasher, children, this.length);
        }

        @Override
        @Nonnull
        protected Maybe<V> get(@Nonnull K key, int hash) {
            if (this.baseHash != hash) {
                return Maybe.empty();
            }
            Maybe<Pair> pairMaybe = this.dataList.find((A kvPair) -> this.hasher.eq(kvPair.left, key));
            return pairMaybe.map((A p) -> p.right);
        }

        @Override
        @Nonnull
        public HashTable<K, V> merge(@Nonnull HashTable<K, V> tree, @Nonnull F2<V, V, V> merger) {
            if (tree instanceof Empty) {
                return this;
            }
            if (tree instanceof Leaf) {
                Leaf leaf = (Leaf)tree;
                if (leaf.baseHash == this.baseHash) {
                    Pair[] pairs = this.dataList.toArray(new Pair[this.dataList.length]);
                    ImmutableList right = leaf.dataList.foldLeft((B result, ? super A kvPair) -> {
                        for (int i = 0; i < pairs.length; ++i) {
                            if (!this.hasher.eq(pairs[i].left, kvPair.left)) continue;
                            pairs[i] = new Pair(pairs[i].left, merger.apply(pairs[i].right, kvPair.right));
                            return result;
                        }
                        return result.cons(kvPair);
                    }, ImmutableList.empty());
                    ImmutableList<Pair<K, V>> newList = ImmutableList.from(pairs).append(right);
                    return new Leaf<K, V>(this.hasher, newList, this.baseHash, newList.length);
                }
            }
            return this.toFork().merge((HashTable)tree, (F2)merger);
        }

        @Override
        @Nonnull
        public <A> A foldLeft(@Nonnull F2<A, Pair<K, V>, A> f, @Nonnull A init) {
            return this.dataList.foldLeft(f, init);
        }

        @Override
        @Nonnull
        public <A> A foldRight(@Nonnull F2<Pair<K, V>, A, A> f, @Nonnull A init) {
            return this.dataList.foldRight(f, init);
        }

        @Override
        public Iterator<Pair<K, V>> iterator() {
            return this.dataList.iterator();
        }

        @Override
        public void forEach(@Nonnull Consumer<? super Pair<K, V>> e) {
            this.dataList.forEach((Consumer<Pair<K, V>>)e);
        }

        @Override
        @Nonnull
        public Maybe<Pair<K, V>> find(@Nonnull F<Pair<K, V>, Boolean> f) {
            return this.dataList.find(f);
        }

        @Override
        @Nonnull
        public <R> Maybe<R> findMap(@Nonnull F<Pair<K, V>, Maybe<R>> f) {
            return this.dataList.findMap(f);
        }

        @Override
        public <B> Leaf<K, B> map(@Nonnull F<V, B> f) {
            return new Leaf<K, V>(this.hasher, this.dataList.map((A pair) -> pair.mapRight(f)), this.baseHash, this.length);
        }

        @Override
        public boolean containsKey(@Nonnull K key, int hash) {
            return hash == this.baseHash && this.dataList.exists(kvPair -> this.hasher.eq(kvPair.left, key));
        }
    }

    private static final class Empty<K, V>
    extends HashTable<K, V> {
        protected Empty(@Nonnull Hasher<K> hasher) {
            super(hasher, 0);
        }

        @Override
        @Nonnull
        protected HashTable<K, V> put(@Nonnull K key, @Nonnull V value, int hash) {
            return new Leaf(this.hasher, ImmutableList.of(new Pair<K, V>(key, value), new Pair[0]), hash, 1);
        }

        @Override
        @Nonnull
        protected Maybe<HashTable<K, V>> remove(@Nonnull K key, int hash) {
            return Maybe.empty();
        }

        @Override
        @Nonnull
        protected Maybe<V> get(@Nonnull K key, int hash) {
            return Maybe.empty();
        }

        @Override
        @Nonnull
        public HashTable<K, V> merge(@Nonnull HashTable<K, V> tree, @Nonnull F2<V, V, V> merger) {
            return tree;
        }

        @Override
        @Nonnull
        public <A> A foldLeft(@Nonnull F2<A, Pair<K, V>, A> f, @Nonnull A init) {
            return init;
        }

        @Override
        @Nonnull
        public <A> A foldRight(@Nonnull F2<Pair<K, V>, A, A> f, @Nonnull A init) {
            return init;
        }

        @Override
        public Iterator<Pair<K, V>> iterator() {
            return new Iterator<Pair<K, V>>(){

                @Override
                public boolean hasNext() {
                    return false;
                }

                @Override
                public Pair<K, V> next() {
                    throw new NoSuchElementException();
                }
            };
        }

        @Override
        public void forEach(@Nonnull Consumer<? super Pair<K, V>> e) {
        }

        @Override
        @Nonnull
        public Maybe<Pair<K, V>> find(@Nonnull F<Pair<K, V>, Boolean> f) {
            return Maybe.empty();
        }

        @Override
        @Nonnull
        public <R> Maybe<R> findMap(@Nonnull F<Pair<K, V>, Maybe<R>> f) {
            return Maybe.empty();
        }

        @Override
        public <B> HashTable<K, B> map(@Nonnull F<V, B> f) {
            return Empty.empty(this.hasher);
        }

        @Override
        public boolean containsKey(@Nonnull K key, int hash) {
            return false;
        }
    }
}

