/*
 * Decompiled with CFR 0.152.
 */
package com.siftscience;

import com.siftscience.FieldSet;
import com.siftscience.model.BaseResponseBody;
import java.io.IOException;
import okhttp3.Response;
import okhttp3.ResponseBody;

public abstract class SiftResponse<T extends BaseResponseBody<T>> {
    private Response okResponse;
    private int time;
    private FieldSet requestBody;
    T body;

    SiftResponse(Response okResponse, FieldSet requestBody) throws IOException {
        String bodyString;
        this.okResponse = okResponse;
        this.requestBody = requestBody;
        ResponseBody rspBody = okResponse.body();
        if (rspBody != null && !(bodyString = rspBody.string()).isEmpty()) {
            this.populateBodyFromJson(bodyString);
        }
    }

    abstract void populateBodyFromJson(String var1);

    public int getHttpStatusCode() {
        return this.okResponse.code();
    }

    public T getResponseBody() {
        return this.body;
    }

    public String getErrorMessage() {
        if (this.body != null) {
            return ((BaseResponseBody)this.body).getErrorMessage();
        }
        return null;
    }

    public int getTime() {
        return this.time;
    }

    SiftResponse setTime(int time) {
        this.time = time;
        return this;
    }

    public FieldSet getRequestBody() {
        return this.requestBody;
    }

    SiftResponse setRequestBody(FieldSet requestBody) {
        this.requestBody = requestBody;
        return this;
    }

    public boolean isSuccessful() {
        return this.okResponse.isSuccessful();
    }

    Response getOkResponse() {
        return this.okResponse;
    }

    public Integer getSiftStatusCode() {
        if (this.body != null) {
            return ((BaseResponseBody)this.body).getStatus();
        }
        return null;
    }
}

