/*
 * Decompiled with CFR 0.152.
 */
package com.siftscience;

import com.siftscience.FieldSet;
import com.siftscience.model.BaseResponseBody;
import java.io.IOException;
import okhttp3.Response;
import okhttp3.ResponseBody;

public abstract class SiftResponse<T extends BaseResponseBody<T>> {
    private Response okResponse;
    private int time;
    private FieldSet requestBody;
    T body;

    SiftResponse(Response okResponse, FieldSet requestBody) throws IOException {
        String bodyString;
        this.okResponse = okResponse;
        this.requestBody = requestBody;
        ResponseBody rspBody = okResponse.body();
        if (rspBody != null && !(bodyString = rspBody.string()).isEmpty()) {
            this.populateBodyFromJson(bodyString);
        }
    }

    abstract void populateBodyFromJson(String var1);

    public int getHttpStatusCode() {
        return this.okResponse.code();
    }

    public T getBody() {
        return this.body;
    }

    public int getTime() {
        return this.time;
    }

    SiftResponse setTime(int time) {
        this.time = time;
        return this;
    }

    public FieldSet getRequestBody() {
        return this.requestBody;
    }

    public boolean isOk() {
        return this.okResponse != null && this.okResponse.isSuccessful();
    }

    public Integer getApiStatus() {
        if (this.body != null) {
            return ((BaseResponseBody)this.body).getStatus();
        }
        return null;
    }

    public String getApiErrorMessage() {
        if (this.body != null) {
            return ((BaseResponseBody)this.body).getErrorMessage();
        }
        return null;
    }
}

