/*
 * Decompiled with CFR 0.152.
 */
package com.splunk.support.lambda;

import java.io.IOException;
import okhttp3.Interceptor;
import okhttp3.Request;
import okhttp3.Response;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AuthTokenInterceptor
implements Interceptor {
    private static final Logger log = LoggerFactory.getLogger((String)AuthTokenInterceptor.class.getName());
    static final String TOKEN_PROPERTY_NAME = "SIGNALFX_AUTH_TOKEN";
    static final String TOKEN_HEADER = "X-SF-TOKEN";

    public Response intercept(Interceptor.Chain chain) throws IOException {
        Request request = chain.request();
        String token = System.getenv(TOKEN_PROPERTY_NAME);
        if (token != null) {
            request = request.newBuilder().addHeader(TOKEN_HEADER, token).build();
            log.debug("Executing call on {} using token {}", (Object)request.url(), (Object)this.maskToken(token));
        } else {
            log.debug("Auth token not configured as env property {}", (Object)TOKEN_PROPERTY_NAME);
        }
        return chain.proceed(request);
    }

    private String maskToken(String token) {
        return token.charAt(0) + "******" + token.charAt(token.length() - 1);
    }
}

