/*
 * Decompiled with CFR 0.152.
 */
package com.splunk.support.lambda;

import com.splunk.support.lambda.ExportersInitializer;
import com.splunk.support.lambda.PropagatorsInitializer;
import io.opentelemetry.instrumentation.api.config.Config;
import io.opentelemetry.instrumentation.api.config.ConfigBuilder;
import java.util.logging.ConsoleHandler;
import java.util.logging.Level;
import java.util.logging.SimpleFormatter;
import java.util.regex.Pattern;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Configurator {
    private static final Logger log = LoggerFactory.getLogger(Configurator.class);
    private static final String EXPORTERS_CONFIG = "otel.exporter";
    private static final String PROPAGATORS_CONFIG = "otel.propagators";
    static final String OTEL_LIB_LOG_LEVEL = "OTEL_LIB_LOG_LEVEL";
    private static final String DISABLED_RESOURCE_PROVIDERS = String.join((CharSequence)",", "io.opentelemetry.sdk.extension.aws.resource.BeanstalkResource", "io.opentelemetry.sdk.extension.aws.resource.Ec2Resource", "io.opentelemetry.sdk.extension.aws.resource.EcsResource", "io.opentelemetry.sdk.extension.aws.resource.EksResource");
    private static final Pattern ENV_REPLACEMENT = Pattern.compile("[^a-zA-Z0-9_]");

    public static void configure() {
        Configurator.setDefaultValues();
        Config.internalInitializeConfig((Config)new ConfigBuilder().readEnvironmentVariables().readSystemProperties().build());
        Configurator.configureOtelLogging();
        ExportersInitializer.initializeExporters(Config.get().getListProperty(EXPORTERS_CONFIG), Config.get().asJavaProperties());
        PropagatorsInitializer.initializePropagators(Config.get().getListProperty(PROPAGATORS_CONFIG));
    }

    private static void configureOtelLogging() {
        ConsoleHandler consoleHandler = new ConsoleHandler();
        consoleHandler.setLevel(Level.FINEST);
        consoleHandler.setFormatter(new SimpleFormatter());
        java.util.logging.Logger otel = java.util.logging.Logger.getLogger("io.opentelemetry");
        otel.setLevel(Configurator.getOtelLibLogLevel());
        otel.addHandler(consoleHandler);
        log.info("Configured OTEL lib log level: {}", (Object)otel.getLevel());
    }

    private static Level getOtelLibLogLevel() {
        String level = System.getenv(OTEL_LIB_LOG_LEVEL);
        if (level != null) {
            try {
                return Level.parse(level);
            }
            catch (IllegalArgumentException iae) {
                log.debug("Could not parse OTEL lib log level", (Throwable)iae);
            }
        }
        return Level.WARNING;
    }

    private static void setDefaultValues() {
        Configurator.setDefaultValue(PROPAGATORS_CONFIG, "b3");
        Configurator.setDefaultValue(EXPORTERS_CONFIG, "jaeger-thrift");
        Configurator.setDefaultValue("otel.exporter.jaeger.endpoint", "http://localhost:9080/v1/trace");
        Configurator.setDefaultValue("otel.exporter.jaeger.service.name", "OtelInstrumentedLambda");
        Configurator.setDefaultValue("otel.java.disabled.resource_providers", DISABLED_RESOURCE_PROVIDERS);
    }

    static void setDefaultValue(String name, String value) {
        if (!Configurator.isConfigured(name)) {
            log.info("Setting default value. name={}, value={}", (Object)name, (Object)value);
            System.setProperty(name, value);
        }
    }

    private static boolean isConfigured(String name) {
        return System.getProperty(name) != null || System.getenv(Configurator.toEnvVarName(name)) != null;
    }

    private static String toEnvVarName(String propertyName) {
        return ENV_REPLACEMENT.matcher(propertyName.toUpperCase()).replaceAll("_");
    }
}

