/*
 * Decompiled with CFR 0.152.
 */
package com.splunk.support.lambda;

import com.splunk.support.lambda.AuthTokenInterceptor;
import com.splunk.support.lambda.Configurator;
import io.jaegertracing.thrift.internal.senders.HttpSender;
import io.jaegertracing.thrift.internal.senders.ThriftSender;
import io.opentelemetry.exporter.jaeger.JaegerGrpcSpanExporter;
import io.opentelemetry.exporter.jaeger.thrift.JaegerThriftSpanExporter;
import io.opentelemetry.exporter.logging.LoggingSpanExporter;
import io.opentelemetry.exporter.otlp.OtlpGrpcSpanExporter;
import io.opentelemetry.exporter.zipkin.ZipkinSpanExporter;
import io.opentelemetry.sdk.OpenTelemetrySdk;
import io.opentelemetry.sdk.trace.SpanProcessor;
import io.opentelemetry.sdk.trace.export.BatchSpanProcessor;
import io.opentelemetry.sdk.trace.export.SpanExporter;
import java.util.List;
import java.util.Properties;
import okhttp3.Interceptor;
import okhttp3.OkHttpClient;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExportersInitializer {
    private static final Logger log = LoggerFactory.getLogger(Configurator.class);

    static synchronized void initializeExporters(List<String> exporters, Properties config) {
        log.debug("Installing exporters: {}", exporters);
        for (String exporterName : exporters) {
            ExportersInitializer.installExporter(exporterName, config, ExportersInitializer.getSpanExporter(exporterName, config));
        }
    }

    private static SpanExporter getSpanExporter(String exporterName, Properties config) {
        switch (exporterName) {
            case "zipkin": {
                return ExportersInitializer.zipkinSpanExporter(config);
            }
            case "otlp": {
                return ExportersInitializer.otlpGrpcSpanExporter(config);
            }
            case "logging": {
                return ExportersInitializer.loggingSpanExporter(config);
            }
            case "jaeger": {
                return ExportersInitializer.jaegerGrpcSpanExporter(config);
            }
            case "jaeger-thrift": {
                return ExportersInitializer.jaegerThriftSpanExporter(config);
            }
        }
        return null;
    }

    private static void installExporter(String exporterName, Properties config, SpanExporter spanExporter) {
        if (spanExporter != null) {
            BatchSpanProcessor spanProcessor = ((BatchSpanProcessor.Builder)BatchSpanProcessor.builder((SpanExporter)spanExporter).readProperties(config)).build();
            OpenTelemetrySdk.getGlobalTracerManagement().addSpanProcessor((SpanProcessor)spanProcessor);
            log.debug("Installed span exporter: {}", (Object)exporterName);
        } else {
            log.warn("Exporter: {} not found", (Object)exporterName);
        }
    }

    private static SpanExporter jaegerGrpcSpanExporter(Properties config) {
        return ((JaegerGrpcSpanExporter.Builder)JaegerGrpcSpanExporter.builder().readProperties(config)).build();
    }

    private static SpanExporter jaegerThriftSpanExporter(Properties config) {
        JaegerThriftSpanExporter.Builder builder = (JaegerThriftSpanExporter.Builder)JaegerThriftSpanExporter.builder().readProperties(config);
        OkHttpClient client = new OkHttpClient.Builder().addInterceptor((Interceptor)new AuthTokenInterceptor()).build();
        HttpSender thriftSender = new HttpSender.Builder(config.getProperty("otel.exporter.jaeger.endpoint")).withClient(client).build();
        builder.setThriftSender((ThriftSender)thriftSender);
        return builder.build();
    }

    private static SpanExporter loggingSpanExporter(Properties config) {
        return new LoggingSpanExporter();
    }

    private static SpanExporter otlpGrpcSpanExporter(Properties config) {
        return ((OtlpGrpcSpanExporter.Builder)OtlpGrpcSpanExporter.builder().readProperties(config)).build();
    }

    private static SpanExporter zipkinSpanExporter(Properties config) {
        return ((ZipkinSpanExporter.Builder)ZipkinSpanExporter.builder().readProperties(config)).build();
    }
}

