/*
 * Decompiled with CFR 0.152.
 */
package com.splunk.support.lambda;

import io.opentelemetry.api.OpenTelemetry;
import io.opentelemetry.api.trace.TracerProvider;
import io.opentelemetry.api.trace.propagation.W3CTraceContextPropagator;
import io.opentelemetry.context.propagation.ContextPropagators;
import io.opentelemetry.context.propagation.TextMapPropagator;
import io.opentelemetry.extension.trace.propagation.AwsXRayPropagator;
import io.opentelemetry.extension.trace.propagation.B3Propagator;
import io.opentelemetry.extension.trace.propagation.JaegerPropagator;
import io.opentelemetry.extension.trace.propagation.OtTracerPropagator;
import io.opentelemetry.sdk.OpenTelemetrySdk;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class PropagatorsInitializer {
    private static final Logger log = LoggerFactory.getLogger(PropagatorsInitializer.class);
    private static final Map<String, TextMapPropagator> TEXTMAP_PROPAGATORS = new HashMap<String, TextMapPropagator>();

    PropagatorsInitializer() {
    }

    static void initializePropagators(List<String> propagators) {
        log.debug("Configuring propagators: {}", propagators);
        ArrayList<TextMapPropagator> textPropagators = new ArrayList<TextMapPropagator>(propagators.size());
        for (String propagatorId : propagators) {
            TextMapPropagator textPropagator = TEXTMAP_PROPAGATORS.get(propagatorId.trim().toLowerCase());
            if (textPropagator == null) continue;
            textPropagators.add(textPropagator);
        }
        ContextPropagators contextPropagators = ContextPropagators.noop();
        if (textPropagators.size() > 1) {
            contextPropagators = ContextPropagators.create((TextMapPropagator)TextMapPropagator.composite(textPropagators));
        } else if (textPropagators.size() == 1) {
            contextPropagators = ContextPropagators.create((TextMapPropagator)((TextMapPropagator)textPropagators.get(0)));
        }
        PropagatorsInitializer.setGlobalPropagators(contextPropagators);
    }

    public static void setGlobalPropagators(ContextPropagators propagators) {
        OpenTelemetry.set((OpenTelemetry)OpenTelemetrySdk.builder().setResource(OpenTelemetrySdk.get().getResource()).setClock(OpenTelemetrySdk.get().getClock()).setMeterProvider(OpenTelemetry.getGlobalMeterProvider()).setTracerProvider(PropagatorsInitializer.unobfuscate(OpenTelemetry.getGlobalTracerProvider())).setPropagators(propagators).build());
    }

    private static TracerProvider unobfuscate(TracerProvider tracerProvider) {
        if (tracerProvider.getClass().getName().endsWith("TracerSdkProvider")) {
            return tracerProvider;
        }
        try {
            Method unobfuscate = tracerProvider.getClass().getDeclaredMethod("unobfuscate", new Class[0]);
            unobfuscate.setAccessible(true);
            return (TracerProvider)unobfuscate.invoke((Object)tracerProvider, new Object[0]);
        }
        catch (Throwable t) {
            return tracerProvider;
        }
    }

    static {
        TEXTMAP_PROPAGATORS.put("tracecontext", W3CTraceContextPropagator.getInstance());
        TEXTMAP_PROPAGATORS.put("b3", (TextMapPropagator)B3Propagator.getInstance());
        TEXTMAP_PROPAGATORS.put("b3multi", (TextMapPropagator)B3Propagator.builder().injectMultipleHeaders().build());
        TEXTMAP_PROPAGATORS.put("jaeger", (TextMapPropagator)JaegerPropagator.getInstance());
        TEXTMAP_PROPAGATORS.put("ottracer", (TextMapPropagator)OtTracerPropagator.getInstance());
        TEXTMAP_PROPAGATORS.put("xray", (TextMapPropagator)AwsXRayPropagator.getInstance());
    }
}

