/*
 * Decompiled with CFR 0.152.
 */
package com.sinacloud.scs.retry;

import java.io.IOException;
import java.io.InterruptedIOException;
import java.net.NoRouteToHostException;
import java.net.SocketException;
import java.net.UnknownHostException;
import java.util.HashSet;
import javax.net.ssl.SSLHandshakeException;
import org.apache.http.NoHttpResponseException;
import org.apache.http.client.HttpRequestRetryHandler;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.protocol.HttpContext;

public class RetryHandler
implements HttpRequestRetryHandler {
    private static final int RETRY_SLEEP_TIME_MILLIS = 500;
    private static HashSet<Class<?>> exceptionWhitelist = new HashSet();
    private static HashSet<Class<?>> exceptionBlacklist = new HashSet();
    private final int maxRetries;

    public RetryHandler(int maxRetries) {
        this.maxRetries = maxRetries;
    }

    public boolean retryRequest(IOException exception, int executionCount, HttpContext context) {
        HttpUriRequest currentReq;
        String requestType;
        boolean sent;
        Boolean b = (Boolean)context.getAttribute("http.request_sent");
        boolean bl = sent = b != null && b != false;
        boolean retry = executionCount > this.maxRetries ? false : (exceptionBlacklist.contains(exception.getClass()) ? false : (exceptionWhitelist.contains(exception.getClass()) ? true : (!sent ? true : !(requestType = (currentReq = (HttpUriRequest)context.getAttribute("http.request")).getMethod()).equals("POST"))));
        if (retry) {
            try {
                Thread.sleep(500L);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        } else {
            exception.printStackTrace();
        }
        return retry;
    }

    static {
        exceptionWhitelist.add(NoHttpResponseException.class);
        exceptionWhitelist.add(UnknownHostException.class);
        exceptionWhitelist.add(SocketException.class);
        exceptionBlacklist.add(InterruptedIOException.class);
        exceptionBlacklist.add(SSLHandshakeException.class);
        exceptionBlacklist.add(NoRouteToHostException.class);
    }
}

