/*
 * Decompiled with CFR 0.152.
 */
package com.sinacloud.scs.services.scs;

import com.sinacloud.scs.ClientConfiguration;
import com.sinacloud.scs.DefaultRequest;
import com.sinacloud.scs.HttpMethod;
import com.sinacloud.scs.Request;
import com.sinacloud.scs.Response;
import com.sinacloud.scs.SCSClientException;
import com.sinacloud.scs.SCSServiceException;
import com.sinacloud.scs.SCSWebServiceClient;
import com.sinacloud.scs.SCSWebServiceRequest;
import com.sinacloud.scs.SCSWebServiceResponse;
import com.sinacloud.scs.auth.AWSCredentials;
import com.sinacloud.scs.auth.AWSCredentialsProvider;
import com.sinacloud.scs.auth.AWSCredentialsProviderChain;
import com.sinacloud.scs.auth.ClasspathPropertiesFileCredentialsProvider;
import com.sinacloud.scs.auth.DefaultAWSCredentialsProviderChain;
import com.sinacloud.scs.auth.Signer;
import com.sinacloud.scs.auth.SystemPropertiesCredentialsProvider;
import com.sinacloud.scs.event.ProgressEvent;
import com.sinacloud.scs.event.ProgressListener;
import com.sinacloud.scs.event.ProgressListenerCallbackExecutor;
import com.sinacloud.scs.event.ProgressReportingInputStream;
import com.sinacloud.scs.http.ExecutionContext;
import com.sinacloud.scs.http.HttpMethodName;
import com.sinacloud.scs.http.HttpResponseHandler;
import com.sinacloud.scs.internal.StaticCredentialsProvider;
import com.sinacloud.scs.services.scs.S3ClientOptions;
import com.sinacloud.scs.services.scs.SCS;
import com.sinacloud.scs.services.scs.internal.BucketNameUtils;
import com.sinacloud.scs.services.scs.internal.Constants;
import com.sinacloud.scs.services.scs.internal.InputSubstream;
import com.sinacloud.scs.services.scs.internal.MD5DigestCalculatingInputStream;
import com.sinacloud.scs.services.scs.internal.Mimetypes;
import com.sinacloud.scs.services.scs.internal.RepeatableFileInputStream;
import com.sinacloud.scs.services.scs.internal.ResponseHeaderHandlerChain;
import com.sinacloud.scs.services.scs.internal.S3ErrorResponseHandler;
import com.sinacloud.scs.services.scs.internal.S3JsonResponseHandler;
import com.sinacloud.scs.services.scs.internal.S3MetadataResponseHandler;
import com.sinacloud.scs.services.scs.internal.S3ObjectResponseHandler;
import com.sinacloud.scs.services.scs.internal.S3QueryStringSigner;
import com.sinacloud.scs.services.scs.internal.S3Signer;
import com.sinacloud.scs.services.scs.internal.ServerSideEncryptionHeaderHandler;
import com.sinacloud.scs.services.scs.internal.ServiceUtils;
import com.sinacloud.scs.services.scs.model.AccessControlList;
import com.sinacloud.scs.services.scs.model.Bucket;
import com.sinacloud.scs.services.scs.model.BucketInfo;
import com.sinacloud.scs.services.scs.model.CompleteMultipartUploadRequest;
import com.sinacloud.scs.services.scs.model.CopyObjectRequest;
import com.sinacloud.scs.services.scs.model.CreateBucketRequest;
import com.sinacloud.scs.services.scs.model.DeleteBucketRequest;
import com.sinacloud.scs.services.scs.model.DeleteObjectRequest;
import com.sinacloud.scs.services.scs.model.DigestValidationInputStream;
import com.sinacloud.scs.services.scs.model.GeneratePresignedUrlRequest;
import com.sinacloud.scs.services.scs.model.GenericBucketRequest;
import com.sinacloud.scs.services.scs.model.GetBucketAclRequest;
import com.sinacloud.scs.services.scs.model.GetObjectMetadataRequest;
import com.sinacloud.scs.services.scs.model.GetObjectRequest;
import com.sinacloud.scs.services.scs.model.InitiateMultipartUploadRequest;
import com.sinacloud.scs.services.scs.model.InitiateMultipartUploadResult;
import com.sinacloud.scs.services.scs.model.ListBucketsRequest;
import com.sinacloud.scs.services.scs.model.ListObjectsRequest;
import com.sinacloud.scs.services.scs.model.ListPartsRequest;
import com.sinacloud.scs.services.scs.model.ObjectInfo;
import com.sinacloud.scs.services.scs.model.ObjectListing;
import com.sinacloud.scs.services.scs.model.ObjectMetadata;
import com.sinacloud.scs.services.scs.model.PartListing;
import com.sinacloud.scs.services.scs.model.PutObjectRelaxRequest;
import com.sinacloud.scs.services.scs.model.PutObjectRequest;
import com.sinacloud.scs.services.scs.model.PutObjectResult;
import com.sinacloud.scs.services.scs.model.RepeatableInputStream;
import com.sinacloud.scs.services.scs.model.ResponseHeaderOverrides;
import com.sinacloud.scs.services.scs.model.S3Object;
import com.sinacloud.scs.services.scs.model.S3ObjectInputStream;
import com.sinacloud.scs.services.scs.model.SCSS3Exception;
import com.sinacloud.scs.services.scs.model.SetBucketAclRequest;
import com.sinacloud.scs.services.scs.model.UploadPartRequest;
import com.sinacloud.scs.services.scs.model.UploadPartResult;
import com.sinacloud.scs.services.scs.model.transform.AclJsonFactory;
import com.sinacloud.scs.services.scs.model.transform.RequestJsonFactory;
import com.sinacloud.scs.services.scs.model.transform.Unmarshallers;
import com.sinacloud.scs.transform.Unmarshaller;
import com.sinacloud.scs.util.BinaryUtils;
import com.sinacloud.scs.util.ContentLengthValidationInputStream;
import com.sinacloud.scs.util.DateUtils;
import com.sinacloud.scs.util.HttpUtils;
import com.sinacloud.scs.util.Md5Utils;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.http.client.utils.URIBuilder;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SCSClient
extends SCSWebServiceClient
implements SCS {
    private static Log log = LogFactory.getLog(SCSClient.class);
    private S3ErrorResponseHandler errorResponseHandler = new S3ErrorResponseHandler();
    private S3JsonResponseHandler<Void> voidResponseHandler = new S3JsonResponseHandler(null);
    private S3ClientOptions clientOptions = new S3ClientOptions();
    private AWSCredentialsProvider awsCredentialsProvider;

    public SCSClient() {
        this(new AWSCredentialsProviderChain(new AWSCredentialsProvider[]{new SystemPropertiesCredentialsProvider(), new ClasspathPropertiesFileCredentialsProvider()}){

            public AWSCredentials getCredentials() {
                try {
                    return super.getCredentials();
                }
                catch (SCSClientException sCSClientException) {
                    log.debug((Object)"No credentials available; falling back to anonymous access");
                    return null;
                }
            }
        });
    }

    public SCSClient(AWSCredentials awsCredentials) {
        this(awsCredentials, new ClientConfiguration());
    }

    public SCSClient(AWSCredentials awsCredentials, ClientConfiguration clientConfiguration) {
        super(clientConfiguration);
        this.awsCredentialsProvider = new StaticCredentialsProvider(awsCredentials);
        this.init();
    }

    public SCSClient(AWSCredentialsProvider credentialsProvider) {
        this(credentialsProvider, new ClientConfiguration());
    }

    public SCSClient(AWSCredentialsProvider credentialsProvider, ClientConfiguration clientConfiguration) {
        super(clientConfiguration);
        this.awsCredentialsProvider = credentialsProvider;
        this.init();
    }

    protected final ExecutionContext createExecutionContext(SCSWebServiceRequest req) {
        return new ExecutionContext();
    }

    public SCSClient(ClientConfiguration clientConfiguration) {
        this(new DefaultAWSCredentialsProviderChain(), clientConfiguration);
    }

    private void init() {
        this.setEndpoint(Constants.S3_HOSTNAME);
        this.setEndpoint4Upload(Constants.S3_UPLOAD_HOSTNAME);
    }

    @Override
    public void setS3ClientOptions(S3ClientOptions clientOptions) {
        this.clientOptions = new S3ClientOptions(clientOptions);
    }

    @Override
    public ObjectListing listObjects(String bucketName) throws SCSClientException, SCSServiceException {
        return this.listObjects(new ListObjectsRequest(bucketName, null, null, null, null));
    }

    @Override
    public ObjectListing listObjects(String bucketName, String prefix) throws SCSClientException, SCSServiceException {
        return this.listObjects(new ListObjectsRequest(bucketName, prefix, null, null, null));
    }

    @Override
    public ObjectListing listObjects(ListObjectsRequest listObjectsRequest) throws SCSClientException, SCSServiceException {
        this.assertParameterNotNull(listObjectsRequest.getBucketName(), "The bucket name parameter must be specified when listing objects in a bucket");
        Request<ListObjectsRequest> request = this.createRequest(listObjectsRequest.getBucketName(), null, listObjectsRequest, HttpMethodName.GET);
        if (listObjectsRequest.getPrefix() != null) {
            request.addParameter("prefix", listObjectsRequest.getPrefix());
        }
        if (listObjectsRequest.getMarker() != null) {
            request.addParameter("marker", listObjectsRequest.getMarker());
        }
        if (listObjectsRequest.getDelimiter() != null) {
            request.addParameter("delimiter", listObjectsRequest.getDelimiter());
        }
        if (listObjectsRequest.getMaxKeys() != null && listObjectsRequest.getMaxKeys() >= 0) {
            request.addParameter("max-keys", listObjectsRequest.getMaxKeys().toString());
        }
        ObjectListing objectListing = this.invoke(request, new Unmarshallers.ListObjectsUnmarshaller(), listObjectsRequest.getBucketName(), null);
        objectListing.setBucketName(listObjectsRequest.getBucketName());
        objectListing.setDelimiter(listObjectsRequest.getDelimiter());
        if (listObjectsRequest.getMaxKeys() != null && listObjectsRequest.getMaxKeys() >= 0) {
            objectListing.setMaxKeys(listObjectsRequest.getMaxKeys());
        }
        return objectListing;
    }

    @Override
    public ObjectListing listNextBatchOfObjects(ObjectListing previousObjectListing) throws SCSClientException, SCSServiceException {
        this.assertParameterNotNull(previousObjectListing, "The previous object listing parameter must be specified when listing the next batch of objects in a bucket");
        if (!previousObjectListing.isTruncated()) {
            ObjectListing emptyListing = new ObjectListing();
            emptyListing.setBucketName(previousObjectListing.getBucketName());
            emptyListing.setDelimiter(previousObjectListing.getDelimiter());
            emptyListing.setMarker(previousObjectListing.getNextMarker());
            emptyListing.setMaxKeys(previousObjectListing.getMaxKeys());
            emptyListing.setPrefix(previousObjectListing.getPrefix());
            emptyListing.setTruncated(false);
            return emptyListing;
        }
        return this.listObjects(new ListObjectsRequest(previousObjectListing.getBucketName(), previousObjectListing.getPrefix(), previousObjectListing.getNextMarker(), previousObjectListing.getDelimiter(), previousObjectListing.getMaxKeys()));
    }

    @Override
    public List<Bucket> listBuckets(ListBucketsRequest listBucketsRequest) throws SCSClientException, SCSServiceException {
        Request<ListBucketsRequest> request = this.createRequest(null, null, listBucketsRequest, HttpMethodName.GET);
        return this.invoke(request, new Unmarshallers.ListBucketsUnmarshaller(), null, null);
    }

    @Override
    public List<Bucket> listBuckets() throws SCSClientException, SCSServiceException {
        return this.listBuckets(new ListBucketsRequest());
    }

    @Override
    public Bucket createBucket(String bucketName) throws SCSClientException, SCSServiceException {
        return this.createBucket(new CreateBucketRequest(bucketName));
    }

    @Override
    public Bucket createBucket(CreateBucketRequest createBucketRequest) throws SCSClientException, SCSServiceException {
        this.assertParameterNotNull(createBucketRequest, "The CreateBucketRequest parameter must be specified when creating a bucket");
        String bucketName = createBucketRequest.getBucketName();
        this.assertParameterNotNull(bucketName, "The bucket name parameter must be specified when creating a bucket");
        if (bucketName != null) {
            bucketName = bucketName.trim();
        }
        BucketNameUtils.validateBucketName(bucketName);
        Request<CreateBucketRequest> request = this.createRequest(bucketName, null, createBucketRequest, HttpMethodName.PUT);
        if (createBucketRequest.getCannedAcl() != null) {
            request.addHeader("x-amz-acl", createBucketRequest.getCannedAcl().toString());
        }
        this.invoke(request, this.voidResponseHandler, bucketName, null);
        return new Bucket(bucketName);
    }

    @Override
    public AccessControlList getObjectAcl(String bucketName, String key) throws SCSClientException, SCSServiceException {
        GenericBucketRequest originalRequest = new GenericBucketRequest(bucketName);
        Request<GenericBucketRequest> request = this.createRequest(bucketName, key, originalRequest, HttpMethodName.GET);
        request.addParameter("acl", null);
        return this.invoke(request, new Unmarshallers.AccessControlListUnmarshaller(), bucketName, key);
    }

    @Override
    public void setObjectAcl(String bucketName, String key, AccessControlList acl) throws SCSClientException, SCSServiceException {
        this.assertParameterNotNull(bucketName, "The bucket name parameter must be specified when setting an object's ACL");
        this.assertParameterNotNull(key, "The key parameter must be specified when setting an object's ACL");
        this.assertParameterNotNull(acl, "The ACL parameter must be specified when setting an object's ACL");
        this.setAcl(bucketName, key, acl, new GenericBucketRequest(bucketName));
    }

    @Override
    public BucketInfo getBucketInfo(String bucketName) throws SCSClientException, SCSServiceException {
        this.assertParameterNotNull(bucketName, "The bucket name parameter must be specified when requesting an bucket's info");
        GenericBucketRequest originalRequest = new GenericBucketRequest(bucketName);
        Request<GenericBucketRequest> request = this.createRequest(bucketName, null, originalRequest, HttpMethodName.GET);
        request.addParameter("meta", null);
        return this.invoke(request, new Unmarshallers.BucketInfoUnmarshaller(), bucketName, null);
    }

    @Override
    public ObjectInfo getObjectInfo(String bucketName, String key) throws SCSClientException, SCSServiceException {
        this.assertParameterNotNull(bucketName, "The bucket name parameter must be specified when requesting an Object's info");
        this.assertParameterNotNull(key, "The bucket name parameter must be specified when requesting an Object's info");
        GenericBucketRequest originalRequest = new GenericBucketRequest(bucketName);
        Request<GenericBucketRequest> request = this.createRequest(bucketName, key, originalRequest, HttpMethodName.GET);
        request.addParameter("meta", null);
        return this.invoke(request, new Unmarshallers.ObjectInfoUnmarshaller(), bucketName, key);
    }

    @Override
    public AccessControlList getBucketAcl(String bucketName) throws SCSClientException, SCSServiceException {
        this.assertParameterNotNull(bucketName, "The bucket name parameter must be specified when requesting a bucket's ACL");
        return this.getAcl(bucketName, null, null, null);
    }

    @Override
    public AccessControlList getBucketAcl(GetBucketAclRequest getBucketAclRequest) throws SCSClientException, SCSServiceException {
        String bucketName = getBucketAclRequest.getBucketName();
        this.assertParameterNotNull(bucketName, "The bucket name parameter must be specified when requesting a bucket's ACL");
        return this.getAcl(bucketName, null, null, getBucketAclRequest);
    }

    @Override
    public void setBucketAcl(String bucketName, AccessControlList acl) throws SCSClientException, SCSServiceException {
        this.assertParameterNotNull(bucketName, "The bucket name parameter must be specified when setting a bucket's ACL");
        this.assertParameterNotNull(acl, "The ACL parameter must be specified when setting a bucket's ACL");
        this.setAcl(bucketName, null, acl, new GenericBucketRequest(bucketName));
    }

    @Override
    public void setBucketAcl(SetBucketAclRequest setBucketAclRequest) throws SCSClientException, SCSServiceException {
        String bucketName = setBucketAclRequest.getBucketName();
        AccessControlList acl = setBucketAclRequest.getAcl();
        this.assertParameterNotNull(bucketName, "The bucket name parameter must be specified when setting a bucket's ACL");
        if (acl != null) {
            this.setAcl(bucketName, null, acl, setBucketAclRequest);
        } else {
            this.assertParameterNotNull(null, "The ACL parameter must be specified when setting a bucket's ACL");
        }
    }

    @Override
    public ObjectMetadata getObjectMetadata(String bucketName, String key) throws SCSClientException, SCSServiceException {
        return this.getObjectMetadata(new GetObjectMetadataRequest(bucketName, key));
    }

    @Override
    public void setObjectMetadata(String bucketName, String key, ObjectMetadata objectMetadata) throws SCSClientException, SCSServiceException {
        GenericBucketRequest originalRequest = new GenericBucketRequest(bucketName);
        Request<GenericBucketRequest> request = this.createRequest(bucketName, key, originalRequest, HttpMethodName.PUT);
        request.addParameter("meta", null);
        for (Map.Entry<String, String> entry : objectMetadata.getUserMetadata().entrySet()) {
            String metaKey = entry.getKey();
            String metaValue = entry.getValue();
            if (!metaKey.startsWith("x-amz-meta-")) {
                metaKey = "x-amz-meta-" + metaKey;
            }
            request.addHeader(metaKey, metaValue);
        }
        this.invoke(request, this.voidResponseHandler, bucketName, key);
    }

    @Override
    public ObjectMetadata getObjectMetadata(GetObjectMetadataRequest getObjectMetadataRequest) throws SCSClientException, SCSServiceException {
        this.assertParameterNotNull(getObjectMetadataRequest, "The GetObjectMetadataRequest parameter must be specified when requesting an object's metadata");
        String bucketName = getObjectMetadataRequest.getBucketName();
        String key = getObjectMetadataRequest.getKey();
        String versionId = getObjectMetadataRequest.getVersionId();
        this.assertParameterNotNull(bucketName, "The bucket name parameter must be specified when requesting an object's metadata");
        this.assertParameterNotNull(key, "The key parameter must be specified when requesting an object's metadata");
        Request<GetObjectMetadataRequest> request = this.createRequest(bucketName, key, getObjectMetadataRequest, HttpMethodName.HEAD);
        if (versionId != null) {
            request.addParameter("versionId", versionId);
        }
        return this.invoke(request, new S3MetadataResponseHandler(), bucketName, key);
    }

    @Override
    public S3Object getObject(String bucketName, String key) throws SCSClientException, SCSServiceException {
        return this.getObject(new GetObjectRequest(bucketName, key));
    }

    @Override
    public boolean doesBucketExist(String bucketName) throws SCSClientException, SCSServiceException {
        try {
            this.listObjects(new ListObjectsRequest(bucketName, null, null, null, 1));
            return true;
        }
        catch (SCSServiceException ase) {
            if (this.awsCredentialsProvider.getCredentials() == null) {
                throw ase;
            }
            if ("InvalidAccessKeyId".equalsIgnoreCase(ase.getErrorCode()) || "SignatureDoesNotMatch".equalsIgnoreCase(ase.getErrorCode())) {
                throw ase;
            }
            switch (ase.getStatusCode()) {
                case 301: {
                    return true;
                }
                case 403: {
                    return true;
                }
                case 404: {
                    return false;
                }
            }
            throw ase;
        }
    }

    @Override
    public S3Object getObject(GetObjectRequest getObjectRequest) throws SCSClientException, SCSServiceException {
        this.assertParameterNotNull(getObjectRequest, "The GetObjectRequest parameter must be specified when requesting an object");
        this.assertParameterNotNull(getObjectRequest.getBucketName(), "The bucket name parameter must be specified when requesting an object");
        this.assertParameterNotNull(getObjectRequest.getKey(), "The key parameter must be specified when requesting an object");
        Request<GetObjectRequest> request = this.createRequest(getObjectRequest.getBucketName(), getObjectRequest.getKey(), getObjectRequest, HttpMethodName.GET);
        if (getObjectRequest.getVersionId() != null) {
            request.addParameter("versionId", getObjectRequest.getVersionId());
        }
        if (getObjectRequest.getRange() != null) {
            long[] range = getObjectRequest.getRange();
            request.addHeader("Range", "bytes=" + Long.toString(range[0]) + "-" + Long.toString(range[1]));
        }
        SCSClient.addResponseHeaderParameters(request, getObjectRequest.getResponseHeaders());
        SCSClient.addDateHeader(request, "If-Modified-Since", getObjectRequest.getModifiedSinceConstraint());
        SCSClient.addDateHeader(request, "If-Unmodified-Since", getObjectRequest.getUnmodifiedSinceConstraint());
        SCSClient.addStringListHeader(request, "If-Match", getObjectRequest.getMatchingETagConstraints());
        SCSClient.addStringListHeader(request, "If-None-Match", getObjectRequest.getNonmatchingETagConstraints());
        ProgressListener progressListener = getObjectRequest.getGeneralProgressListener();
        ProgressListenerCallbackExecutor progressListenerCallbackExecutor = ProgressListenerCallbackExecutor.wrapListener(progressListener);
        try {
            S3Object s3Object = this.invoke(request, new S3ObjectResponseHandler(), getObjectRequest.getBucketName(), getObjectRequest.getKey());
            s3Object.setBucketName(getObjectRequest.getBucketName());
            s3Object.setKey(getObjectRequest.getKey());
            S3ObjectInputStream input = s3Object.getObjectContent();
            if (progressListenerCallbackExecutor != null) {
                ProgressReportingInputStream progressReportingInputStream = new ProgressReportingInputStream(input, progressListenerCallbackExecutor);
                progressReportingInputStream.setFireCompletedEvent(true);
                input = new S3ObjectInputStream(progressReportingInputStream, input.getHttpRequest());
                this.fireProgressEvent(progressListenerCallbackExecutor, 2);
            }
            if (getObjectRequest.getRange() == null && System.getProperty("com.amazonaws.services.s3.disableGetObjectMD5Validation") == null) {
                byte[] serverSideHash = null;
                String etag = s3Object.getObjectMetadata().getETag();
                if (etag != null && !ServiceUtils.isMultipartUploadETag(etag)) {
                    serverSideHash = BinaryUtils.fromHex(s3Object.getObjectMetadata().getETag());
                    try {
                        MessageDigest digest = MessageDigest.getInstance("MD5");
                        DigestValidationInputStream inputStreamWithMD5DigestValidation = new DigestValidationInputStream(input, digest, serverSideHash);
                        input = new S3ObjectInputStream(inputStreamWithMD5DigestValidation, input.getHttpRequest());
                    }
                    catch (NoSuchAlgorithmException e) {
                        log.warn((Object)"No MD5 digest algorithm available.  Unable to calculate checksum and verify data integrity.", (Throwable)e);
                    }
                }
            } else {
                input = new S3ObjectInputStream(new ContentLengthValidationInputStream(input, s3Object.getObjectMetadata().getContentLength()), input.getHttpRequest());
            }
            s3Object.setObjectContent(input);
            return s3Object;
        }
        catch (SCSS3Exception ase) {
            if (ase.getStatusCode() == 412 || ase.getStatusCode() == 304) {
                this.fireProgressEvent(progressListenerCallbackExecutor, 16);
                return null;
            }
            this.fireProgressEvent(progressListenerCallbackExecutor, 8);
            throw ase;
        }
    }

    @Override
    public ObjectMetadata getObject(final GetObjectRequest getObjectRequest, File destinationFile) throws SCSClientException, SCSServiceException {
        this.assertParameterNotNull(destinationFile, "The destination file parameter must be specified when downloading an object directly to a file");
        S3Object s3Object = ServiceUtils.retryableDownloadS3ObjectToFile(destinationFile, new ServiceUtils.RetryableS3DownloadTask(){

            public S3Object getS3ObjectStream() {
                return SCSClient.this.getObject(getObjectRequest);
            }

            public boolean needIntegrityCheck() {
                return getObjectRequest.getRange() == null;
            }
        });
        if (s3Object == null) {
            return null;
        }
        return s3Object.getObjectMetadata();
    }

    @Override
    public void deleteBucket(String bucketName) throws SCSClientException, SCSServiceException {
        this.deleteBucket(new DeleteBucketRequest(bucketName));
    }

    @Override
    public void deleteBucket(DeleteBucketRequest deleteBucketRequest) throws SCSClientException, SCSServiceException {
        this.assertParameterNotNull(deleteBucketRequest, "The DeleteBucketRequest parameter must be specified when deleting a bucket");
        String bucketName = deleteBucketRequest.getBucketName();
        this.assertParameterNotNull(bucketName, "The bucket name parameter must be specified when deleting a bucket");
        Request<DeleteBucketRequest> request = this.createRequest(bucketName, null, deleteBucketRequest, HttpMethodName.DELETE);
        this.invoke(request, this.voidResponseHandler, bucketName, null);
    }

    @Override
    public PutObjectResult putObject(String bucketName, String key, File file) throws SCSClientException, SCSServiceException {
        return this.putObject(new PutObjectRequest(bucketName, key, file).withMetadata(new ObjectMetadata()));
    }

    @Override
    public PutObjectResult putObject(String bucketName, String key, File file, Map<String, String> requestHeader) throws SCSClientException, SCSServiceException {
        ObjectMetadata objectMetadata = new ObjectMetadata();
        objectMetadata.setUserHeader(requestHeader);
        return this.putObject(new PutObjectRequest(bucketName, key, file).withMetadata(objectMetadata));
    }

    @Override
    public PutObjectResult putObjectRelax(String bucketName, String key, String fileSha1, long fileLength) {
        return this.putObjectRelax(new PutObjectRelaxRequest(bucketName, key, fileSha1, fileLength));
    }

    @Override
    public PutObjectResult putObject(String bucketName, String key, InputStream input, ObjectMetadata metadata) throws SCSClientException, SCSServiceException {
        return this.putObject(new PutObjectRequest(bucketName, key, input, metadata));
    }

    private PutObjectResult putObjectRelax(PutObjectRelaxRequest putObjectRelaxRequest) {
        this.assertParameterNotNull(putObjectRelaxRequest, "The putObjectRelaxRequest parameter must be specified when uploading with relax");
        String bucketName = putObjectRelaxRequest.getBucketName();
        String key = putObjectRelaxRequest.getKey();
        String fileSha1 = putObjectRelaxRequest.getFileSha1();
        long fileLength = putObjectRelaxRequest.getFileLength();
        ObjectMetadata metadata = putObjectRelaxRequest.getMetadata();
        if (metadata == null) {
            metadata = new ObjectMetadata();
        }
        this.assertParameterNotNull(bucketName, "The bucket name parameter must be specified when uploading an object");
        this.assertParameterNotNull(key, "The key parameter must be specified when uploading an object");
        if (putObjectRelaxRequest.getFileSha1() != null) {
            metadata.setContentLength(0L);
            if (metadata.getContentType() == null) {
                metadata.setContentType(Mimetypes.getInstance().getMimetype(key));
            }
            metadata.setHeader("s-sina-sha1", fileSha1);
            metadata.setHeader("s-sina-length", fileLength);
        }
        Request<PutObjectRelaxRequest> request = this.createRequest(bucketName, key, putObjectRelaxRequest, HttpMethodName.PUT);
        request.addParameter("relax", null);
        if (putObjectRelaxRequest.getCannedAcl() != null) {
            request.addHeader("x-amz-acl", putObjectRelaxRequest.getCannedAcl().toString());
        }
        if (metadata.getContentType() == null) {
            metadata.setContentType("application/octet-stream");
        }
        SCSClient.populateRequestMetadata(request, metadata);
        ObjectMetadata returnedMetadata = null;
        returnedMetadata = this.invoke(request, new S3MetadataResponseHandler(), bucketName, key);
        PutObjectResult result = new PutObjectResult();
        result.setETag(returnedMetadata.getETag());
        result.setVersionId(returnedMetadata.getVersionId());
        result.setServerSideEncryption(returnedMetadata.getServerSideEncryption());
        result.setExpirationTime(returnedMetadata.getExpirationTime());
        result.setExpirationTimeRuleId(returnedMetadata.getExpirationTimeRuleId());
        return result;
    }

    @Override
    public PutObjectResult putObject(PutObjectRequest putObjectRequest) throws SCSClientException, SCSServiceException {
        byte[] serverSideHash;
        byte[] clientSideHash;
        this.assertParameterNotNull(putObjectRequest, "The PutObjectRequest parameter must be specified when uploading an object");
        String bucketName = putObjectRequest.getBucketName();
        String key = putObjectRequest.getKey();
        ObjectMetadata metadata = putObjectRequest.getMetadata();
        InputStream input = putObjectRequest.getInputStream();
        ProgressListener progressListener = putObjectRequest.getGeneralProgressListener();
        ProgressListenerCallbackExecutor progressListenerCallbackExecutor = ProgressListenerCallbackExecutor.wrapListener(progressListener);
        if (metadata == null) {
            metadata = new ObjectMetadata();
        }
        this.assertParameterNotNull(bucketName, "The bucket name parameter must be specified when uploading an object");
        this.assertParameterNotNull(key, "The key parameter must be specified when uploading an object");
        if (putObjectRequest.getFile() != null) {
            File file = putObjectRequest.getFile();
            metadata.setContentLength(file.length());
            if (metadata.getContentType() == null) {
                metadata.setContentType(Mimetypes.getInstance().getMimetype(file));
            }
            FileInputStream fileInputStream = null;
            try {
                fileInputStream = new FileInputStream(file);
                byte[] md5Hash = Md5Utils.computeMD5Hash(fileInputStream);
                metadata.setContentMD5(BinaryUtils.toBase64(md5Hash));
            }
            catch (Exception e) {
                throw new SCSClientException("Unable to calculate MD5 hash: " + e.getMessage(), e);
            }
            finally {
                try {
                    fileInputStream.close();
                }
                catch (Exception exception) {}
            }
            try {
                input = new RepeatableFileInputStream(file);
            }
            catch (FileNotFoundException fnfe) {
                throw new SCSClientException("Unable to find file to upload", fnfe);
            }
        }
        Request<PutObjectRequest> request = this.createRequest(bucketName, key, putObjectRequest, HttpMethodName.PUT);
        if (putObjectRequest.getAccessControlList() != null) {
            SCSClient.addAclHeaders(request, putObjectRequest.getAccessControlList());
        } else if (putObjectRequest.getCannedAcl() != null) {
            request.addHeader("x-amz-acl", putObjectRequest.getCannedAcl().toString());
        }
        if (metadata.getRawMetadata().get("Content-Length") == null) {
            log.warn((Object)"No content length specified for stream data.  Stream contents will be buffered in memory and could result in out of memory errors.");
        }
        if (progressListenerCallbackExecutor != null) {
            input = new ProgressReportingInputStream(input, progressListenerCallbackExecutor);
            this.fireProgressEvent(progressListenerCallbackExecutor, 2);
        }
        if (!input.markSupported()) {
            int streamBufferSize = 131072;
            String bufferSizeOverride = System.getProperty("com.amazonaws.sdk.s3.defaultStreamBufferSize");
            if (bufferSizeOverride != null) {
                try {
                    streamBufferSize = Integer.parseInt(bufferSizeOverride);
                }
                catch (Exception e) {
                    log.warn((Object)("Unable to parse buffer size override from value: " + bufferSizeOverride));
                }
            }
            input = new RepeatableInputStream(input, streamBufferSize);
        }
        MD5DigestCalculatingInputStream md5DigestStream = null;
        if (metadata.getContentMD5() == null) {
            try {
                md5DigestStream = new MD5DigestCalculatingInputStream(input);
                input = md5DigestStream;
            }
            catch (NoSuchAlgorithmException e) {
                log.warn((Object)"No MD5 digest algorithm available.  Unable to calculate checksum and verify data integrity.", (Throwable)e);
            }
        }
        if (metadata.getContentType() == null) {
            metadata.setContentType("application/octet-stream");
        }
        SCSClient.populateRequestMetadata(request, metadata);
        request.setContent(input);
        ObjectMetadata returnedMetadata = null;
        try {
            returnedMetadata = this.invoke(request, new S3MetadataResponseHandler(), bucketName, key);
        }
        catch (SCSClientException ace) {
            this.fireProgressEvent(progressListenerCallbackExecutor, 8);
            throw ace;
        }
        finally {
            try {
                input.close();
            }
            catch (Exception e) {
                log.warn((Object)("Unable to cleanly close input stream: " + e.getMessage()), (Throwable)e);
            }
        }
        String contentMd5 = metadata.getContentMD5();
        if (md5DigestStream != null) {
            contentMd5 = BinaryUtils.toBase64(md5DigestStream.getMd5Digest());
        }
        if (returnedMetadata != null && contentMd5 != null && returnedMetadata.getETag() != null && !Arrays.equals(clientSideHash = BinaryUtils.fromBase64(contentMd5), serverSideHash = BinaryUtils.fromHex(returnedMetadata.getETag()))) {
            this.fireProgressEvent(progressListenerCallbackExecutor, 8);
            throw new SCSClientException("Unable to verify integrity of data upload.  Client calculated content hash didn't match hash calculated by Amazon S3.  You may need to delete the data stored in Amazon S3.");
        }
        this.fireProgressEvent(progressListenerCallbackExecutor, 4);
        PutObjectResult result = new PutObjectResult();
        result.setETag(returnedMetadata.getETag());
        result.setVersionId(returnedMetadata.getVersionId());
        result.setServerSideEncryption(returnedMetadata.getServerSideEncryption());
        result.setExpirationTime(returnedMetadata.getExpirationTime());
        result.setExpirationTimeRuleId(returnedMetadata.getExpirationTimeRuleId());
        result.setContentMd5(contentMd5);
        result.setServiceSideKey(returnedMetadata.getServersideKey());
        return result;
    }

    private static void addAclHeaders(Request<? extends SCSWebServiceRequest> request, AccessControlList acl) {
    }

    @Override
    public void copyObject(String sourceBucketName, String sourceKey, String destinationBucketName, String destinationKey) throws SCSClientException, SCSServiceException {
        this.copyObject(new CopyObjectRequest(sourceBucketName, sourceKey, destinationBucketName, destinationKey));
    }

    @Override
    public void copyObject(CopyObjectRequest copyObjectRequest) throws SCSClientException, SCSServiceException {
        this.assertParameterNotNull(copyObjectRequest.getSourceBucketName(), "The source bucket name must be specified when copying an object");
        this.assertParameterNotNull(copyObjectRequest.getSourceKey(), "The source object key must be specified when copying an object");
        this.assertParameterNotNull(copyObjectRequest.getDestinationBucketName(), "The destination bucket name must be specified when copying an object");
        this.assertParameterNotNull(copyObjectRequest.getDestinationKey(), "The destination object key must be specified when copying an object");
        String destinationKey = copyObjectRequest.getDestinationKey();
        String destinationBucketName = copyObjectRequest.getDestinationBucketName();
        Request<CopyObjectRequest> request = this.createRequest(destinationBucketName, destinationKey, copyObjectRequest, HttpMethodName.PUT);
        SCSClient.populateRequestWithCopyObjectParameters(request, copyObjectRequest);
        request.getHeaders().remove("Content-Length");
        this.invoke(request, this.voidResponseHandler, destinationBucketName, destinationKey);
    }

    @Override
    public void deleteObject(String bucketName, String key) throws SCSClientException, SCSServiceException {
        this.deleteObject(new DeleteObjectRequest(bucketName, key));
    }

    @Override
    public void deleteObject(DeleteObjectRequest deleteObjectRequest) throws SCSClientException, SCSServiceException {
        this.assertParameterNotNull(deleteObjectRequest, "The delete object request must be specified when deleting an object");
        this.assertParameterNotNull(deleteObjectRequest.getBucketName(), "The bucket name must be specified when deleting an object");
        this.assertParameterNotNull(deleteObjectRequest.getKey(), "The key must be specified when deleting an object");
        Request<DeleteObjectRequest> request = this.createRequest(deleteObjectRequest.getBucketName(), deleteObjectRequest.getKey(), deleteObjectRequest, HttpMethodName.DELETE);
        this.invoke(request, this.voidResponseHandler, deleteObjectRequest.getBucketName(), deleteObjectRequest.getKey());
    }

    @Override
    public URL generatePresignedUrl(String bucketName, String key, Date expiration, boolean bucketNameAsDomain) throws SCSClientException {
        return this.generatePresignedUrl(bucketName, key, expiration, HttpMethod.GET, bucketNameAsDomain);
    }

    @Override
    public URL generatePresignedUrl(String bucketName, String key, Date expiration, HttpMethod method, boolean bucketNameAsDomain) throws SCSClientException {
        GeneratePresignedUrlRequest request = new GeneratePresignedUrlRequest(bucketName, key, method);
        request.setExpiration(expiration);
        request.setBucketNameAsDomain(bucketNameAsDomain);
        return this.generatePresignedUrl(request);
    }

    @Override
    public URL generatePresignedUrl(GeneratePresignedUrlRequest generatePresignedUrlRequest) throws SCSClientException {
        this.assertParameterNotNull(generatePresignedUrlRequest, "The request parameter must be specified when generating a pre-signed URL");
        String bucketName = generatePresignedUrlRequest.getBucketName();
        String key = generatePresignedUrlRequest.getKey();
        this.assertParameterNotNull((Object)generatePresignedUrlRequest.getMethod(), "The HTTP method request parameter must be specified when generating a pre-signed URL");
        if (generatePresignedUrlRequest.getExpiration() == null) {
            generatePresignedUrlRequest.setExpiration(new Date(System.currentTimeMillis() + 900000L));
        }
        HttpMethodName httpMethod = HttpMethodName.valueOf(generatePresignedUrlRequest.getMethod().toString());
        Request<GeneratePresignedUrlRequest> request = this.createRequest(bucketName, key, generatePresignedUrlRequest, httpMethod);
        for (Map.Entry<String, String> entry : generatePresignedUrlRequest.getRequestParameters().entrySet()) {
            request.addParameter(entry.getKey(), entry.getValue());
        }
        if (generatePresignedUrlRequest.getContentType() != null) {
            request.addHeader("Content-Type", generatePresignedUrlRequest.getContentType());
        }
        SCSClient.addResponseHeaderParameters(request, generatePresignedUrlRequest.getResponseHeaders());
        this.presignRequest(request, generatePresignedUrlRequest.getMethod(), bucketName, key, generatePresignedUrlRequest.getExpiration(), null);
        return ServiceUtils.convertRequestToUrl(request, true);
    }

    @Override
    public ObjectMetadata completeMultipartUpload(CompleteMultipartUploadRequest completeMultipartUploadRequest) throws SCSClientException, SCSServiceException {
        this.assertParameterNotNull(completeMultipartUploadRequest, "The request parameter must be specified when completing a multipart upload");
        String bucketName = completeMultipartUploadRequest.getBucketName();
        String key = completeMultipartUploadRequest.getKey();
        String uploadId = completeMultipartUploadRequest.getUploadId();
        this.assertParameterNotNull(bucketName, "The bucket name parameter must be specified when completing a multipart upload");
        this.assertParameterNotNull(key, "The key parameter must be specified when completing a multipart upload");
        this.assertParameterNotNull(uploadId, "The upload ID parameter must be specified when completing a multipart upload");
        this.assertParameterNotNull(completeMultipartUploadRequest.getPartETags(), "The part ETags parameter must be specified when completing a multipart upload");
        Request<CompleteMultipartUploadRequest> request = this.createRequest(bucketName, key, completeMultipartUploadRequest, HttpMethodName.POST);
        request.addParameter("uploadId", uploadId);
        byte[] json = RequestJsonFactory.convertToJsonByteArray(completeMultipartUploadRequest.getPartETags());
        request.addHeader("Content-Type", "text/plain");
        request.addHeader("Content-Length", String.valueOf(json.length));
        request.setContent(new ByteArrayInputStream(json));
        ObjectMetadata returnedMetadata = this.invoke(request, new S3MetadataResponseHandler(), bucketName, key);
        return returnedMetadata;
    }

    @Override
    public InitiateMultipartUploadResult initiateMultipartUpload(String bucketName, String key) throws SCSClientException, SCSServiceException {
        return this.initiateMultipartUpload(new InitiateMultipartUploadRequest(bucketName, key));
    }

    @Override
    public InitiateMultipartUploadResult initiateMultipartUpload(InitiateMultipartUploadRequest initiateMultipartUploadRequest) throws SCSClientException, SCSServiceException {
        this.assertParameterNotNull(initiateMultipartUploadRequest, "The request parameter must be specified when initiating a multipart upload");
        this.assertParameterNotNull(initiateMultipartUploadRequest.getBucketName(), "The bucket name parameter must be specified when initiating a multipart upload");
        this.assertParameterNotNull(initiateMultipartUploadRequest.getKey(), "The key parameter must be specified when initiating a multipart upload");
        Request<InitiateMultipartUploadRequest> request = this.createRequest(initiateMultipartUploadRequest.getBucketName(), initiateMultipartUploadRequest.getKey(), initiateMultipartUploadRequest, HttpMethodName.POST);
        request.addParameter("multipart", null);
        if (initiateMultipartUploadRequest.getCannedACL() != null) {
            request.addHeader("x-amz-acl", initiateMultipartUploadRequest.getCannedACL().toString());
        }
        if (initiateMultipartUploadRequest.objectMetadata != null) {
            SCSClient.populateRequestMetadata(request, initiateMultipartUploadRequest.objectMetadata);
        }
        request.getHeaders().remove("Content-Length");
        request.addHeader("Content-Length", "0");
        request.setContent(new ByteArrayInputStream(new byte[0]));
        request.addHeader("Content-Type", "application/octet-stream");
        ResponseHeaderHandlerChain<InitiateMultipartUploadResult> responseHandler = new ResponseHeaderHandlerChain<InitiateMultipartUploadResult>(new Unmarshallers.InitiateMultipartUploadResultUnmarshaller(), new ServerSideEncryptionHeaderHandler());
        return (InitiateMultipartUploadResult)this.invoke(request, responseHandler, initiateMultipartUploadRequest.getBucketName(), initiateMultipartUploadRequest.getKey());
    }

    @Override
    public PartListing listParts(ListPartsRequest listPartsRequest) throws SCSClientException, SCSServiceException {
        this.assertParameterNotNull(listPartsRequest, "The request parameter must be specified when listing parts");
        this.assertParameterNotNull(listPartsRequest.getBucketName(), "The bucket name parameter must be specified when listing parts");
        this.assertParameterNotNull(listPartsRequest.getKey(), "The key parameter must be specified when listing parts");
        this.assertParameterNotNull(listPartsRequest.getUploadId(), "The upload ID parameter must be specified when listing parts");
        Request<ListPartsRequest> request = this.createRequest(listPartsRequest.getBucketName(), listPartsRequest.getKey(), listPartsRequest, HttpMethodName.GET);
        request.addParameter("uploadId", listPartsRequest.getUploadId());
        if (listPartsRequest.getMaxParts() != null) {
            request.addParameter("max-parts", listPartsRequest.getMaxParts().toString());
        }
        if (listPartsRequest.getPartNumberMarker() != null) {
            request.addParameter("part-number-marker", listPartsRequest.getPartNumberMarker().toString());
        }
        return this.invoke(request, new Unmarshallers.ListPartsResultUnmarshaller(), listPartsRequest.getBucketName(), listPartsRequest.getKey());
    }

    @Override
    public UploadPartResult uploadPart(UploadPartRequest uploadPartRequest) throws SCSClientException, SCSServiceException {
        ProgressListener progressListener;
        ProgressListenerCallbackExecutor progressListenerCallbackExecutor;
        this.assertParameterNotNull(uploadPartRequest, "The request parameter must be specified when uploading a part");
        String bucketName = uploadPartRequest.getBucketName();
        String key = uploadPartRequest.getKey();
        String uploadId = uploadPartRequest.getUploadId();
        int partNumber = uploadPartRequest.getPartNumber();
        long partSize = uploadPartRequest.getPartSize();
        this.assertParameterNotNull(bucketName, "The bucket name parameter must be specified when uploading a part");
        this.assertParameterNotNull(key, "The key parameter must be specified when uploading a part");
        this.assertParameterNotNull(uploadId, "The upload ID parameter must be specified when uploading a part");
        this.assertParameterNotNull(partNumber, "The part number parameter must be specified when uploading a part");
        this.assertParameterNotNull(partSize, "The part size parameter must be specified when uploading a part");
        Request<UploadPartRequest> request = this.createRequest(bucketName, key, uploadPartRequest, HttpMethodName.PUT);
        request.addParameter("uploadId", uploadId);
        request.addParameter("partNumber", Integer.toString(partNumber));
        if (uploadPartRequest.getMd5Digest() != null) {
            request.addHeader("Content-MD5", uploadPartRequest.getMd5Digest());
        }
        request.addHeader("Content-Length", Long.toString(partSize));
        InputStream inputStream = null;
        if (uploadPartRequest.getInputStream() != null) {
            inputStream = uploadPartRequest.getInputStream();
        } else if (uploadPartRequest.getFile() != null) {
            try {
                inputStream = new InputSubstream(new RepeatableFileInputStream(uploadPartRequest.getFile()), uploadPartRequest.getFileOffset(), partSize, true);
            }
            catch (FileNotFoundException e) {
                throw new IllegalArgumentException("The specified file doesn't exist", e);
            }
        } else {
            throw new IllegalArgumentException("A File or InputStream must be specified when uploading part");
        }
        MD5DigestCalculatingInputStream md5DigestStream = null;
        if (uploadPartRequest.getMd5Digest() == null) {
            try {
                md5DigestStream = new MD5DigestCalculatingInputStream(inputStream);
                inputStream = md5DigestStream;
            }
            catch (NoSuchAlgorithmException e) {
                log.warn((Object)"No MD5 digest algorithm available.  Unable to calculate checksum and verify data integrity.", (Throwable)e);
            }
        }
        if ((progressListenerCallbackExecutor = ProgressListenerCallbackExecutor.wrapListener(progressListener = uploadPartRequest.getGeneralProgressListener())) != null) {
            inputStream = new ProgressReportingInputStream(inputStream, progressListenerCallbackExecutor);
            this.fireProgressEvent(progressListenerCallbackExecutor, 1024);
        }
        try {
            byte[] serverSideHash;
            String contentMd5;
            byte[] clientSideHash;
            request.setContent(inputStream);
            ObjectMetadata metadata = this.invoke(request, new S3MetadataResponseHandler(), bucketName, key);
            if (metadata != null && md5DigestStream != null && metadata.getETag() != null && !Arrays.equals(clientSideHash = BinaryUtils.fromBase64(contentMd5 = BinaryUtils.toBase64(md5DigestStream.getMd5Digest())), serverSideHash = BinaryUtils.fromHex(metadata.getETag()))) {
                throw new SCSClientException("Unable to verify integrity of data upload.  Client calculated content hash didn't match hash calculated by Amazon S3.  You may need to delete the data stored in Amazon S3.");
            }
            this.fireProgressEvent(progressListenerCallbackExecutor, 2048);
            UploadPartResult result = new UploadPartResult();
            result.setETag(metadata.getETag());
            result.setPartNumber(partNumber);
            result.setServerSideEncryption(metadata.getServerSideEncryption());
            UploadPartResult uploadPartResult = result;
            return uploadPartResult;
        }
        catch (SCSClientException ace) {
            this.fireProgressEvent(progressListenerCallbackExecutor, 4096);
            this.fireProgressEvent(progressListenerCallbackExecutor, 2048);
            throw ace;
        }
        finally {
            if (inputStream != null) {
                try {
                    inputStream.close();
                }
                catch (Exception exception) {}
            }
        }
    }

    private void assertParameterNotNull(Object parameterValue, String errorMessage) {
        if (parameterValue == null) {
            throw new IllegalArgumentException(errorMessage);
        }
    }

    private void fireProgressEvent(ProgressListenerCallbackExecutor progressListenerCallbackExecutor, int eventType) {
        if (progressListenerCallbackExecutor == null) {
            return;
        }
        ProgressEvent event = new ProgressEvent(0L);
        event.setEventCode(eventType);
        progressListenerCallbackExecutor.progressChanged(event);
    }

    private AccessControlList getAcl(String bucketName, String key, String versionId, SCSWebServiceRequest originalRequest) {
        if (originalRequest == null) {
            originalRequest = new GenericBucketRequest(bucketName);
        }
        Request<SCSWebServiceRequest> request = this.createRequest(bucketName, key, originalRequest, HttpMethodName.GET);
        request.addParameter("acl", null);
        if (versionId != null) {
            request.addParameter("versionId", versionId);
        }
        return this.invoke(request, new Unmarshallers.AccessControlListUnmarshaller(), bucketName, key);
    }

    private void setAcl(String bucketName, String key, AccessControlList acl, SCSWebServiceRequest originalRequest) {
        if (originalRequest == null) {
            originalRequest = new GenericBucketRequest(bucketName);
        }
        Request<SCSWebServiceRequest> request = this.createRequest(bucketName, key, originalRequest, HttpMethodName.PUT);
        request.addParameter("acl", null);
        byte[] aclAsJSON = new AclJsonFactory().convertToJsonByteArray(acl);
        request.addHeader("Content-Type", "text/plain");
        request.addHeader("Content-Length", String.valueOf(aclAsJSON.length));
        request.setContent(new ByteArrayInputStream(aclAsJSON));
        this.invoke(request, this.voidResponseHandler, bucketName, key);
    }

    protected Signer createSigner(Request<?> request, String bucketName, String key) {
        String resourcePath = "/" + (bucketName != null ? bucketName + "/" : "") + (key != null ? key : "");
        return new S3Signer(request.getHttpMethod().toString(), resourcePath);
    }

    protected <T> void presignRequest(Request<T> request, HttpMethod methodName, String bucketName, String key, Date expiration, String subResource) {
        this.beforeRequest(request);
        String resourcePath = "/" + (bucketName != null ? bucketName + "/" : "") + (key != null ? HttpUtils.urlEncode(key, true) : "") + (subResource != null ? "?" + subResource : "");
        resourcePath = resourcePath.replaceAll("(?<=/)/", "%2F");
        AWSCredentials credentials = this.awsCredentialsProvider.getCredentials();
        SCSWebServiceRequest originalRequest = request.getOriginalRequest();
        if (originalRequest != null && originalRequest.getRequestCredentials() != null) {
            credentials = originalRequest.getRequestCredentials();
        }
        new S3QueryStringSigner(methodName.toString(), resourcePath, expiration).sign(request, credentials);
        if (request.getHeaders().containsKey("x-amz-security-token")) {
            String value = request.getHeaders().get("x-amz-security-token");
            request.addParameter("x-amz-security-token", value);
            request.getHeaders().remove("x-amz-security-token");
        }
    }

    private <T> void beforeRequest(Request<T> request) {
    }

    private URI convertToVirtualHostEndpoint(String bucketName, URI endpoint) {
        try {
            return new URI(endpoint.getScheme() + "://" + bucketName + "." + endpoint.getAuthority());
        }
        catch (URISyntaxException e) {
            throw new IllegalArgumentException("Invalid bucket name: " + bucketName, e);
        }
    }

    protected static void populateRequestMetadata(Request<?> request, ObjectMetadata metadata) {
        Map<String, String> userHeader;
        Map<String, String> userMetadata;
        Date httpExpiresDate;
        Map<String, Object> rawMetadata = metadata.getRawMetadata();
        if (rawMetadata != null) {
            for (Map.Entry<String, Object> entry : rawMetadata.entrySet()) {
                request.addHeader(entry.getKey(), entry.getValue().toString());
            }
        }
        if ((httpExpiresDate = metadata.getHttpExpiresDate()) != null) {
            request.addHeader("Expires", new DateUtils().formatRfc822Date(httpExpiresDate));
        }
        if ((userMetadata = metadata.getUserMetadata()) != null) {
            for (Map.Entry<String, String> entry : userMetadata.entrySet()) {
                String key = entry.getKey();
                String value = entry.getValue();
                if (key != null) {
                    key = key.trim();
                }
                if (value != null) {
                    value = value.trim();
                }
                request.addHeader("x-amz-meta-" + key, value);
            }
        }
        if ((userHeader = metadata.getUserHeader()) != null) {
            for (Map.Entry<String, String> entry : userHeader.entrySet()) {
                String key = entry.getKey();
                String value = entry.getValue();
                if (key != null) {
                    key = key.trim();
                }
                if (value != null) {
                    value = value.trim();
                }
                request.addHeader(key, value);
            }
        }
    }

    private static void populateRequestWithCopyObjectParameters(Request<? extends SCSWebServiceRequest> request, CopyObjectRequest copyObjectRequest) {
        String copySourceHeader = "/" + HttpUtils.urlEncode(copyObjectRequest.getSourceBucketName(), true) + "/" + HttpUtils.urlEncode(copyObjectRequest.getSourceKey(), true);
        request.addHeader("x-amz-copy-source", copySourceHeader);
        SCSClient.addDateHeader(request, "x-amz-copy-source-if-modified-since", copyObjectRequest.getModifiedSinceConstraint());
        SCSClient.addDateHeader(request, "x-amz-copy-source-if-unmodified-since", copyObjectRequest.getUnmodifiedSinceConstraint());
        SCSClient.addStringListHeader(request, "x-amz-copy-source-if-match", copyObjectRequest.getMatchingETagConstraints());
        SCSClient.addStringListHeader(request, "x-amz-copy-source-if-none-match", copyObjectRequest.getNonmatchingETagConstraints());
        if (copyObjectRequest.getAccessControlList() != null) {
            SCSClient.addAclHeaders(request, copyObjectRequest.getAccessControlList());
        } else if (copyObjectRequest.getCannedAccessControlList() != null) {
            request.addHeader("x-amz-acl", copyObjectRequest.getCannedAccessControlList().toString());
        }
        ObjectMetadata newObjectMetadata = copyObjectRequest.getNewObjectMetadata();
        if (newObjectMetadata != null) {
            request.addHeader("x-amz-metadata-directive", "REPLACE");
            SCSClient.populateRequestMetadata(request, newObjectMetadata);
        }
    }

    private static void addDateHeader(Request<?> request, String header, Date value) {
        if (value != null) {
            request.addHeader(header, ServiceUtils.formatRfc822Date(value));
        }
    }

    private static void addStringListHeader(Request<?> request, String header, List<String> values) {
        if (values != null && !values.isEmpty()) {
            request.addHeader(header, ServiceUtils.join(values));
        }
    }

    private static void addResponseHeaderParameters(Request<?> request, ResponseHeaderOverrides responseHeaders) {
        if (responseHeaders != null) {
            if (responseHeaders.getCacheControl() != null) {
                request.addParameter("response-cache-control", responseHeaders.getCacheControl());
            }
            if (responseHeaders.getContentDisposition() != null) {
                request.addParameter("response-content-disposition", responseHeaders.getContentDisposition());
            }
            if (responseHeaders.getContentEncoding() != null) {
                request.addParameter("response-content-encoding", responseHeaders.getContentEncoding());
            }
            if (responseHeaders.getContentLanguage() != null) {
                request.addParameter("response-content-language", responseHeaders.getContentLanguage());
            }
            if (responseHeaders.getContentType() != null) {
                request.addParameter("response-content-type", responseHeaders.getContentType());
            }
            if (responseHeaders.getExpires() != null) {
                request.addParameter("response-expires", responseHeaders.getExpires());
            }
        }
    }

    public String getResourceUrl(String bucketName, String key) {
        try {
            return this.getUrl(bucketName, key).toString();
        }
        catch (Exception e) {
            return null;
        }
    }

    public URL getUrl(String bucketName, String key) {
        DefaultRequest request = new DefaultRequest(Constants.S3_SERVICE_NAME);
        request.setHttpMethod(HttpMethodName.GET);
        this.configRequest(request, bucketName, key);
        return ServiceUtils.convertRequestToUrl(request);
    }

    protected <X extends SCSWebServiceRequest> Request<X> createRequest(String bucketName, String key, X originalRequest, HttpMethodName httpMethod) {
        DefaultRequest request = new DefaultRequest(originalRequest, Constants.S3_SERVICE_NAME);
        request.setHttpMethod(httpMethod);
        this.configRequest(request, bucketName, key);
        return request;
    }

    private void configRequest(Request<?> request, String bucketName, String key) {
        URI theEndpoint = null;
        if (request.getOriginalRequest() instanceof PutObjectRequest || request.getOriginalRequest() instanceof UploadPartRequest) {
            theEndpoint = this.endpoint4Upload;
        } else if (request.getOriginalRequest() instanceof GeneratePresignedUrlRequest) {
            GeneratePresignedUrlRequest generatePresignedUrlRequest = (GeneratePresignedUrlRequest)request.getOriginalRequest();
            if (generatePresignedUrlRequest.isBucketNameAsDomain()) {
                String domain = generatePresignedUrlRequest.getBucketName();
                if (!domain.contains("://")) {
                    domain = this.clientConfiguration.getProtocol().toString() + "://" + domain;
                }
                try {
                    theEndpoint = new URI(domain);
                }
                catch (URISyntaxException e) {
                    throw new IllegalArgumentException(e);
                }
                request.setEndpoint(theEndpoint);
                request.setResourcePath(key);
                return;
            }
            theEndpoint = this.endpoint;
        } else {
            theEndpoint = this.endpoint;
        }
        if (request.getHttpMethod() == HttpMethodName.GET && "https".equalsIgnoreCase(theEndpoint.getScheme())) {
            URIBuilder ub = new URIBuilder(theEndpoint);
            ub.setScheme("http");
            try {
                theEndpoint = ub.build();
            }
            catch (URISyntaxException e) {
                throw new IllegalArgumentException(e);
            }
        }
        if (!this.clientOptions.isPathStyleAccess() && BucketNameUtils.isDNSBucketName(bucketName) && !this.validIP(theEndpoint.getHost())) {
            request.setEndpoint(this.convertToVirtualHostEndpoint(bucketName, theEndpoint));
            if (key != null && key.startsWith("/")) {
                key = "/" + key;
            }
            request.setResourcePath(key);
        } else {
            request.setEndpoint(theEndpoint);
            if (bucketName != null) {
                request.setResourcePath(bucketName + "/" + (key != null ? key : ""));
            }
        }
    }

    private boolean validIP(String IP) {
        if (IP == null) {
            return false;
        }
        String[] tokens = IP.split("\\.");
        if (tokens.length != 4) {
            return false;
        }
        for (String token : tokens) {
            int tokenInt;
            try {
                tokenInt = Integer.parseInt(token);
            }
            catch (NumberFormatException ase) {
                return false;
            }
            if (tokenInt >= 0 && tokenInt <= 255) continue;
            return false;
        }
        return true;
    }

    private <X, Y extends SCSWebServiceRequest> X invoke(Request<Y> request, Unmarshaller<X, InputStream> unmarshaller, String bucketName, String key) {
        return this.invoke(request, new S3JsonResponseHandler<X>(unmarshaller), bucketName, key);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private <X, Y extends SCSWebServiceRequest> X invoke(Request<Y> request, HttpResponseHandler<SCSWebServiceResponse<X>> responseHandler, String bucket, String key) {
        SCSWebServiceRequest originalRequest = request.getOriginalRequest();
        ExecutionContext executionContext = this.createExecutionContext(originalRequest);
        Response response = null;
        for (Map.Entry<String, String> entry : request.getOriginalRequest().copyPrivateRequestParameters().entrySet()) {
            request.addParameter(entry.getKey(), entry.getValue());
        }
        request.addParameter("formatter", "json");
        request.setTimeOffset(this.timeOffset);
        if (request.getHeaders().get("Content-Type") == null) {
            request.addHeader("Content-Type", "application/x-www-form-urlencoded; charset=utf-8");
        }
        AWSCredentials credentials = this.awsCredentialsProvider.getCredentials();
        if (originalRequest.getRequestCredentials() != null) {
            credentials = originalRequest.getRequestCredentials();
        }
        executionContext.setSigner(this.createSigner(request, bucket, key));
        executionContext.setCredentials(credentials);
        response = this.client.execute(request, responseHandler, this.errorResponseHandler, executionContext);
        Object t = response.getAwsResponse();
        return (X)t;
    }
}

