/*
 * Decompiled with CFR 0.152.
 */
package com.sinacloud.scs.services.scs.model;

import com.sinacloud.scs.services.scs.model.Grant;
import com.sinacloud.scs.services.scs.model.Grantee;
import com.sinacloud.scs.services.scs.model.Permission;
import com.sinacloud.scs.services.scs.model.UserIdGrantee;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AccessControlList
implements Serializable {
    private static final long serialVersionUID = 8095040648034788376L;
    private HashSet<Grant> grants = new HashSet();

    public AccessControlList() {
    }

    public AccessControlList(Map<String, Object> jsonMap) {
        Map acl = (Map)jsonMap.get("ACL");
        for (Map.Entry entry : acl.entrySet()) {
            List list = (List)entry.getValue();
            if (list == null) continue;
            this.grantPermission((Grantee)new UserIdGrantee((String)entry.getKey()), Permission.parsePermissions((List)entry.getValue()));
        }
    }

    public void grantPermission(Grantee grantee, Permission permission) {
        this.grants.add(new Grant(grantee, permission));
    }

    public void grantPermissions(Grantee grantee, Permission ... permissions) {
        this.grants.add(new Grant(grantee, permissions));
    }

    public void grantPermission(Grantee grantee, HashSet<Permission> permissions) {
        this.grants.add(new Grant(grantee, permissions));
    }

    public void grantAllPermissions(Grant ... grantsVarArg) {
        for (Grant gap : grantsVarArg) {
            this.grantPermission(gap.getGrantee(), gap.getPermissions());
        }
    }

    public void revokeAllPermissions(Grantee grantee) {
        ArrayList<Grant> grantsToRemove = new ArrayList<Grant>();
        for (Grant gap : this.grants) {
            if (!gap.getGrantee().equals(grantee)) continue;
            grantsToRemove.add(gap);
        }
        this.grants.removeAll(grantsToRemove);
    }

    public Set<Grant> getGrants() {
        return this.grants;
    }

    public String toString() {
        return "AccessControlList [grants=" + this.getGrants() + "]";
    }
}

