/*
 * Decompiled with CFR 0.152.
 */
package com.sinacloud.scs.services.scs.model;

import com.sinacloud.scs.services.scs.model.Grantee;
import com.sinacloud.scs.services.scs.model.Permission;
import java.util.ArrayList;
import java.util.HashSet;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Grant {
    private Grantee grantee = null;
    private HashSet<Permission> permissions = new HashSet();

    public Grant(Grantee grantee, Permission permission) {
        this.grantee = grantee;
        this.permissions.add(permission);
    }

    public Grant(Grantee grantee, Permission ... permissions) {
        this.grantee = grantee;
        for (Permission permission : permissions) {
            this.permissions.add(permission);
        }
    }

    public Grant(Grantee grantee, HashSet<Permission> permissions) {
        this.grantee = grantee;
        for (Permission permission : permissions) {
            this.permissions.add(permission);
        }
    }

    public Grantee getGrantee() {
        return this.grantee;
    }

    public HashSet<Permission> getPermissions() {
        return this.permissions;
    }

    public String[] getPermissionsForJsonArray() {
        ArrayList<String> list = new ArrayList<String>();
        for (Permission p : this.permissions) {
            list.add(p.toString());
        }
        return list.toArray(new String[list.size()]);
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.grantee == null ? 0 : this.grantee.hashCode());
        result = 31 * result + (this.permissions == null ? 0 : this.permissions.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Grant other = (Grant)obj;
        if (this.grantee == null ? other.grantee != null : !this.grantee.equals(other.grantee)) {
            return false;
        }
        if (this.permissions.size() != other.permissions.size()) {
            return false;
        }
        return this.permissions.containsAll(other.permissions);
    }

    public String toString() {
        return "Grant [grantee=" + this.grantee + ", permissions=" + this.permissions + "]";
    }
}

