/*
 * Decompiled with CFR 0.152.
 */
package com.sinacloud.scs.services.scs.model;

import java.util.HashSet;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public enum Permission {
    FullControl("full_control", "x-amz-grant-full-control"),
    Read("read", "x-amz-grant-read"),
    Write("write", "x-amz-grant-write"),
    ReadAcp("read_acp", "x-amz-grant-read-acp"),
    WriteAcp("write_acp", "x-amz-grant-write-acp");

    private String permissionString;
    private String headerName;

    private Permission(String permissionString, String headerName) {
        this.permissionString = permissionString;
        this.headerName = headerName;
    }

    public String getHeaderName() {
        return this.headerName;
    }

    public String toString() {
        return this.permissionString;
    }

    public static Permission parsePermission(String str) {
        for (Permission permission : Permission.values()) {
            if (!permission.permissionString.equalsIgnoreCase(str)) continue;
            return permission;
        }
        return null;
    }

    public static HashSet<Permission> parsePermissions(List<String> strs) {
        HashSet<Permission> permissionSet = new HashSet<Permission>();
        if (strs != null) {
            for (String str : strs) {
                Permission p = Permission.parsePermission(str);
                if (p == null) continue;
                permissionSet.add(p);
            }
        }
        return permissionSet;
    }
}

