/*
 * Decompiled with CFR 0.152.
 */
package com.sinacloud.scs.util;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;
import java.util.SimpleTimeZone;
import java.util.TimeZone;

public class DateUtils {
    protected final SimpleDateFormat iso8601DateFormat = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSS'Z'");
    protected final SimpleDateFormat alternateIso8601DateFormat = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss'Z'");
    protected final SimpleDateFormat rfc822DateFormat = new SimpleDateFormat("EEE, dd MMM yyyy HH:mm:ss 'GMT'", Locale.US);
    protected final SimpleDateFormat rfc822DateFormatUTC = new SimpleDateFormat("EEE, dd MMM yyyy HH:mm:ss 'UTC'", Locale.US);
    protected final SimpleDateFormat compressedIso8601DateFormat = new SimpleDateFormat("yyyyMMdd'T'HHmmss'Z'");

    public DateUtils() {
        this.iso8601DateFormat.setTimeZone(new SimpleTimeZone(0, "GMT"));
        this.rfc822DateFormat.setTimeZone(new SimpleTimeZone(0, "GMT"));
        this.rfc822DateFormatUTC.setTimeZone(TimeZone.getTimeZone("UTC"));
        this.alternateIso8601DateFormat.setTimeZone(new SimpleTimeZone(0, "GMT"));
        this.compressedIso8601DateFormat.setTimeZone(new SimpleTimeZone(0, "GMT"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Date parseIso8601Date(String dateString) throws ParseException {
        try {
            SimpleDateFormat simpleDateFormat = this.iso8601DateFormat;
            synchronized (simpleDateFormat) {
                return this.iso8601DateFormat.parse(dateString);
            }
        }
        catch (ParseException e) {
            SimpleDateFormat simpleDateFormat = this.alternateIso8601DateFormat;
            synchronized (simpleDateFormat) {
                return this.alternateIso8601DateFormat.parse(dateString);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String formatIso8601Date(Date date) {
        SimpleDateFormat simpleDateFormat = this.iso8601DateFormat;
        synchronized (simpleDateFormat) {
            return this.iso8601DateFormat.format(date);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Date parseRfc822Date(String dateString) throws ParseException {
        SimpleDateFormat simpleDateFormat = this.rfc822DateFormatUTC;
        synchronized (simpleDateFormat) {
            if (dateString != null) {
                if (dateString.endsWith("UTC")) {
                    return this.rfc822DateFormatUTC.parse(dateString);
                }
                return this.rfc822DateFormat.parse(dateString);
            }
            return this.rfc822DateFormat.parse(dateString);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String formatRfc822Date(Date date) {
        SimpleDateFormat simpleDateFormat = this.rfc822DateFormat;
        synchronized (simpleDateFormat) {
            return this.rfc822DateFormat.format(date);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Date parseCompressedIso8601Date(String dateString) throws ParseException {
        SimpleDateFormat simpleDateFormat = this.compressedIso8601DateFormat;
        synchronized (simpleDateFormat) {
            return this.compressedIso8601DateFormat.parse(dateString);
        }
    }
}

