/*
 * Decompiled with CFR 0.152.
 */
package com.soasta.mpulse.core;

import com.soasta.mpulse.core.MPLog;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public final class MPNotificationCenter {
    private static final MPNotificationCenter sharedInstance = new MPNotificationCenter();
    private static final String LOG_TAG = "MPNotificationCenter";
    private Map<String, List<MPNotificationCenterObserver>> _observers = new HashMap<String, List<MPNotificationCenterObserver>>();

    public static MPNotificationCenter defaultCenter() {
        return sharedInstance;
    }

    private MPNotificationCenter() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void postNotificationName(String name, Object notificationSender, Map<String, String> userInfo) {
        Map<String, List<MPNotificationCenterObserver>> map = this._observers;
        synchronized (map) {
            List<MPNotificationCenterObserver> observers = this._observers.get(name);
            if (observers != null) {
                MPNotification notification = new MPNotification(name, userInfo);
                for (MPNotificationCenterObserver observer : observers) {
                    MPLog.debug(LOG_TAG, "Sending notification \"" + name + "\" to observer " + observer);
                    observer.onNotification(notification);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addObserver(MPNotificationCenterObserver observer, String name) {
        Map<String, List<MPNotificationCenterObserver>> map = this._observers;
        synchronized (map) {
            List<MPNotificationCenterObserver> observers = this._observers.get(name);
            if (observers == null) {
                observers = new ArrayList<MPNotificationCenterObserver>();
                this._observers.put(name, observers);
            }
            MPLog.debug(LOG_TAG, "Adding observer " + observer + " for notification \"" + name + "\"");
            observers.add(observer);
        }
    }

    public static final class MPNotification {
        private String _name;
        private Map<String, String> _userInfo;

        public MPNotification(String name, Map<String, String> userInfo) {
            this._name = name;
            this._userInfo = userInfo;
        }

        public String getName() {
            return this._name;
        }

        public Map<String, String> getUserInfo() {
            return this._userInfo;
        }
    }

    public static interface MPNotificationCenterObserver {
        public void onNotification(MPNotification var1);
    }
}

