/*
 * Decompiled with CFR 0.152.
 */
package com.soasta.mpulse.core;

import com.soasta.mpulse.core.MPLog;
import com.soasta.mpulse.core.MPulseBase;
import com.soasta.mpulse.core.MPulseException;
import com.soasta.mpulse.core.beacons.MPApiCustomMetricBeacon;
import com.soasta.mpulse.core.beacons.MPApiCustomTimerBeacon;
import com.soasta.mpulse.core.collection.MPBeaconCollector;
import com.soasta.mpulse.core.config.MPConfig;
import com.soasta.mpulse.core.config.MPConfigDimension;
import com.soasta.mpulse.core.config.MPConfigPageParams;
import com.soasta.mpulse.core.session.MPSession;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;

public class MPulseInternal
extends MPulseBase {
    private static final String LOG_TAG = "MPulseInternal";
    public static final String MPULSE_BUILD_VERSION_NUMBER = "2.2.2";
    private Map<String, MPApiCustomTimerBeacon> _customTimerDictionary;
    private String _viewGroup = "";
    private String _abTest = "";
    private String[] _customDimensions = new String[10];
    protected Object _initializeLockObject = new Object();
    ExecutorService _threadExecutionScheduler = Executors.newSingleThreadScheduledExecutor();

    protected MPulseInternal() {
        this._customTimerDictionary = new HashMap<String, MPApiCustomTimerBeacon>();
    }

    public static MPulseBase initializeWithAPIKey(String apiKey, URL serverUrl) {
        MPulseInternal.sharedInstance();
        try {
            MPConfig config = MPConfig.sharedInstance();
            config.setMPulseServerURL(serverUrl);
            mPulseInstance.setAPIKey(apiKey);
        }
        catch (Exception ex) {
            MPLog.warn(LOG_TAG, "Unable to initialize mPulse Mobile with API Key. Exception occurred.", ex);
        }
        return mPulseInstance;
    }

    public boolean isInstanceInitialized() {
        return MPSession.sharedInstance().isStarted();
    }

    @Override
    public String getViewGroup() {
        return this._viewGroup;
    }

    public String[] getCustomDimensions() {
        return this._customDimensions;
    }

    @Override
    public void setViewGroup(String name) {
        this._viewGroup = name;
    }

    @Override
    public void resetViewGroup() {
        this._viewGroup = "";
    }

    @Override
    public void enable() {
        try {
            MPConfig.sharedInstance().setUserEnabledBeacons(true);
        }
        catch (Exception ex) {
            MPLog.warn(LOG_TAG, "Unable to enable mPulse Mobile. Exception occurred.", ex);
        }
    }

    @Override
    public void disable() {
        try {
            MPConfig.sharedInstance().setUserEnabledBeacons(false);
        }
        catch (Exception ex) {
            MPLog.warn(LOG_TAG, "Unable to disable mPulse Mobile. Exception occurred.", ex);
        }
    }

    @Override
    public String startTimer(String timerName) {
        try {
            if (!this.isInstanceInitialized()) {
                return "";
            }
            MPApiCustomTimerBeacon beacon = new MPApiCustomTimerBeacon(timerName);
            String timerKey = timerName + "-" + UUID.randomUUID();
            MPLog.debug(LOG_TAG, "TimerKey " + timerKey);
            this._customTimerDictionary.put(timerKey, beacon);
            return timerKey;
        }
        catch (Exception ex) {
            MPLog.warn(LOG_TAG, "Unable to start Timer. Exception occurred.", ex);
            return null;
        }
    }

    @Override
    public void cancelTimer(String timerID) {
        try {
            if (!this.isInstanceInitialized()) {
                return;
            }
            this._customTimerDictionary.remove(timerID);
        }
        catch (Exception ex) {
            MPLog.warn(LOG_TAG, "Unable to cancel Timer. Exception occurred.", ex);
        }
    }

    @Override
    public void stopTimer(String timerID, boolean updateDimensions) {
        try {
            if (!this.isInstanceInitialized()) {
                return;
            }
            MPApiCustomTimerBeacon beacon = this._customTimerDictionary.get(timerID);
            if (beacon != null) {
                if (updateDimensions) {
                    MPLog.debug(LOG_TAG, "Updating dimensions for " + timerID);
                    beacon.updatePageDimensions();
                }
                beacon.endTimer();
                this._customTimerDictionary.remove(timerID);
            }
        }
        catch (Exception ex) {
            MPLog.warn(LOG_TAG, "Unable to stop Timer. Exception occurred.", ex);
        }
    }

    @Override
    public void stopTimer(String timerID) {
        this.stopTimer(timerID, false);
    }

    @Override
    public void sendTimer(String timerName, long timerValue) {
        try {
            if (!this.isInstanceInitialized()) {
                return;
            }
            if (timerValue > Integer.MAX_VALUE) {
                timerValue = Integer.MAX_VALUE;
            }
            new MPApiCustomTimerBeacon(timerName, (int)timerValue);
        }
        catch (Exception ex) {
            MPLog.warn(LOG_TAG, "Unable to send Timer. Exception occurred.", ex);
        }
    }

    @Override
    public void sendMetric(String metricName, Number metricValue) {
        try {
            if (!this.isInstanceInitialized()) {
                return;
            }
            new MPApiCustomMetricBeacon(metricName, metricValue);
        }
        catch (Exception ex) {
            MPLog.warn(LOG_TAG, "Unable to send metric. Exception occurred.", ex);
        }
    }

    @Override
    public void setDimension(String dimensionName, String dimensionValue) {
        try {
            if (!this.isInstanceInitialized()) {
                return;
            }
            MPConfigDimension dimension = this.getDimensionFromConfig(dimensionName);
            if (dimension != null) {
                this._customDimensions[dimension.getIndex()] = dimensionValue;
            }
        }
        catch (Exception ex) {
            MPLog.warn(LOG_TAG, "Unable to set Dimension. Exception occurred.", ex);
        }
    }

    @Override
    public void resetDimension(String dimensionName) {
        try {
            if (!this.isInstanceInitialized()) {
                return;
            }
            MPConfigDimension dimension = this.getDimensionFromConfig(dimensionName);
            if (dimension != null) {
                this._customDimensions[dimension.getIndex()] = "";
            }
        }
        catch (Exception ex) {
            MPLog.warn(LOG_TAG, "Unable to reset Dimension. Exception occurred.", ex);
        }
    }

    private MPConfigDimension getDimensionFromConfig(String dimensionName) throws Exception {
        MPConfigPageParams config = MPConfig.sharedInstance().getConfig();
        if (config != null) {
            for (MPConfigDimension dimension : config.getDimensions()) {
                if (!dimension.getName().equals(dimensionName) || dimension.getIndex() >= 10) continue;
                return dimension;
            }
        }
        return null;
    }

    @Override
    public String getAPIKey() {
        try {
            return MPConfig.sharedInstance().getAPIKey();
        }
        catch (Exception ex) {
            MPLog.warn(LOG_TAG, "Unable to get API Key. Exception occurred.", ex);
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setAPIKey(String apiKey) {
        try {
            Object object = this._initializeLockObject;
            synchronized (object) {
                if (this._threadExecutionScheduler.isShutdown() || this._threadExecutionScheduler.isTerminated()) {
                    throw new MPulseException("Cannot set API key during shutdown.", new Object[0]);
                }
                MPSession.sharedInstance();
                final MPConfig config = MPConfig.sharedInstance();
                config.setAPIKey(apiKey);
                this._threadExecutionScheduler.submit(new Runnable(){

                    @Override
                    public void run() {
                        try {
                            config.buildConfigRequestURL();
                            config.refresh();
                        }
                        catch (Exception ex) {
                            MPLog.warn(MPulseInternal.LOG_TAG, "Unable to refresh Config.", ex);
                        }
                    }
                });
            }
        }
        catch (Exception ex) {
            MPLog.warn(LOG_TAG, "Unable to set API Key. Exception occurred.", ex);
        }
    }

    @Override
    public URL getServerURL() {
        try {
            return MPConfig.sharedInstance().getMPulseServerURL();
        }
        catch (Exception ex) {
            MPLog.warn(LOG_TAG, "Unable to get Server URL. Exception occurred.", ex);
            return null;
        }
    }

    @Override
    public String getABTest() {
        return this._abTest;
    }

    @Override
    public void setABTest(String abTest) {
        this._abTest = abTest;
    }

    @Override
    public void resetABTest() {
        this._abTest = "";
    }

    @Override
    public String[] getDimensions() {
        return (String[])this._customDimensions.clone();
    }

    public void shutdown() {
        try {
            this.shutdown((int)MPConfig.sharedInstance().getBeaconInterval() + 5);
        }
        catch (Exception ex) {
            MPLog.warn(LOG_TAG, "Config shutdown failed.", ex);
        }
    }

    public void shutdown(int maxDelay) {
        this._threadExecutionScheduler.shutdownNow();
        try {
            MPConfig.sharedInstance().setRefreshDisabled(true);
            MPConfig.sharedInstance().shutdown();
        }
        catch (Exception ex) {
            MPLog.warn(LOG_TAG, "Config shutdown failed.", ex);
        }
        MPBeaconCollector.sharedInstance().shutdown(maxDelay);
    }

    static {
        MPLog.info(LOG_TAG, "mPulse Java API build: 2.2.2");
        MPLog.info(LOG_TAG, "mPulse initialized.");
    }
}

