/*
 * Decompiled with CFR 0.152.
 */
package com.soasta.mpulse.core.beacons;

import com.soasta.mpulse.core.MPLog;
import com.soasta.mpulse.core.beacons.MPBeacon;
import com.soasta.mpulse.core.beacons.collector.BeaconType;
import com.soasta.mpulse.core.collection.ClientBeaconBatch;
import com.soasta.mpulse.core.collection.MPBeaconCollector;
import com.soasta.mpulse.core.config.MPConfig;
import com.soasta.mpulse.core.config.MPConfigMetric;
import com.soasta.mpulse.core.config.MPConfigPageParams;

public class MPApiCustomMetricBeacon
extends MPBeacon {
    private static final String LOG_TAG = "MPApiCustomMetricBeacon";
    private int _metricIndex;
    private String _metricName;
    private int _metricValue;

    public MPApiCustomMetricBeacon(String metricName, Number value) throws Exception {
        MPConfigPageParams config = MPConfig.sharedInstance().getConfig();
        if (config != null) {
            for (MPConfigMetric metric : config.getMetrics()) {
                if (!metric.getName().equals(metricName)) continue;
                this._metricName = metricName;
                this.initWithMetricIndex(metric.getIndex(), value);
                break;
            }
        }
    }

    public MPApiCustomMetricBeacon(int metricIndex, Number metricValue) {
        this.initWithMetricIndex(metricIndex, metricValue);
    }

    private void initWithMetricIndex(int metricIndex, Number metricValue) {
        if (metricValue == null) {
            return;
        }
        this._metricIndex = metricIndex;
        this._metricValue = metricValue.intValue();
        MPLog.debug(LOG_TAG, "Initialized metric beacon: index=" + metricIndex + ", value=" + metricValue);
        MPBeaconCollector.sharedInstance().addBeacon(this);
    }

    public int getMetricIndex() {
        return this._metricIndex;
    }

    public void setMetricIndex(int metricIndex) {
        this._metricIndex = metricIndex;
    }

    public int getMetricValue() {
        return this._metricValue;
    }

    public void setMetricValue(int metricValue) {
        this._metricValue = metricValue;
    }

    public String getMetricName() {
        return this._metricName;
    }

    public void setMetricName(String metricName) {
        this._metricName = metricName;
    }

    @Override
    public BeaconType getBeaconType() {
        return BeaconType.API_CUSTOM_METRIC;
    }

    @Override
    public void serialize(ClientBeaconBatch.ClientBeaconRecord.Builder record) {
        super.serialize(record);
        if (record == null) {
            return;
        }
        ClientBeaconBatch.ClientBeaconRecord.ApiCustomMetricData.Builder builder = new ClientBeaconBatch.ClientBeaconRecord.ApiCustomMetricData.Builder();
        builder.metric_index = this._metricIndex;
        builder.metric_value = this._metricValue;
        record.api_custom_metric_data = builder.build();
    }
}

