/*
 * Decompiled with CFR 0.152.
 */
package com.soasta.mpulse.core.beacons;

import com.soasta.mpulse.core.MPLog;
import com.soasta.mpulse.core.beacons.MPBeacon;
import com.soasta.mpulse.core.beacons.collector.BeaconType;
import com.soasta.mpulse.core.collection.ClientBeaconBatch;
import com.soasta.mpulse.core.collection.MPBeaconCollector;
import com.soasta.mpulse.core.config.MPConfig;
import com.soasta.mpulse.core.config.MPConfigTimer;
import java.util.Date;

public class MPApiCustomTimerBeacon
extends MPBeacon {
    private static final String LOG_TAG = "MPApiCustomTimerBeacon";
    private int _timerIndex;
    private int _timerValue;
    private boolean _hasTimerStarted;
    private boolean _hasTimerEnded;
    private String _timerName;
    private Date _startTime;

    public MPApiCustomTimerBeacon(String timerName) throws Exception {
        for (MPConfigTimer timer : MPConfig.sharedInstance().getConfig().getTimers()) {
            if (!timer.getName().equals(timerName)) continue;
            this._timerIndex = timer.getIndex();
            this._timerName = timerName;
            this.startTimer();
            break;
        }
    }

    public MPApiCustomTimerBeacon(int timerIndex) {
        this._timerIndex = timerIndex;
        this.startTimer();
    }

    public MPApiCustomTimerBeacon(int timerIndex, int value) throws Exception {
        this.initWithTimerIndex(timerIndex, value);
    }

    public MPApiCustomTimerBeacon(String timerName, int value) throws Exception {
        for (MPConfigTimer timer : MPConfig.sharedInstance().getConfig().getTimers()) {
            if (!timer.getName().equals(timerName)) continue;
            this.initWithTimerIndex(timer.getIndex(), value);
            this._timerName = timerName;
            break;
        }
    }

    private void initWithTimerIndex(int timerIndex, int value) {
        this._timerIndex = timerIndex;
        this._timerValue = value;
        this._hasTimerStarted = true;
        this._hasTimerEnded = true;
        MPBeaconCollector.sharedInstance().addBeacon(this);
    }

    public void startTimer() {
        this._startTime = new Date();
        this._timerValue = 0;
        this._hasTimerStarted = true;
        this._hasTimerEnded = false;
    }

    public void endTimer() {
        if (this._startTime == null || !this._hasTimerStarted) {
            MPLog.warn(LOG_TAG, "Calling endTimer() on a timer that never started");
            return;
        }
        this._timerValue = (int)(System.currentTimeMillis() - this._startTime.getTime());
        this._hasTimerEnded = true;
        MPBeaconCollector.sharedInstance().addBeacon(this);
    }

    public boolean hasTimerStarted() {
        return this._hasTimerStarted;
    }

    public boolean hasTimerEnded() {
        return this._hasTimerEnded;
    }

    public String getTimerName() {
        return this._timerName;
    }

    public void setTimerName(String timerName) {
        this._timerName = timerName;
    }

    public int getTimerIndex() {
        return this._timerIndex;
    }

    public void setTimerIndex(int timerIndex) {
        this._timerIndex = timerIndex;
    }

    public int getTimerValue() {
        return this._timerValue;
    }

    public void setTimerValue(int timerValue) {
        this._timerValue = timerValue;
    }

    @Override
    public BeaconType getBeaconType() {
        return BeaconType.API_CUSTOM_TIMER;
    }

    @Override
    public void serialize(ClientBeaconBatch.ClientBeaconRecord.Builder record) {
        super.serialize(record);
        if (record == null) {
            return;
        }
        ClientBeaconBatch.ClientBeaconRecord.ApiCustomTimerData.Builder builder = new ClientBeaconBatch.ClientBeaconRecord.ApiCustomTimerData.Builder();
        builder.timer_index = this._timerIndex;
        builder.timer_value = this._timerValue;
        record.api_custom_timer_data = builder.build();
    }
}

