/*
 * Decompiled with CFR 0.152.
 */
package com.soasta.mpulse.core.beacons;

import com.soasta.mpulse.core.MPulseInternal;
import com.soasta.mpulse.core.beacons.collector.BeaconType;
import com.soasta.mpulse.core.collection.ClientBeaconBatch;
import com.soasta.mpulse.core.session.MPSession;
import java.util.ArrayList;
import java.util.Date;

public abstract class MPBeacon {
    private Date _timestamp = new Date();
    private boolean _addedToCollector = false;
    private String _pageGroup = "";
    private String _abTest = "";
    private String[] _customDimensions = null;

    public MPBeacon() {
        if (MPSession.sharedInstance().isStarted()) {
            this.updatePageDimensions();
        }
    }

    public Date getTimestamp() {
        return this._timestamp;
    }

    public void resetTimestamp() {
        this._timestamp = new Date();
    }

    public boolean addedToCollector() {
        return this._addedToCollector;
    }

    public void setAddedToCollector(boolean addedToCollector) {
        this._addedToCollector = addedToCollector;
    }

    public String getPageGroup() {
        return this._pageGroup;
    }

    public void setPageGroup(String pageGroup) {
        this._pageGroup = pageGroup;
    }

    public String getAbTest() {
        return this._abTest;
    }

    public void setAbTest(String abTest) {
        this._abTest = abTest;
    }

    public void setCustomDimensions(String[] customDimensions) {
        this._customDimensions = customDimensions;
    }

    public String[] getCustomDimensions() {
        return this._customDimensions;
    }

    public BeaconType getBeaconType() {
        return BeaconType.BATCH;
    }

    public void serialize(ClientBeaconBatch.ClientBeaconRecord.Builder record) {
        if (record == null) {
            return;
        }
        record.timestamp = this._timestamp.getTime();
        if (this.getBeaconType().getIndex() < ClientBeaconBatch.BeaconType.values().length) {
            record.beacon_type = ClientBeaconBatch.BeaconType.values()[this.getBeaconType().getIndex()];
        }
        if (this._abTest != null && this._abTest.length() > 0) {
            record.ab_test = this._abTest;
        }
        if (this._pageGroup != null && this._pageGroup.length() > 0) {
            record.page_group = this._pageGroup;
        }
        if (this._customDimensions != null) {
            record.custom_dimensions = new ArrayList<String>();
            for (int i = 0; i < this._customDimensions.length; ++i) {
                String val = "";
                if (this._customDimensions[i] != null && this._customDimensions[i].length() > 0) {
                    val = this._customDimensions[i];
                }
                record.custom_dimensions.add(val);
            }
        }
    }

    public void updatePageDimensions() {
        this._pageGroup = MPulseInternal.sharedInstance().getViewGroup();
        this._abTest = MPulseInternal.sharedInstance().getABTest();
        this._customDimensions = MPulseInternal.sharedInstance().getDimensions();
    }

    public void clearPageDimensions() {
        this._pageGroup = "";
        this._abTest = "";
        this._customDimensions = null;
    }

    public double getDuration() {
        return -1.0;
    }
}

