/*
 * Decompiled with CFR 0.152.
 */
package com.soasta.mpulse.core.collection;

import com.soasta.mpulse.core.MPLog;
import com.soasta.mpulse.core.beacons.MPBeacon;
import com.soasta.mpulse.core.collection.MPBatchTransport;
import com.soasta.mpulse.core.collection.events.MPBeaconCollectorEventListener;
import com.soasta.mpulse.core.collection.events.MPBeaconCollectorEventObject;
import com.soasta.mpulse.core.config.MPConfig;
import com.soasta.mpulse.core.session.MPSession;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;

public class MPBeaconCollector {
    private static final String LOG_TAG = "MPBeaconCollector";
    private static volatile MPBeaconCollector sharedObject;
    private static final Object sharedObjectLock;
    private ScheduledExecutorService _executor;
    private ArrayList<MPBeacon> _beacons;
    private boolean _disableBatchSending = false;
    private Set<MPBeaconCollectorEventListener> _eventListeners = new HashSet<MPBeaconCollectorEventListener>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static MPBeaconCollector sharedInstance() {
        if (sharedObject == null) {
            Object object = sharedObjectLock;
            synchronized (object) {
                if (sharedObject == null) {
                    sharedObject = new MPBeaconCollector();
                }
            }
        }
        return sharedObject;
    }

    private MPBeaconCollector() {
        this._beacons = new ArrayList();
        this._executor = Executors.newSingleThreadScheduledExecutor();
        this.enqueueSendBatchTask(5);
    }

    public void addBeacon(final MPBeacon beacon) {
        if (this._executor.isShutdown() || this._executor.isTerminated()) {
            return;
        }
        this._executor.schedule(new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                MPBeaconCollector.this.addBeaconInternal(beacon);
                return null;
            }
        }, 0L, TimeUnit.SECONDS);
    }

    private void addBeaconInternal(MPBeacon beacon) {
        try {
            if (!MPConfig.sharedInstance().beaconsEnabled()) {
                MPLog.debug(LOG_TAG, "Beacons are disabled; ignoring incoming " + beacon.getClass().getName() + ".");
                return;
            }
            if (beacon.addedToCollector()) {
                return;
            }
            beacon.setAddedToCollector(true);
            MPSession.sharedInstance().addBeacon(beacon);
            this._beacons.add(beacon);
            this.fireBeaconAddedEvent(beacon);
        }
        catch (Exception e) {
            MPLog.debug(LOG_TAG, "Failed to process incoming beacon.", e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fireBeaconAddedEvent(MPBeacon beacon) {
        MPBeaconCollectorEventObject event = new MPBeaconCollectorEventObject(this, beacon);
        MPLog.debug(LOG_TAG, "Beacon has been added distributing Beacon to listeners... " + beacon);
        Set<MPBeaconCollectorEventListener> set = this._eventListeners;
        synchronized (set) {
            for (MPBeaconCollectorEventListener listener : this._eventListeners) {
                try {
                    listener.beaconAdded(event);
                }
                catch (Exception e) {
                    MPLog.error(LOG_TAG, "Beacon listener caused an exception", e);
                }
            }
        }
    }

    public void sendBatch() {
        if (this._disableBatchSending) {
            return;
        }
        try {
            if (this._beacons.size() == 0) {
                MPLog.debug(LOG_TAG, "No beacons to send.");
            } else {
                ArrayList<MPBeacon> beacons = this._beacons;
                this._beacons = new ArrayList();
                MPBatchTransport transport = new MPBatchTransport();
                transport.sendBatch(beacons);
            }
            this.enqueueSendBatchTask((int)MPConfig.sharedInstance().getBeaconInterval());
        }
        catch (Exception e) {
            MPLog.debug(LOG_TAG, "Failed to send batch.", e);
        }
    }

    private void enqueueSendBatchTask(int delaySeconds) {
        this._executor.schedule(new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                MPBeaconCollector.this.sendBatch();
                return null;
            }
        }, (long)delaySeconds, TimeUnit.SECONDS);
    }

    public boolean isDisableBatchSending() {
        return this._disableBatchSending;
    }

    public void setDisableBatchSending(boolean disableBatchSending) {
        this._disableBatchSending = disableBatchSending;
    }

    public ArrayList<MPBeacon> getBeacons() {
        return this._beacons;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addEventListener(MPBeaconCollectorEventListener listener) {
        Set<MPBeaconCollectorEventListener> set = this._eventListeners;
        synchronized (set) {
            this._eventListeners.add(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeEventListener(MPBeaconCollectorEventListener listener) {
        Set<MPBeaconCollectorEventListener> set = this._eventListeners;
        synchronized (set) {
            this._eventListeners.remove(listener);
        }
    }

    public void clearBatch() {
        this._beacons = new ArrayList();
    }

    public void shutdown(int maxDelay) {
        if (maxDelay <= 0) {
            this._executor.shutdownNow();
        } else {
            this._executor.shutdown();
            try {
                this._executor.awaitTermination(maxDelay, TimeUnit.SECONDS);
            }
            catch (InterruptedException e) {
                MPLog.warn(LOG_TAG, "Waiting for executor termination interrupted.", e);
            }
            if (!this._executor.isTerminated()) {
                this._executor.shutdownNow();
            }
        }
    }

    static {
        sharedObjectLock = new Object();
    }
}

