/*
 * Decompiled with CFR 0.152.
 */
package com.soasta.mpulse.core.config;

import com.soasta.mpulse.core.MPLog;
import java.util.Arrays;
import org.json.JSONException;
import org.json.JSONObject;

public class MPConfigPageGroup {
    private String _name;
    private int _index;
    private String _type;
    private String _label;
    private String _pageGroupValue;
    private boolean _hasResponderInjected;
    private static final String LOG_TAG = "MPConfigPageGroup";

    public MPConfigPageGroup(String jsonDataString) {
        this.initWithJson(jsonDataString);
    }

    public void initWithJson(String jsonDataString) {
        if (jsonDataString == null) {
            return;
        }
        try {
            JSONObject jsonData = new JSONObject(jsonDataString);
            this._name = jsonData.has("name") ? jsonData.getString("name") : null;
            this._index = jsonData.has("index") ? jsonData.getInt("index") : 0;
            this._type = jsonData.has("type") ? jsonData.getString("type") : null;
            this._label = jsonData.has("label") ? jsonData.getString("label") : null;
        }
        catch (JSONException e) {
            MPLog.warn(LOG_TAG, "JSONException from initWithJson", e);
        }
        this._hasResponderInjected = false;
    }

    public String toString() {
        String responderInjected = this._hasResponderInjected ? "YES" : "NO";
        String pageGroupString = "[MPConfigPageGroup: hasResponderInjected=" + responderInjected + ", pageGroupValue= " + this._pageGroupValue + ", name= " + this._name + ", index= " + this._index + ", type= " + this._type + ", label= " + this._label + "]";
        return pageGroupString;
    }

    public int hashCode() {
        return Arrays.hashCode(new Object[]{this._name, this._type, this._label});
    }

    public boolean isEqualToPageGroup(MPConfigPageGroup pageGroup) {
        if (pageGroup == null) {
            return false;
        }
        boolean haveEqualIndex = this._index == pageGroup.getIndex();
        boolean haveEqualNames = this._name == null && pageGroup.getName() == null || this._name != null && this._name.equals(pageGroup.getName());
        boolean haveEqualTypes = this._type == null && pageGroup.getType() == null || this._type != null && this._type.equals(pageGroup.getType());
        boolean haveEqualLabels = this._label == null && pageGroup.getLabel() == null || this._label != null && this._label.equals(pageGroup.getLabel());
        return haveEqualIndex && haveEqualNames && haveEqualTypes && haveEqualLabels;
    }

    public boolean equals(Object object) {
        if (object instanceof MPConfigPageGroup) {
            return this.isEqualToPageGroup((MPConfigPageGroup)object);
        }
        return false;
    }

    public String getName() {
        return this._name;
    }

    public int getIndex() {
        return this._index;
    }

    public String getType() {
        return this._type;
    }

    public String getLabel() {
        return this._label;
    }

    public String getPageGroupValue() {
        return this._pageGroupValue;
    }

    public void setPageGroupValue(String pageGroupValue) {
        this._pageGroupValue = pageGroupValue;
    }

    public boolean hasResponderInjected() {
        return this._hasResponderInjected;
    }

    public void setHasResponderInjected(boolean hasResponderInjected) {
        this._hasResponderInjected = hasResponderInjected;
    }
}

