/*
 * Decompiled with CFR 0.152.
 */
package com.soasta.mpulse.core.config;

import com.soasta.mpulse.core.MPLog;
import com.soasta.mpulse.core.config.MPConfigDimension;
import com.soasta.mpulse.core.config.MPConfigMetric;
import com.soasta.mpulse.core.config.MPConfigPageGroup;
import com.soasta.mpulse.core.config.MPConfigTimer;
import java.util.ArrayList;
import java.util.List;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class MPConfigPageParams {
    private List<MPConfigPageGroup> _pageGroups;
    private List<MPConfigMetric> _metrics;
    private List<MPConfigTimer> _timers;
    private List<MPConfigDimension> _dimensions;
    private static final String LOG_TAG = "MPConfigPageParams";

    public MPConfigPageParams() {
        this._pageGroups = new ArrayList<MPConfigPageGroup>();
        this._metrics = new ArrayList<MPConfigMetric>();
        this._timers = new ArrayList<MPConfigTimer>();
        this._dimensions = new ArrayList<MPConfigDimension>();
    }

    public MPConfigPageParams(String jsonDataString) {
        this.initWithJson(jsonDataString);
    }

    public void initWithJson(String jsonDataString) {
        if (jsonDataString != null) {
            ArrayList<MPConfigPageGroup> tempPageGroups = new ArrayList<MPConfigPageGroup>();
            ArrayList<MPConfigMetric> tempMetrics = new ArrayList<MPConfigMetric>();
            ArrayList<MPConfigTimer> tempTimers = new ArrayList<MPConfigTimer>();
            ArrayList<MPConfigDimension> tempDimensions = new ArrayList<MPConfigDimension>();
            try {
                JSONObject jsonData = new JSONObject(jsonDataString);
                if (jsonData.has("pageGroups")) {
                    JSONArray pageGroupsNode = jsonData.getJSONArray("pageGroups");
                    for (int i = 0; i < pageGroupsNode.length(); ++i) {
                        MPConfigPageGroup pageGroupInstance = new MPConfigPageGroup(pageGroupsNode.get(i).toString());
                        tempPageGroups.add(pageGroupInstance);
                    }
                }
                if (jsonData.has("customMetrics")) {
                    JSONArray metricsNode = jsonData.getJSONArray("customMetrics");
                    for (int i = 0; i < metricsNode.length(); ++i) {
                        MPConfigMetric metricInstance = new MPConfigMetric(metricsNode.get(i).toString());
                        tempMetrics.add(metricInstance);
                    }
                }
                if (jsonData.has("customTimers")) {
                    JSONArray timerNode = jsonData.getJSONArray("customTimers");
                    for (int i = 0; i < timerNode.length(); ++i) {
                        MPConfigTimer timerInstance = new MPConfigTimer(timerNode.get(i).toString());
                        tempTimers.add(timerInstance);
                    }
                }
                if (jsonData.has("customDimensions")) {
                    JSONArray dimensionNode = jsonData.getJSONArray("customDimensions");
                    for (int i = 0; i < dimensionNode.length(); ++i) {
                        MPConfigDimension dimensionInstance = new MPConfigDimension(dimensionNode.get(i).toString());
                        tempDimensions.add(dimensionInstance);
                    }
                }
            }
            catch (JSONException e) {
                MPLog.warn(LOG_TAG, "JSONException from initWithJson", e);
                return;
            }
            this._pageGroups = tempPageGroups;
            this._metrics = tempMetrics;
            this._timers = tempTimers;
            this._dimensions = tempDimensions;
        }
    }

    public void deepCopy(MPConfigPageParams config) {
        ArrayList<MPConfigPageGroup> inputPageGroups = new ArrayList<MPConfigPageGroup>(config.getPageGroups());
        for (MPConfigPageGroup mPConfigPageGroup : inputPageGroups) {
            for (MPConfigPageGroup mPConfigPageGroup2 : this._pageGroups) {
                if (!mPConfigPageGroup.isEqualToPageGroup(mPConfigPageGroup2)) continue;
                mPConfigPageGroup.setHasResponderInjected(mPConfigPageGroup2.hasResponderInjected());
                mPConfigPageGroup.setPageGroupValue(mPConfigPageGroup2.getPageGroupValue());
            }
        }
        this._pageGroups = inputPageGroups;
        ArrayList<MPConfigMetric> inputMetrics = new ArrayList<MPConfigMetric>(config.getMetrics());
        for (MPConfigMetric mPConfigMetric : inputMetrics) {
            for (MPConfigMetric mPConfigMetric2 : this._metrics) {
                if (!mPConfigMetric.isEqualToMetric(mPConfigMetric2)) continue;
                mPConfigMetric.setHasResponderInjected(mPConfigMetric2.hasResponderInjected());
                mPConfigMetric.setBeaconSent(mPConfigMetric2.getBeaconSent());
            }
        }
        this._metrics = inputMetrics;
        ArrayList<MPConfigTimer> arrayList = new ArrayList<MPConfigTimer>(config.getTimers());
        for (MPConfigTimer mPConfigTimer : arrayList) {
            for (MPConfigTimer oldTimer : this._timers) {
                if (!mPConfigTimer.isEqualToTimer(oldTimer)) continue;
                mPConfigTimer.setHasStartTimerResponderInjected(oldTimer.hasStartTimerResponderInjected());
                mPConfigTimer.setHasEndTimerResponderInjected(oldTimer.hasEndTimerResponderInjected());
                if (oldTimer.getBeacon() == null) continue;
                mPConfigTimer.setBeacon(oldTimer.getBeacon());
            }
        }
        this._timers = arrayList;
        ArrayList<MPConfigDimension> arrayList2 = new ArrayList<MPConfigDimension>(config.getDimensions());
        for (MPConfigDimension mPConfigDimension : arrayList2) {
            for (MPConfigDimension oldDimension : this._dimensions) {
                if (!mPConfigDimension.isEqualToDimension(oldDimension)) continue;
                mPConfigDimension.setHasResponderInjected(oldDimension.hasResponderInjected());
                mPConfigDimension.setBeaconSent(oldDimension.getBeaconSent());
            }
        }
        this._dimensions = arrayList2;
    }

    /*
     * WARNING - void declaration
     */
    public String toString() {
        void var4_11;
        void var3_6;
        StringBuilder pageGroupsString = new StringBuilder();
        for (MPConfigPageGroup mPConfigPageGroup : this.getPageGroups()) {
            pageGroupsString = pageGroupsString.append(mPConfigPageGroup == null ? "" : mPConfigPageGroup);
        }
        StringBuilder metricsString = new StringBuilder();
        for (MPConfigMetric mPConfigMetric : this.getMetrics()) {
            metricsString = metricsString.append(mPConfigMetric == null ? "" : mPConfigMetric);
        }
        StringBuilder stringBuilder = new StringBuilder();
        for (MPConfigTimer mPConfigTimer : this.getTimers()) {
            StringBuilder stringBuilder2 = var3_6.append(mPConfigTimer == null ? "" : mPConfigTimer);
        }
        StringBuilder stringBuilder3 = new StringBuilder();
        for (MPConfigDimension dimension : this.getDimensions()) {
            StringBuilder stringBuilder4 = var4_11.append(dimension == null ? "" : dimension);
        }
        String string = "[MPConfigPageParams: pageGroups=(" + pageGroupsString + "), metrics=(" + metricsString + "), timers=(" + var3_6 + "), dimensions=(" + var4_11 + ")]";
        return string;
    }

    public List<MPConfigMetric> getMetrics() {
        return this._metrics;
    }

    public void setMetrics(List<MPConfigMetric> metrics) {
        this._metrics = metrics;
    }

    public List<MPConfigTimer> getTimers() {
        return this._timers;
    }

    public void setTimers(List<MPConfigTimer> timers) {
        this._timers = timers;
    }

    public List<MPConfigPageGroup> getPageGroups() {
        return this._pageGroups;
    }

    public void setPageGroups(List<MPConfigPageGroup> pageGroups) {
        this._pageGroups = pageGroups;
    }

    public List<MPConfigDimension> getDimensions() {
        return this._dimensions;
    }

    public void setDimensions(List<MPConfigDimension> dimensions) {
        this._dimensions = dimensions;
    }
}

