/*
 * Decompiled with CFR 0.152.
 */
package com.soasta.mpulse.core.config;

import com.soasta.mpulse.core.MPLog;
import com.soasta.mpulse.core.beacons.MPApiCustomTimerBeacon;
import java.util.Arrays;
import org.json.JSONException;
import org.json.JSONObject;

public class MPConfigTimer {
    private String _name;
    private int _index;
    private String _type;
    private String _label;
    private boolean _hasStartTimerResponderInjected;
    private boolean _hasEndTimerResponderInjected;
    private MPApiCustomTimerBeacon _beacon;
    private static final String LOG_TAG = "MPConfigTimer";

    public MPConfigTimer(String jsonDataString) {
        this.initWithJson(jsonDataString);
    }

    public void initWithJson(String jsonDataString) {
        if (jsonDataString == null) {
            return;
        }
        try {
            JSONObject jsonData = new JSONObject(jsonDataString);
            this._name = jsonData.has("name") ? jsonData.getString("name") : null;
            this._index = jsonData.has("index") ? jsonData.getInt("index") : 0;
            this._type = jsonData.has("type") ? jsonData.getString("type") : null;
            this._label = jsonData.has("label") ? jsonData.getString("label") : null;
        }
        catch (JSONException e) {
            MPLog.warn(LOG_TAG, "JSONException from initWithJson", e);
        }
        this._hasStartTimerResponderInjected = false;
        this._hasEndTimerResponderInjected = false;
    }

    public String toString() {
        String startTimerResponderInjected = this._hasStartTimerResponderInjected ? "YES" : "NO";
        String endTimerResponderInjected = this._hasEndTimerResponderInjected ? "YES" : "NO";
        String timerString = "[MPConfigTimer: hasStartTimerResponderInjected " + startTimerResponderInjected + "hasEndTimerResponderInjected " + endTimerResponderInjected + ", beacon= " + this._beacon + ", name= " + this._name + ", index= " + this._index + ", type= " + this._type + ", label= " + this._label + "]";
        return timerString;
    }

    public int hashCode() {
        return Arrays.hashCode(new Object[]{this._name, this._type, this._label});
    }

    public boolean isEqualToTimer(MPConfigTimer timer) {
        if (timer == null) {
            return false;
        }
        boolean haveEqualIndex = this._index == timer.getIndex();
        boolean haveEqualNames = this._name == null && timer.getName() == null || this._name != null && this._name.equals(timer.getName());
        boolean haveEqualTypes = this._type == null && timer.getType() == null || this._type != null && this._type.equals(timer.getType());
        boolean haveEqualLabels = this._label == null && timer.getLabel() == null || this._label != null && this._label.equals(timer.getLabel());
        return haveEqualIndex && haveEqualNames && haveEqualTypes && haveEqualLabels;
    }

    public boolean equals(Object object) {
        if (object instanceof MPConfigTimer) {
            return this.isEqualToTimer((MPConfigTimer)object);
        }
        return false;
    }

    public boolean hasStartTimerResponderInjected() {
        return this._hasStartTimerResponderInjected;
    }

    public void setHasStartTimerResponderInjected(boolean hasStartTimerResponderInjected) {
        this._hasStartTimerResponderInjected = hasStartTimerResponderInjected;
    }

    public boolean hasEndTimerResponderInjected() {
        return this._hasEndTimerResponderInjected;
    }

    public void setHasEndTimerResponderInjected(boolean hasEndTimerResponderInjected) {
        this._hasEndTimerResponderInjected = hasEndTimerResponderInjected;
    }

    public String getName() {
        return this._name;
    }

    public int getIndex() {
        return this._index;
    }

    public String getType() {
        return this._type;
    }

    public String getLabel() {
        return this._label;
    }

    public MPApiCustomTimerBeacon getBeacon() {
        return this._beacon;
    }

    public void setBeacon(MPApiCustomTimerBeacon beacon) {
        this._beacon = beacon;
    }
}

